/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.daemon.impl.quickfix;

import com.intellij.codeInspection.IntentionAndQuickFixAction;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ui.configuration.ProjectSettingsService;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ShowModulePropertiesFix
extends IntentionAndQuickFixAction {
    private final String myModuleName;

    public ShowModulePropertiesFix(@NotNull PsiElement context) {
        this(ModuleUtilCore.findModuleForPsiElement((PsiElement)context));
    }

    public ShowModulePropertiesFix(@Nullable Module module2) {
        this.myModuleName = module2 == null ? null : module2.getName();
    }

    @NotNull
    public String getName() {
        AnAction action = ActionManager.getInstance().getAction("ModuleSettings");
        return action.getTemplatePresentation().getText();
    }

    @NotNull
    public String getFamilyName() {
        return this.getText();
    }

    public boolean isAvailable(@NotNull Project project2, Editor editor, PsiFile file2) {
        return this.myModuleName != null;
    }

    public void applyFix(@NotNull Project project2, PsiFile file2, @Nullable Editor editor) {
        ProjectSettingsService.getInstance(project2).showModuleConfigurationDialog(this.myModuleName, null);
    }

    public boolean startInWriteAction() {
        return false;
    }
}

