/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.daemon.impl.quickfix;

import com.intellij.codeInspection.LocalQuickFixAndIntentionActionOnPsiElement;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiPrimitiveType;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeElement;
import com.intellij.psi.PsiWildcardType;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ReplacePrimitiveWithBoxedTypeAction
extends LocalQuickFixAndIntentionActionOnPsiElement {
    private final String myPrimitiveName;
    private final String myBoxedTypeName;
    private static final Logger LOG = Logger.getInstance((String)("#" + ReplacePrimitiveWithBoxedTypeAction.class.getName()));

    public ReplacePrimitiveWithBoxedTypeAction(@NotNull PsiTypeElement element, @NotNull String typeName, @NotNull String boxedTypeName) {
        super((PsiElement)element);
        this.myPrimitiveName = typeName;
        this.myBoxedTypeName = boxedTypeName;
    }

    @NotNull
    public String getText() {
        return "Convert '" + this.myPrimitiveName + "' to '" + this.myBoxedTypeName + "'";
    }

    @NotNull
    public String getFamilyName() {
        return this.getText();
    }

    public boolean isAvailable(@NotNull Project project2, @NotNull PsiFile file2, @NotNull PsiElement startElement, @NotNull PsiElement endElement) {
        if (startElement instanceof PsiTypeElement) {
            PsiType type = ((PsiTypeElement)startElement).getType();
            if (type instanceof PsiWildcardType) {
                type = ((PsiWildcardType)type).getBound();
            }
            if (type instanceof PsiPrimitiveType) {
                return ((PsiPrimitiveType)type).getBoxedType(startElement) != null;
            }
        }
        return false;
    }

    public void invoke(@NotNull Project project2, @NotNull PsiFile file2, @Nullable(value="is null when called from inspection") Editor editor, @NotNull PsiElement startElement, @NotNull PsiElement endElement) {
        PsiClassType boxedType;
        PsiType type = ((PsiTypeElement)startElement).getType();
        if (type instanceof PsiPrimitiveType) {
            boxedType = ((PsiPrimitiveType)type).getBoxedType(startElement);
        } else {
            LOG.assertTrue(type instanceof PsiWildcardType);
            PsiWildcardType wildcardType = (PsiWildcardType)type;
            PsiClassType boxedBound = ((PsiPrimitiveType)wildcardType.getBound()).getBoxedType(startElement);
            LOG.assertTrue(boxedBound != null);
            boxedType = wildcardType.isExtends() ? PsiWildcardType.createExtends((PsiManager)startElement.getManager(), (PsiType)boxedBound) : PsiWildcardType.createSuper((PsiManager)startElement.getManager(), (PsiType)boxedBound);
        }
        LOG.assertTrue(boxedType != null);
        startElement.replace((PsiElement)JavaPsiFacade.getElementFactory((Project)project2).createTypeElement((PsiType)boxedType));
    }

    public boolean startInWriteAction() {
        return true;
    }
}

