/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.daemon.impl.quickfix;

import com.intellij.codeInsight.FileModificationService;
import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiFile;
import com.intellij.util.IncorrectOperationException;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;

public class ReplaceAssignmentFromVoidWithStatementIntentionAction
implements IntentionAction {
    private final PsiElement myParent;
    private final PsiExpression myLExpr;

    public ReplaceAssignmentFromVoidWithStatementIntentionAction(PsiElement parent, PsiExpression lExpr) {
        this.myParent = parent;
        this.myLExpr = lExpr;
    }

    @Nls
    @NotNull
    public String getText() {
        return this.getFamilyName();
    }

    @Nls
    @NotNull
    public String getFamilyName() {
        return "Remove left side of assignment";
    }

    public boolean isAvailable(@NotNull Project project2, Editor editor, PsiFile file2) {
        return true;
    }

    public void invoke(@NotNull Project project2, Editor editor, PsiFile file2) throws IncorrectOperationException {
        if (!FileModificationService.getInstance().prepareFileForWrite(file2)) {
            return;
        }
        this.myParent.replace((PsiElement)this.myLExpr);
    }

    public boolean startInWriteAction() {
        return true;
    }
}

