/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.daemon.impl.quickfix;

import com.intellij.codeInsight.CodeInsightBundle;
import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.openapi.application.Result;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.ex.MessagesEx;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiFile;
import java.io.IOException;
import org.jetbrains.annotations.NotNull;

public class RenameFileFix
implements IntentionAction,
LocalQuickFix {
    private final String myNewFileName;

    public RenameFileFix(@NotNull String newFileName) {
        this.myNewFileName = newFileName;
    }

    @NotNull
    public String getText() {
        return CodeInsightBundle.message((String)"rename.file.fix", (Object[])new Object[0]);
    }

    @NotNull
    public String getName() {
        return this.getText();
    }

    @NotNull
    public String getFamilyName() {
        return CodeInsightBundle.message((String)"rename.file.fix", (Object[])new Object[0]);
    }

    public void applyFix(final @NotNull Project project2, @NotNull ProblemDescriptor descriptor) {
        final PsiFile file2 = descriptor.getPsiElement().getContainingFile();
        if (this.isAvailable(project2, null, file2)) {
            new WriteCommandAction(project2, new PsiFile[0]){

                protected void run(@NotNull Result result) throws Throwable {
                    RenameFileFix.this.invoke(project2, null, file2);
                }
            }.execute();
        }
    }

    public final boolean isAvailable(@NotNull Project project2, Editor editor, PsiFile file2) {
        if (file2 == null || !file2.isValid()) {
            return false;
        }
        VirtualFile vFile = file2.getVirtualFile();
        if (vFile == null) {
            return false;
        }
        VirtualFile parent = vFile.getParent();
        if (parent == null) {
            return false;
        }
        VirtualFile newVFile = parent.findChild(this.myNewFileName);
        return newVFile == null || newVFile.equals(vFile);
    }

    public void invoke(@NotNull Project project2, Editor editor, PsiFile file2) {
        VirtualFile vFile = file2.getVirtualFile();
        Document document = PsiDocumentManager.getInstance((Project)project2).getDocument(file2);
        FileDocumentManager.getInstance().saveDocument(document);
        try {
            vFile.rename((Object)file2.getManager(), this.myNewFileName);
        }
        catch (IOException e) {
            MessagesEx.error(project2, e.getMessage()).showLater();
        }
    }

    public boolean startInWriteAction() {
        return true;
    }
}

