/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.daemon.impl.quickfix;

import com.intellij.codeInsight.FileModificationService;
import com.intellij.codeInsight.daemon.QuickFixBundle;
import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.util.IncorrectOperationException;
import org.jetbrains.annotations.NotNull;

public class RemoveQualifierFix
implements IntentionAction {
    private final PsiExpression myQualifier;
    private final PsiReferenceExpression myExpression;
    private final PsiClass myResolved;

    public RemoveQualifierFix(@NotNull PsiExpression qualifier, @NotNull PsiReferenceExpression expression, @NotNull PsiClass resolved) {
        this.myQualifier = qualifier;
        this.myExpression = expression;
        this.myResolved = resolved;
    }

    @NotNull
    public String getText() {
        return QuickFixBundle.message("remove.qualifier.action.text", new Object[0]);
    }

    @NotNull
    public String getFamilyName() {
        return this.getText();
    }

    public boolean isAvailable(@NotNull Project project2, Editor editor, PsiFile file2) {
        return this.myQualifier.isValid() && this.myQualifier.getManager().isInProject((PsiElement)this.myQualifier) && this.myExpression.isValid() && this.myResolved.isValid();
    }

    public void invoke(@NotNull Project project2, Editor editor, PsiFile file2) throws IncorrectOperationException {
        if (!FileModificationService.getInstance().prepareFileForWrite(file2)) {
            return;
        }
        this.myQualifier.delete();
        this.myExpression.bindToElement((PsiElement)this.myResolved);
    }

    public boolean startInWriteAction() {
        return true;
    }
}

