/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.daemon.impl.quickfix;

import com.intellij.codeInsight.FileModificationService;
import com.intellij.codeInsight.daemon.QuickFixBundle;
import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiNewExpression;
import com.intellij.util.IncorrectOperationException;
import org.jetbrains.annotations.NotNull;

public class RemoveNewQualifierFix
implements IntentionAction {
    private final PsiNewExpression expression;
    private final PsiClass aClass;

    public RemoveNewQualifierFix(@NotNull PsiNewExpression expression, PsiClass aClass) {
        this.expression = expression;
        this.aClass = aClass;
    }

    @NotNull
    public String getText() {
        return QuickFixBundle.message("remove.qualifier.fix", new Object[0]);
    }

    @NotNull
    public String getFamilyName() {
        return QuickFixBundle.message("remove.qualifier.fix", new Object[0]);
    }

    public boolean isAvailable(@NotNull Project project2, Editor editor, PsiFile file2) {
        return this.expression.isValid() && (this.aClass == null || this.aClass.isValid()) && this.expression.getManager().isInProject((PsiElement)this.expression);
    }

    public void invoke(@NotNull Project project2, Editor editor, PsiFile file2) throws IncorrectOperationException {
        if (!FileModificationService.getInstance().prepareFileForWrite(this.expression.getContainingFile())) {
            return;
        }
        PsiJavaCodeReferenceElement classReference = this.expression.getClassReference();
        this.expression.getQualifier().delete();
        if (this.aClass != null && classReference != null) {
            classReference.bindToElement((PsiElement)this.aClass);
        }
    }

    public boolean startInWriteAction() {
        return true;
    }
}

