/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.daemon.impl.quickfix;

import com.intellij.codeInsight.daemon.QuickFixActionRegistrar;
import com.intellij.codeInsight.daemon.impl.actions.AddImportAction;
import com.intellij.codeInsight.daemon.impl.quickfix.AddExternalLibraryToDependenciesQuickFix;
import com.intellij.codeInsight.daemon.impl.quickfix.AddLibraryToDependenciesFix;
import com.intellij.codeInsight.daemon.impl.quickfix.AddModuleDependencyFix;
import com.intellij.codeInsight.daemon.quickFix.ExternalLibraryResolver;
import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.DependencyScope;
import com.intellij.openapi.roots.ExportableOrderEntry;
import com.intellij.openapi.roots.ExternalLibraryDescriptor;
import com.intellij.openapi.roots.LibraryOrderEntry;
import com.intellij.openapi.roots.ModuleFileIndex;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.roots.ModuleRootModificationUtil;
import com.intellij.openapi.roots.OrderEntry;
import com.intellij.openapi.roots.OrderRootType;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.roots.libraries.Library;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.packageDependencies.DependencyValidationManager;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiImportStatement;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiReference;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.PsiShortNamesCache;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.util.Function;
import com.intellij.util.ThreeState;
import com.intellij.util.containers.ContainerUtil;
import gnu.trove.THashSet;
import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class OrderEntryFix
implements IntentionAction,
LocalQuickFix {
    protected OrderEntryFix() {
    }

    public boolean startInWriteAction() {
        return true;
    }

    @NotNull
    public String getName() {
        return this.getText();
    }

    public void applyFix(@NotNull Project project2, @NotNull ProblemDescriptor descriptor) {
        this.invoke(project2, null, descriptor.getPsiElement().getContainingFile());
    }

    @Nullable
    public static List<LocalQuickFix> registerFixes(@NotNull QuickFixActionRegistrar registrar, @NotNull PsiReference reference) {
        PsiElement psiElement = reference.getElement();
        String shortReferenceName = reference.getRangeInElement().substring(psiElement.getText());
        Project project2 = psiElement.getProject();
        PsiFile containingFile = psiElement.getContainingFile();
        if (containingFile == null) {
            return null;
        }
        VirtualFile classVFile = containingFile.getVirtualFile();
        if (classVFile == null) {
            return null;
        }
        ProjectFileIndex fileIndex = ProjectRootManager.getInstance((Project)project2).getFileIndex();
        Module currentModule = fileIndex.getModuleForFile(classVFile);
        if (currentModule == null) {
            return null;
        }
        ArrayList<LocalQuickFix> result = new ArrayList<LocalQuickFix>();
        JavaPsiFacade psiFacade = JavaPsiFacade.getInstance((Project)project2);
        String fullReferenceText = reference.getCanonicalText();
        for (ExternalLibraryResolver resolver : (ExternalLibraryResolver[])ExternalLibraryResolver.EP_NAME.getExtensions()) {
            ExternalLibraryDescriptor descriptor;
            ExternalLibraryResolver.ExternalClassResolveResult resolveResult = resolver.resolveClass(shortReferenceName, OrderEntryFix.isReferenceToAnnotation(psiElement), currentModule);
            AddExternalLibraryToDependenciesQuickFix fix = null;
            if (resolveResult != null && psiFacade.findClass(resolveResult.getQualifiedClassName(), currentModule.getModuleWithDependenciesAndLibrariesScope(true)) == null) {
                fix = new AddExternalLibraryToDependenciesQuickFix(currentModule, resolveResult.getLibrary(), reference, resolveResult.getQualifiedClassName());
            } else if (!fullReferenceText.equals(shortReferenceName) && (descriptor = resolver.resolvePackage(fullReferenceText)) != null) {
                fix = new AddExternalLibraryToDependenciesQuickFix(currentModule, descriptor, reference, null);
            }
            if (fix == null) continue;
            registrar.register(fix);
            result.add(fix);
        }
        if (!result.isEmpty()) {
            return result;
        }
        THashSet librariesToAdd = new THashSet();
        JavaPsiFacade facade = JavaPsiFacade.getInstance((Project)psiElement.getProject());
        PsiClass[] classes = PsiShortNamesCache.getInstance((Project)project2).getClassesByName(shortReferenceName, GlobalSearchScope.allScope((Project)project2));
        List<PsiClass> allowedDependencies = OrderEntryFix.filterAllowedDependencies(psiElement, classes);
        if (allowedDependencies.isEmpty()) {
            return result;
        }
        classes = allowedDependencies.toArray(new PsiClass[allowedDependencies.size()]);
        AddModuleDependencyFix moduleDependencyFix = new AddModuleDependencyFix(currentModule, classVFile, classes, reference);
        registrar.register((IntentionAction)moduleDependencyFix);
        result.add(moduleDependencyFix);
        for (PsiClass aClass : classes) {
            VirtualFile virtualFile;
            PsiFile psiFile;
            if (!facade.getResolveHelper().isAccessible((PsiMember)aClass, psiElement, aClass) || (psiFile = aClass.getContainingFile()) == null || (virtualFile = psiFile.getVirtualFile()) == null) continue;
            ModuleFileIndex moduleFileIndex = ModuleRootManager.getInstance((Module)currentModule).getFileIndex();
            for (OrderEntry orderEntry : fileIndex.getOrderEntriesForFile(virtualFile)) {
                OrderEntry entryForFile;
                VirtualFile jar;
                VirtualFile[] files;
                LibraryOrderEntry libraryEntry;
                Library library;
                if (!(orderEntry instanceof LibraryOrderEntry) || (library = (libraryEntry = (LibraryOrderEntry)orderEntry).getLibrary()) == null || (files = library.getFiles(OrderRootType.CLASSES)).length == 0 || (jar = files[0]) == null || libraryEntry.isModuleLevel() && !librariesToAdd.add(jar) || !librariesToAdd.add(library) || (entryForFile = moduleFileIndex.getOrderEntryForFile(virtualFile)) != null && (!(entryForFile instanceof ExportableOrderEntry) || ((ExportableOrderEntry)entryForFile).getScope() != DependencyScope.TEST || ModuleRootManager.getInstance((Module)currentModule).getFileIndex().isInTestSourceContent(classVFile))) continue;
                AddLibraryToDependenciesFix platformFix = new AddLibraryToDependenciesFix(currentModule, library, reference, aClass.getQualifiedName());
                registrar.register((IntentionAction)platformFix);
                result.add(platformFix);
            }
        }
        return result;
    }

    private static List<PsiClass> filterAllowedDependencies(PsiElement element, PsiClass[] classes) {
        DependencyValidationManager dependencyValidationManager = DependencyValidationManager.getInstance((Project)element.getProject());
        PsiFile fromFile = element.getContainingFile();
        ArrayList<PsiClass> result = new ArrayList<PsiClass>();
        for (PsiClass psiClass : classes) {
            if (dependencyValidationManager.getViolatorDependencyRule(fromFile, psiClass.getContainingFile()) != null) continue;
            result.add(psiClass);
        }
        return result;
    }

    private static ThreeState isReferenceToAnnotation(PsiElement psiElement) {
        if (!PsiUtil.isLanguageLevel5OrHigher((PsiElement)psiElement)) {
            return ThreeState.NO;
        }
        if (PsiTreeUtil.getParentOfType((PsiElement)psiElement, PsiAnnotation.class) != null) {
            return ThreeState.YES;
        }
        if (PsiTreeUtil.getParentOfType((PsiElement)psiElement, PsiImportStatement.class) != null) {
            return ThreeState.UNSURE;
        }
        return ThreeState.NO;
    }

    public static void importClass(final @NotNull Module currentModule, final @Nullable Editor editor, final @Nullable PsiReference reference, final @Nullable @NonNls String className) {
        final Project project2 = currentModule.getProject();
        if (editor != null && reference != null && className != null) {
            DumbService.getInstance((Project)project2).withAlternativeResolveEnabled(new Runnable(){

                @Override
                public void run() {
                    GlobalSearchScope scope = GlobalSearchScope.moduleWithLibrariesScope((Module)currentModule);
                    PsiClass aClass = JavaPsiFacade.getInstance((Project)project2).findClass(className, scope);
                    if (aClass != null) {
                        new AddImportAction(project2, reference, editor, aClass).execute();
                    }
                }
            });
        }
    }

    public static void addJarToRoots(@NotNull String jarPath, @NotNull Module module2, @Nullable PsiElement location) {
        OrderEntryFix.addJarsToRoots(Collections.singletonList(jarPath), null, module2, location);
    }

    public static void addJarsToRoots(@NotNull List<String> jarPaths, @Nullable String libraryName, @NotNull Module module2, @Nullable PsiElement location) {
        List<String> urls = OrderEntryFix.refreshAndConvertToUrls(jarPaths);
        DependencyScope scope = OrderEntryFix.suggestScopeByLocation(module2, location);
        ModuleRootModificationUtil.addModuleLibrary((Module)module2, (String)libraryName, urls, Collections.emptyList(), (DependencyScope)scope);
    }

    @NotNull
    public static List<String> refreshAndConvertToUrls(@NotNull List<String> jarPaths) {
        return ContainerUtil.map(jarPaths, (Function)new Function<String, String>(){

            public String fun(String path) {
                return OrderEntryFix.refreshAndConvertToUrl(path);
            }
        });
    }

    @NotNull
    public static DependencyScope suggestScopeByLocation(@NotNull Module module2, @Nullable PsiElement location) {
        VirtualFile vFile;
        if (location != null && (vFile = location.getContainingFile().getVirtualFile()) != null && ModuleRootManager.getInstance((Module)module2).getFileIndex().isInTestSourceContent(vFile)) {
            return DependencyScope.TEST;
        }
        return DependencyScope.COMPILE;
    }

    @NotNull
    private static String refreshAndConvertToUrl(String jarPath) {
        File libraryRoot = new File(jarPath);
        LocalFileSystem.getInstance().refreshAndFindFileByIoFile(libraryRoot);
        return VfsUtil.getUrlForLibraryRoot((File)libraryRoot);
    }
}

