/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.daemon.impl.quickfix;

import com.intellij.codeInsight.FileModificationService;
import com.intellij.codeInsight.daemon.QuickFixBundle;
import com.intellij.codeInsight.daemon.impl.analysis.JavaHighlightUtil;
import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiCatchSection;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiTryStatement;
import com.intellij.psi.PsiType;
import com.intellij.psi.util.PsiUtil;
import com.intellij.util.IncorrectOperationException;
import org.jetbrains.annotations.NotNull;

public class MoveCatchUpFix
implements IntentionAction {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.codeInsight.daemon.impl.quickfix.DeleteCatchFix");
    private final PsiCatchSection myCatchSection;
    private final PsiCatchSection myMoveBeforeSection;

    public MoveCatchUpFix(@NotNull PsiCatchSection catchSection, @NotNull PsiCatchSection moveBeforeSection) {
        this.myCatchSection = catchSection;
        this.myMoveBeforeSection = moveBeforeSection;
    }

    @NotNull
    public String getText() {
        return QuickFixBundle.message("move.catch.up.text", JavaHighlightUtil.formatType(this.myCatchSection.getCatchType()), JavaHighlightUtil.formatType(this.myMoveBeforeSection.getCatchType()));
    }

    @NotNull
    public String getFamilyName() {
        return QuickFixBundle.message("move.catch.up.family", new Object[0]);
    }

    public boolean isAvailable(@NotNull Project project2, Editor editor, PsiFile file2) {
        return this.myCatchSection.isValid() && this.myCatchSection.getManager().isInProject((PsiElement)this.myCatchSection) && this.myMoveBeforeSection.isValid() && this.myCatchSection.getCatchType() != null && PsiUtil.resolveClassInType((PsiType)this.myCatchSection.getCatchType()) != null && this.myMoveBeforeSection.getCatchType() != null && PsiUtil.resolveClassInType((PsiType)this.myMoveBeforeSection.getCatchType()) != null && !this.myCatchSection.getManager().areElementsEquivalent((PsiElement)PsiUtil.resolveClassInType((PsiType)this.myCatchSection.getCatchType()), (PsiElement)PsiUtil.resolveClassInType((PsiType)this.myMoveBeforeSection.getCatchType()));
    }

    public void invoke(@NotNull Project project2, Editor editor, PsiFile file2) {
        if (!FileModificationService.getInstance().prepareFileForWrite(this.myCatchSection.getContainingFile())) {
            return;
        }
        try {
            PsiTryStatement statement2 = this.myCatchSection.getTryStatement();
            statement2.addBefore((PsiElement)this.myCatchSection, (PsiElement)this.myMoveBeforeSection);
            this.myCatchSection.delete();
        }
        catch (IncorrectOperationException e) {
            LOG.error((Throwable)e);
        }
    }

    public boolean startInWriteAction() {
        return true;
    }
}

