/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.daemon.impl.quickfix;

import com.intellij.codeInsight.FileModificationService;
import com.intellij.codeInsight.daemon.QuickFixBundle;
import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiMethod;
import com.intellij.util.IncorrectOperationException;
import org.jetbrains.annotations.NotNull;

public class MakeMethodConstructorFix
implements IntentionAction {
    private final PsiMethod myMethod;

    public MakeMethodConstructorFix(PsiMethod method) {
        this.myMethod = method;
    }

    @NotNull
    public String getText() {
        return QuickFixBundle.message("convert.method.to.constructor", new Object[0]);
    }

    @NotNull
    public String getFamilyName() {
        return this.getText();
    }

    public boolean isAvailable(@NotNull Project project2, Editor editor, PsiFile file2) {
        return this.myMethod.isValid() && this.myMethod.getReturnTypeElement() != null && this.myMethod.getManager().isInProject((PsiElement)this.myMethod);
    }

    public void invoke(@NotNull Project project2, Editor editor, PsiFile file2) throws IncorrectOperationException {
        if (!FileModificationService.getInstance().preparePsiElementForWrite((PsiElement)this.myMethod)) {
            return;
        }
        this.myMethod.getReturnTypeElement().delete();
    }

    public boolean startInWriteAction() {
        return true;
    }
}

