/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.daemon.impl.quickfix;

import com.intellij.codeInsight.FileModificationService;
import com.intellij.codeInsight.daemon.QuickFixBundle;
import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiExpressionList;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiNewExpression;
import com.intellij.util.IncorrectOperationException;
import org.jetbrains.annotations.NotNull;

public class InsertNewFix
implements IntentionAction {
    private final PsiMethodCallExpression myMethodCall;
    private final PsiClass myClass;

    public InsertNewFix(@NotNull PsiMethodCallExpression methodCall, @NotNull PsiClass aClass) {
        this.myMethodCall = methodCall;
        this.myClass = aClass;
    }

    @NotNull
    public String getText() {
        return QuickFixBundle.message("insert.new.fix", new Object[0]);
    }

    @NotNull
    public String getFamilyName() {
        return this.getText();
    }

    public boolean isAvailable(@NotNull Project project2, Editor editor, PsiFile file2) {
        return this.myMethodCall.isValid() && this.myMethodCall.getManager().isInProject((PsiElement)this.myMethodCall);
    }

    public void invoke(@NotNull Project project2, Editor editor, PsiFile file2) throws IncorrectOperationException {
        if (!FileModificationService.getInstance().prepareFileForWrite(this.myMethodCall.getContainingFile())) {
            return;
        }
        PsiElementFactory factory = JavaPsiFacade.getInstance((Project)this.myMethodCall.getProject()).getElementFactory();
        PsiNewExpression newExpression = (PsiNewExpression)factory.createExpressionFromText("new X()", null);
        PsiJavaCodeReferenceElement classReference = newExpression.getClassReference();
        assert (classReference != null);
        classReference.replace((PsiElement)factory.createClassReferenceElement(this.myClass));
        PsiExpressionList argumentList = newExpression.getArgumentList();
        assert (argumentList != null);
        argumentList.replace((PsiElement)this.myMethodCall.getArgumentList());
        this.myMethodCall.replace((PsiElement)newExpression);
    }

    public boolean startInWriteAction() {
        return true;
    }
}

