/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.daemon.impl.quickfix;

import com.intellij.codeInsight.FileModificationService;
import com.intellij.codeInsight.daemon.QuickFixBundle;
import com.intellij.codeInsight.daemon.impl.quickfix.AddDefaultConstructorFix;
import com.intellij.codeInsight.daemon.impl.quickfix.AddVariableInitializerFix;
import com.intellij.codeInsight.generation.ClassMember;
import com.intellij.codeInsight.generation.PsiMethodMember;
import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.ide.util.MemberChooser;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiAssignmentExpression;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionStatement;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.codeStyle.CodeStyleManager;
import com.intellij.psi.search.LocalSearchScope;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.search.searches.ReferencesSearch;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.util.IncorrectOperationException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class InitializeFinalFieldInConstructorFix
implements IntentionAction {
    private final PsiField myField;

    public InitializeFinalFieldInConstructorFix(@NotNull PsiField field) {
        this.myField = field;
    }

    @NotNull
    public String getText() {
        return QuickFixBundle.message("initialize.final.field.in.constructor.name", new Object[0]);
    }

    @NotNull
    public String getFamilyName() {
        return this.getText();
    }

    public boolean isAvailable(@NotNull Project project2, Editor editor, PsiFile file2) {
        if (!this.myField.isValid() || this.myField.hasModifierProperty("static") || this.myField.hasInitializer()) {
            return false;
        }
        PsiClass containingClass = this.myField.getContainingClass();
        if (containingClass == null || containingClass.getName() == null) {
            return false;
        }
        PsiManager manager = this.myField.getManager();
        return manager != null && manager.isInProject((PsiElement)this.myField);
    }

    public void invoke(final @NotNull Project project2, final Editor editor, PsiFile file2) throws IncorrectOperationException {
        if (!FileModificationService.getInstance().prepareFileForWrite(file2)) {
            return;
        }
        PsiClass myClass = this.myField.getContainingClass();
        if (myClass == null) {
            return;
        }
        if (myClass.getConstructors().length == 0) {
            InitializeFinalFieldInConstructorFix.createDefaultConstructor(myClass, project2, editor, file2);
        }
        final List<PsiMethod> constructors = InitializeFinalFieldInConstructorFix.choose(InitializeFinalFieldInConstructorFix.filterIfFieldAlreadyAssigned(this.myField, myClass.getConstructors()), project2);
        ApplicationManager.getApplication().runWriteAction(new Runnable(){

            @Override
            public void run() {
                InitializeFinalFieldInConstructorFix.addFieldInitialization(constructors, InitializeFinalFieldInConstructorFix.this.myField, project2, editor);
            }
        });
    }

    private static void addFieldInitialization(@NotNull List<PsiMethod> constructors, @NotNull PsiField field, @NotNull Project project2, @Nullable Editor editor) {
        if (constructors.isEmpty()) {
            return;
        }
        ArrayList<PsiExpression> rExpressions = new ArrayList<PsiExpression>(constructors.size());
        LookupElement[] suggestedInitializers = AddVariableInitializerFix.suggestInitializer((PsiVariable)field);
        for (PsiMethod constructor : constructors) {
            rExpressions.add(InitializeFinalFieldInConstructorFix.addFieldInitialization(constructor, suggestedInitializers, field, project2));
        }
        AddVariableInitializerFix.runAssignmentTemplate(rExpressions, suggestedInitializers, editor);
    }

    @Nullable
    private static PsiExpression addFieldInitialization(@NotNull PsiMethod constructor, @NotNull LookupElement[] suggestedInitializers, @NotNull PsiField field, @NotNull Project project2) {
        PsiCodeBlock methodBody = constructor.getBody();
        if (methodBody == null) {
            return null;
        }
        String fieldName = field.getName();
        String stmtText = fieldName + " = " + suggestedInitializers[0].getPsiElement().getText() + ";";
        if (InitializeFinalFieldInConstructorFix.methodContainsParameterWithName(constructor, fieldName)) {
            stmtText = "this." + stmtText;
        }
        PsiManager psiManager = PsiManager.getInstance((Project)project2);
        PsiElementFactory factory = JavaPsiFacade.getInstance((Project)psiManager.getProject()).getElementFactory();
        CodeStyleManager codeStyleManager = CodeStyleManager.getInstance((Project)project2);
        PsiExpressionStatement addedStatement = (PsiExpressionStatement)methodBody.add(codeStyleManager.reformat((PsiElement)factory.createStatementFromText(stmtText, (PsiElement)methodBody)));
        return ((PsiAssignmentExpression)addedStatement.getExpression()).getRExpression();
    }

    private static boolean methodContainsParameterWithName(@NotNull PsiMethod constructor, @NotNull String name) {
        for (PsiParameter parameter : constructor.getParameterList().getParameters()) {
            if (!name.equals(parameter.getName())) continue;
            return true;
        }
        return false;
    }

    @NotNull
    private static List<PsiMethod> choose(@NotNull PsiMethod[] ctors, @NotNull Project project2) {
        if (ApplicationManager.getApplication().isUnitTestMode()) {
            return Arrays.asList(ctors);
        }
        if (ctors.length == 1) {
            return Arrays.asList(ctors[0]);
        }
        if (ctors.length > 1) {
            MemberChooser chooser = new MemberChooser((ClassMember[])InitializeFinalFieldInConstructorFix.toPsiMethodMemberArray(ctors), false, true, project2);
            chooser.setTitle(QuickFixBundle.message("initialize.final.field.in.constructor.choose.dialog.title", new Object[0]));
            chooser.show();
            List<PsiMethodMember> chosenMembers = chooser.getSelectedElements();
            if (chosenMembers != null) {
                return Arrays.asList(InitializeFinalFieldInConstructorFix.toPsiMethodArray(chosenMembers));
            }
        }
        return Collections.emptyList();
    }

    private static PsiMethodMember[] toPsiMethodMemberArray(@NotNull PsiMethod[] methods) {
        PsiMethodMember[] result = new PsiMethodMember[methods.length];
        for (int i = 0; i < methods.length; ++i) {
            result[i] = new PsiMethodMember(methods[i]);
        }
        return result;
    }

    private static PsiMethod[] toPsiMethodArray(@NotNull List<PsiMethodMember> methodMembers) {
        PsiMethod[] result = new PsiMethod[methodMembers.size()];
        int i = 0;
        for (PsiMethodMember methodMember : methodMembers) {
            result[i++] = (PsiMethod)methodMember.getElement();
        }
        return result;
    }

    private static void createDefaultConstructor(PsiClass psiClass, final @NotNull Project project2, final Editor editor, final PsiFile file2) {
        final AddDefaultConstructorFix defaultConstructorFix = new AddDefaultConstructorFix(psiClass);
        ApplicationManager.getApplication().runWriteAction(new Runnable(){

            @Override
            public void run() {
                defaultConstructorFix.invoke(project2, editor, file2);
            }
        });
    }

    private static PsiMethod[] filterIfFieldAlreadyAssigned(@NotNull PsiField field, @NotNull PsiMethod[] ctors) {
        ArrayList<PsiMethod> result = new ArrayList<PsiMethod>(Arrays.asList(ctors));
        for (PsiReference reference : ReferencesSearch.search((PsiElement)field, (SearchScope)new LocalSearchScope((PsiElement[])ctors))) {
            PsiElement element = reference.getElement();
            if (!(element instanceof PsiReferenceExpression) || !PsiUtil.isOnAssignmentLeftHand((PsiExpression)((PsiExpression)element))) continue;
            result.remove(PsiTreeUtil.getParentOfType((PsiElement)element, PsiMethod.class));
        }
        return result.toArray(new PsiMethod[result.size()]);
    }

    public boolean startInWriteAction() {
        return false;
    }
}

