/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.daemon.impl.quickfix;

import com.intellij.codeInsight.daemon.impl.quickfix.DelegateWithDefaultParamValueIntentionAction;
import com.intellij.codeInsight.generation.ClassMember;
import com.intellij.codeInsight.intention.impl.ParameterClassMember;
import com.intellij.ide.util.MemberChooser;
import com.intellij.lang.java.JavaLanguage;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiParameterList;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtil;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DefineParamsDefaultValueAction
extends DelegateWithDefaultParamValueIntentionAction {
    @Override
    public boolean isAvailable(@NotNull Project project2, Editor editor, @NotNull PsiElement element) {
        if (!JavaLanguage.INSTANCE.equals(element.getLanguage())) {
            return false;
        }
        PsiElement parent = PsiTreeUtil.getParentOfType((PsiElement)element, (Class[])new Class[]{PsiMethod.class, PsiCodeBlock.class});
        if (!(parent instanceof PsiMethod)) {
            return false;
        }
        PsiMethod method = (PsiMethod)parent;
        PsiParameterList parameterList = method.getParameterList();
        if (parameterList.getParametersCount() == 0) {
            return false;
        }
        PsiClass containingClass = method.getContainingClass();
        if (containingClass == null || containingClass.isInterface() && !PsiUtil.isLanguageLevel8OrHigher((PsiElement)method)) {
            return false;
        }
        this.setText("Generate overloaded " + (method.isConstructor() ? "constructor" : "method") + " with default parameter values");
        return true;
    }

    @Override
    @Nullable
    protected PsiParameter[] getParams(PsiElement element) {
        List elements;
        PsiMethod method = (PsiMethod)PsiTreeUtil.getParentOfType((PsiElement)element, PsiMethod.class);
        assert (method != null);
        PsiParameter[] parameters = method.getParameterList().getParameters();
        ClassMember[] members = new ParameterClassMember[parameters.length];
        for (int i = 0; i < members.length; ++i) {
            members[i] = new ParameterClassMember(parameters[i]);
        }
        MemberChooser chooser = new MemberChooser(members, false, true, element.getProject());
        chooser.selectElements(members);
        chooser.setTitle("Choose Default Value Parameters");
        if (chooser.showAndGet() && (elements = chooser.getSelectedElements()) != null) {
            PsiParameter[] params = new PsiParameter[elements.size()];
            for (int i = 0; i < params.length; ++i) {
                params[i] = ((ParameterClassMember)elements.get(i)).getParameter();
            }
            return params;
        }
        return null;
    }

    public boolean startInWriteAction() {
        return false;
    }

    @Override
    @NotNull
    public String getFamilyName() {
        return "Generate overloaded method with default parameter values";
    }
}

