/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.daemon.impl.quickfix;

import com.intellij.codeInsight.ExpectedTypeInfo;
import com.intellij.codeInsight.FileModificationService;
import com.intellij.codeInsight.daemon.QuickFixBundle;
import com.intellij.codeInsight.daemon.impl.quickfix.CreateMethodFromUsageFix;
import com.intellij.codeInspection.LocalQuickFixAndIntentionActionOnPsiElement;
import com.intellij.lang.Language;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.psi.JVMElementFactories;
import com.intellij.psi.JVMElementFactory;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.PsiType;
import com.intellij.psi.codeStyle.JavaCodeStyleManager;
import com.intellij.psi.util.PsiFormatUtil;
import com.intellij.util.Function;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.containers.ContainerUtil;
import java.util.List;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CreateMethodQuickFix
extends LocalQuickFixAndIntentionActionOnPsiElement {
    protected final String mySignature;
    protected final String myBody;

    private CreateMethodQuickFix(PsiClass targetClass, @NonNls String signature, @NonNls String body) {
        super((PsiElement)targetClass);
        this.mySignature = signature;
        this.myBody = body;
    }

    @NotNull
    public String getText() {
        PsiClass myTargetClass = (PsiClass)this.getStartElement();
        String signature = myTargetClass == null ? "" : PsiFormatUtil.formatMethod((PsiMethod)this.createMethod(myTargetClass), (PsiSubstitutor)PsiSubstitutor.EMPTY, (int)65795, (int)65538, (int)2);
        return QuickFixBundle.message("create.method.from.usage.text", signature);
    }

    @NotNull
    public String getFamilyName() {
        return QuickFixBundle.message("create.method.from.usage.family", new Object[0]);
    }

    public void invoke(@NotNull Project project2, @NotNull PsiFile file2, @Nullable(value="is null when called from inspection") Editor editor, @NotNull PsiElement startElement, @NotNull PsiElement endElement) {
        PsiClass myTargetClass = (PsiClass)startElement;
        if (!FileModificationService.getInstance().preparePsiElementForWrite((PsiElement)myTargetClass.getContainingFile())) {
            return;
        }
        PsiMethod method = this.createMethod(myTargetClass);
        List arguments = ContainerUtil.map2List((Object[])method.getParameterList().getParameters(), (Function)new Function<PsiParameter, Pair<PsiExpression, PsiType>>(){

            public Pair<PsiExpression, PsiType> fun(PsiParameter psiParameter) {
                return Pair.create(null, (Object)psiParameter.getType());
            }
        });
        method = (PsiMethod)JavaCodeStyleManager.getInstance((Project)project2).shortenClassReferences(myTargetClass.add((PsiElement)method));
        CreateMethodFromUsageFix.doCreate(myTargetClass, method, arguments, PsiSubstitutor.EMPTY, ExpectedTypeInfo.EMPTY_ARRAY, (PsiElement)method);
    }

    private PsiMethod createMethod(@NotNull PsiClass myTargetClass) {
        Project project2 = myTargetClass.getProject();
        JVMElementFactory elementFactory = JVMElementFactories.getFactory((Language)myTargetClass.getLanguage(), (Project)project2);
        if (elementFactory == null) {
            elementFactory = JavaPsiFacade.getElementFactory((Project)project2);
        }
        String methodText = this.mySignature + (myTargetClass.isInterface() ? ";" : "{" + this.myBody + "}");
        return elementFactory.createMethodFromText(methodText, null);
    }

    @Nullable
    public static CreateMethodQuickFix createFix(@NotNull PsiClass targetClass, @NonNls String signature, @NonNls String body) {
        CreateMethodQuickFix fix = new CreateMethodQuickFix(targetClass, signature, body);
        try {
            fix.createMethod(targetClass);
            return fix;
        }
        catch (IncorrectOperationException e) {
            return null;
        }
    }
}

