/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.daemon.impl.quickfix;

import com.intellij.codeInsight.ExpectedTypeInfo;
import com.intellij.codeInsight.ExpectedTypeInfoImpl;
import com.intellij.codeInsight.TailType;
import com.intellij.codeInsight.daemon.QuickFixBundle;
import com.intellij.codeInsight.daemon.impl.quickfix.CreateFromUsageBaseFix;
import com.intellij.codeInsight.daemon.impl.quickfix.CreateMethodFromUsageFix;
import com.intellij.lang.Language;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.psi.JVMElementFactories;
import com.intellij.psi.JVMElementFactory;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.LambdaUtil;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassInitializer;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodReferenceExpression;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiNameHelper;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.PsiType;
import com.intellij.psi.SmartPointerManager;
import com.intellij.psi.SmartPsiElementPointer;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.util.Function;
import com.intellij.util.containers.ContainerUtil;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CreateMethodFromMethodReferenceFix
extends CreateFromUsageBaseFix {
    private static final Logger LOG = Logger.getInstance((String)("#" + CreateMethodFromMethodReferenceFix.class.getName()));
    private final SmartPsiElementPointer myMethodReferenceExpression;

    public CreateMethodFromMethodReferenceFix(@NotNull PsiMethodReferenceExpression methodRef) {
        this.myMethodReferenceExpression = SmartPointerManager.getInstance((Project)methodRef.getProject()).createSmartPsiElementPointer((PsiElement)methodRef);
    }

    @Override
    protected boolean isAvailableImpl(int offset) {
        PsiMethodReferenceExpression call = this.getMethodReference();
        if (call == null || !call.isValid()) {
            return false;
        }
        PsiType functionalInterfaceType = call.getFunctionalInterfaceType();
        if (functionalInterfaceType == null || LambdaUtil.getFunctionalInterfaceMethod((PsiType)functionalInterfaceType) == null) {
            return false;
        }
        String name = call.getReferenceName();
        if (name == null) {
            return false;
        }
        if (call.isConstructor() && name.equals("new") || PsiNameHelper.getInstance((Project)call.getProject()).isIdentifier(name)) {
            this.setText(call.isConstructor() ? QuickFixBundle.message("create.constructor.from.new.text", new Object[0]) : QuickFixBundle.message("create.method.from.usage.text", name));
            return true;
        }
        return false;
    }

    @Override
    protected PsiElement getElement() {
        PsiMethodReferenceExpression call = this.getMethodReference();
        if (call == null || !call.getManager().isInProject((PsiElement)call)) {
            return null;
        }
        return call;
    }

    @Override
    @NotNull
    protected List<PsiClass> getTargetClasses(PsiElement element) {
        List<PsiClass> targets = super.getTargetClasses(element);
        PsiMethodReferenceExpression call = this.getMethodReference();
        if (call == null) {
            return Collections.emptyList();
        }
        return targets;
    }

    @Override
    protected void invokeImpl(PsiClass targetClass) {
        PsiMethod method;
        if (targetClass == null) {
            return;
        }
        PsiMethodReferenceExpression expression = this.getMethodReference();
        if (expression == null) {
            return;
        }
        if (this.isValidElement((PsiElement)expression)) {
            return;
        }
        PsiClass parentClass = (PsiClass)PsiTreeUtil.getParentOfType((PsiElement)expression, PsiClass.class);
        PsiMember enclosingContext = (PsiMember)PsiTreeUtil.getParentOfType((PsiElement)expression, (Class[])new Class[]{PsiMethod.class, PsiField.class, PsiClassInitializer.class});
        String methodName = expression.getReferenceName();
        LOG.assertTrue(methodName != null);
        Project project2 = targetClass.getProject();
        JVMElementFactory elementFactory = JVMElementFactories.getFactory((Language)targetClass.getLanguage(), (Project)project2);
        if (elementFactory == null) {
            elementFactory = JavaPsiFacade.getElementFactory((Project)project2);
        }
        PsiMethod psiMethod = method = expression.isConstructor() ? (PsiMethod)targetClass.add((PsiElement)elementFactory.createConstructor()) : CreateMethodFromUsageFix.createMethod(targetClass, parentClass, enclosingContext, methodName);
        if (method == null) {
            return;
        }
        if (!expression.isConstructor()) {
            this.setupVisibility(parentClass, targetClass, method.getModifierList());
        }
        expression = this.getMethodReference();
        LOG.assertTrue(expression.isValid());
        if (!expression.isConstructor() && CreateMethodFromMethodReferenceFix.shouldCreateStaticMember((PsiReferenceExpression)expression, targetClass)) {
            PsiUtil.setModifierProperty((PsiModifierListOwner)method, (String)"static", (boolean)true);
        }
        PsiElement context = PsiTreeUtil.getParentOfType((PsiElement)expression, (Class[])new Class[]{PsiClass.class, PsiMethod.class});
        PsiType functionalInterfaceType = expression.getFunctionalInterfaceType();
        PsiClassType.ClassResolveResult classResolveResult = PsiUtil.resolveGenericsClassInType((PsiType)functionalInterfaceType);
        PsiMethod interfaceMethod = LambdaUtil.getFunctionalInterfaceMethod((PsiClassType.ClassResolveResult)classResolveResult);
        LOG.assertTrue(interfaceMethod != null);
        PsiType interfaceReturnType = LambdaUtil.getFunctionalInterfaceReturnType((PsiType)functionalInterfaceType);
        LOG.assertTrue(interfaceReturnType != null);
        final PsiSubstitutor substitutor = LambdaUtil.getSubstitutor((PsiMethod)interfaceMethod, (PsiClassType.ClassResolveResult)classResolveResult);
        ExpectedTypeInfo[] expectedTypes = new ExpectedTypeInfo[]{new ExpectedTypeInfoImpl(interfaceReturnType, 1, interfaceReturnType, TailType.NONE, null, ExpectedTypeInfoImpl.NULL)};
        CreateMethodFromUsageFix.doCreate(targetClass, method, false, ContainerUtil.map2List((Object[])interfaceMethod.getParameterList().getParameters(), (Function)new Function<PsiParameter, Pair<PsiExpression, PsiType>>(){

            public Pair<PsiExpression, PsiType> fun(PsiParameter parameter) {
                return Pair.create(null, (Object)substitutor.substitute(parameter.getType()));
            }
        }), PsiSubstitutor.EMPTY, expectedTypes, context);
    }

    @Override
    protected boolean isValidElement(PsiElement element) {
        return false;
    }

    @NotNull
    public String getFamilyName() {
        return QuickFixBundle.message("create.method.from.usage.family", new Object[0]);
    }

    @Nullable
    protected PsiMethodReferenceExpression getMethodReference() {
        return (PsiMethodReferenceExpression)this.myMethodReferenceExpression.getElement();
    }
}

