/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.daemon.impl.quickfix;

import com.intellij.codeInsight.FileModificationService;
import com.intellij.codeInsight.daemon.QuickFixBundle;
import com.intellij.codeInsight.daemon.impl.quickfix.AnonymousTargetClassPreselectionUtil;
import com.intellij.codeInsight.intention.impl.BaseIntentionAction;
import com.intellij.codeInsight.template.Template;
import com.intellij.codeInsight.template.TemplateEditingListener;
import com.intellij.codeInsight.template.TemplateManager;
import com.intellij.ide.util.PsiClassListCellRenderer;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.command.CommandProcessor;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.fileEditor.OpenFileDescriptor;
import com.intellij.openapi.fileEditor.ex.IdeDocumentHistory;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.popup.PopupChooserBuilder;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.JavaResolveResult;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionList;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiMethodReferenceExpression;
import com.intellij.psi.PsiModifier;
import com.intellij.psi.PsiModifierList;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiNameValuePair;
import com.intellij.psi.PsiNewExpression;
import com.intellij.psi.PsiParenthesizedExpression;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.PsiSwitchLabelStatement;
import com.intellij.psi.PsiSwitchStatement;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeElement;
import com.intellij.psi.PsiTypeParameter;
import com.intellij.psi.codeStyle.CodeStyleSettingsManager;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.ui.components.JBList;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.VisibilityUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import javax.swing.JList;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class CreateFromUsageBaseFix
extends BaseIntentionAction {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.codeInsight.daemon.impl.quickfix.CreateFromUsageBaseFix");

    public boolean isAvailable(@NotNull Project project2, Editor editor, PsiFile file2) {
        PsiElement element = this.getElement();
        if (element == null || this.isValidElement(element)) {
            return false;
        }
        int offset = editor.getCaretModel().getOffset();
        if (!this.isAvailableImpl(offset)) {
            return false;
        }
        List<PsiClass> targetClasses = this.getTargetClasses(element);
        return !targetClasses.isEmpty();
    }

    protected abstract boolean isAvailableImpl(int var1);

    protected abstract void invokeImpl(PsiClass var1);

    protected abstract boolean isValidElement(PsiElement var1);

    public void invoke(@NotNull Project project2, Editor editor, PsiFile file2) {
        PsiDocumentManager.getInstance((Project)project2).commitAllDocuments();
        PsiElement element = this.getElement();
        if (LOG.isDebugEnabled()) {
            LOG.debug("CreateFromUsage: element =" + element);
        }
        if (element == null) {
            return;
        }
        List<PsiClass> targetClasses = this.getTargetClasses(element);
        if (targetClasses.isEmpty()) {
            return;
        }
        if (targetClasses.size() == 1 || ApplicationManager.getApplication().isUnitTestMode()) {
            this.doInvoke(project2, targetClasses.get(0));
        } else {
            this.chooseTargetClass(targetClasses, editor);
        }
    }

    private void doInvoke(Project project2, final PsiClass targetClass) {
        if (!FileModificationService.getInstance().prepareFileForWrite(targetClass.getContainingFile())) {
            return;
        }
        IdeDocumentHistory.getInstance(project2).includeCurrentPlaceAsChangePlace();
        ApplicationManager.getApplication().runWriteAction(new Runnable(){

            @Override
            public void run() {
                CreateFromUsageBaseFix.this.invokeImpl(targetClass);
            }
        });
    }

    @Nullable
    protected abstract PsiElement getElement();

    private void chooseTargetClass(List<PsiClass> classes, Editor editor) {
        PsiClass firstClass = classes.get(0);
        Project project2 = firstClass.getProject();
        JBList list = new JBList(classes);
        PsiClassListCellRenderer renderer = new PsiClassListCellRenderer();
        list.setSelectionMode(0);
        list.setCellRenderer(renderer);
        PopupChooserBuilder builder = new PopupChooserBuilder((JList)list);
        renderer.installSpeedSearch(builder);
        PsiClass preselection = AnonymousTargetClassPreselectionUtil.getPreselection(classes, firstClass);
        if (preselection != null) {
            list.setSelectedValue(preselection, true);
        }
        Runnable runnable2 = new Runnable((JList)list, firstClass, project2){
            final /* synthetic */ JList val$list;
            final /* synthetic */ PsiClass val$firstClass;
            final /* synthetic */ Project val$project;
            {
                this.val$list = jList;
                this.val$firstClass = psiClass;
                this.val$project = project2;
            }

            @Override
            public void run() {
                int index = this.val$list.getSelectedIndex();
                if (index < 0) {
                    return;
                }
                final PsiClass aClass = (PsiClass)this.val$list.getSelectedValue();
                AnonymousTargetClassPreselectionUtil.rememberSelection(aClass, this.val$firstClass);
                CommandProcessor.getInstance().executeCommand(this.val$project, new Runnable(){

                    @Override
                    public void run() {
                        CreateFromUsageBaseFix.this.doInvoke(val$project, aClass);
                    }
                }, CreateFromUsageBaseFix.this.getText(), null);
            }
        };
        builder.setTitle(QuickFixBundle.message("target.class.chooser.title", new Object[0])).setItemChoosenCallback(runnable2).createPopup().showInBestPositionFor(editor);
    }

    @Nullable(value="null means unable to open the editor")
    protected static Editor positionCursor(@NotNull Project project2, @NotNull PsiFile targetFile, @NotNull PsiElement element) {
        TextRange range = element.getTextRange();
        LOG.assertTrue(range != null, element.getClass());
        int textOffset = range.getStartOffset();
        VirtualFile file2 = targetFile.getVirtualFile();
        if (file2 == null && (file2 = PsiUtilCore.getVirtualFile((PsiElement)element)) == null) {
            return null;
        }
        OpenFileDescriptor descriptor = new OpenFileDescriptor(project2, file2, textOffset);
        return FileEditorManager.getInstance((Project)project2).openTextEditor(descriptor, true);
    }

    protected void setupVisibility(PsiClass parentClass, @NotNull PsiClass targetClass, PsiModifierList list) throws IncorrectOperationException {
        if (targetClass.isInterface() && list.getFirstChild() != null) {
            list.deleteChildRange(list.getFirstChild(), list.getLastChild());
            return;
        }
        if (targetClass.isInterface()) {
            return;
        }
        String visibility = this.getVisibility(parentClass, targetClass);
        if ("EscalateVisible".equals(visibility)) {
            list.setModifierProperty("private", true);
            VisibilityUtil.escalateVisibility((PsiModifierList)list, (PsiElement)parentClass);
        } else {
            VisibilityUtil.setVisibility((PsiModifierList)list, (String)visibility);
        }
    }

    @PsiModifier.ModifierConstant
    protected String getVisibility(PsiClass parentClass, @NotNull PsiClass targetClass) {
        if (parentClass != null && (parentClass.equals(targetClass) || PsiTreeUtil.isAncestor((PsiElement)targetClass, (PsiElement)parentClass, (boolean)true))) {
            return "private";
        }
        return CodeStyleSettingsManager.getSettings((Project)targetClass.getProject()).VISIBILITY;
    }

    protected static boolean shouldCreateStaticMember(PsiReferenceExpression ref, PsiClass targetClass) {
        PsiExpression qualifierExpression = ref.getQualifierExpression();
        while (qualifierExpression instanceof PsiParenthesizedExpression) {
            qualifierExpression = ((PsiParenthesizedExpression)qualifierExpression).getExpression();
        }
        if (qualifierExpression instanceof PsiReferenceExpression) {
            PsiReferenceExpression referenceExpression = (PsiReferenceExpression)qualifierExpression;
            PsiElement resolvedElement = referenceExpression.resolve();
            return resolvedElement instanceof PsiClass;
        }
        if (qualifierExpression != null) {
            return false;
        }
        if (ref instanceof PsiMethodReferenceExpression) {
            return true;
        }
        assert (PsiTreeUtil.isAncestor((PsiElement)targetClass, (PsiElement)ref, (boolean)true));
        PsiModifierListOwner owner = (PsiModifierListOwner)PsiTreeUtil.getParentOfType((PsiElement)ref, PsiModifierListOwner.class);
        if (owner instanceof PsiMethod && ((PsiMethod)owner).isConstructor()) {
            String calleeText;
            PsiReferenceExpression run = ref;
            while (run.getParent() instanceof PsiExpression) {
                run = (PsiExpression)run.getParent();
            }
            if (run.getParent() instanceof PsiExpressionList && run.getParent().getParent() instanceof PsiMethodCallExpression && ((calleeText = ((PsiMethodCallExpression)run.getParent().getParent()).getMethodExpression().getText()).equals("this") || calleeText.equals("super"))) {
                return true;
            }
        }
        while (owner != null && owner != targetClass) {
            if (owner.hasModifierProperty("static")) {
                return true;
            }
            owner = (PsiModifierListOwner)PsiTreeUtil.getParentOfType((PsiElement)owner, PsiModifierListOwner.class);
        }
        return false;
    }

    @Nullable
    private static PsiExpression getQualifier(PsiElement element) {
        if (element instanceof PsiNewExpression) {
            PsiJavaCodeReferenceElement ref = ((PsiNewExpression)element).getClassReference();
            if (ref instanceof PsiReferenceExpression) {
                return ((PsiReferenceExpression)ref).getQualifierExpression();
            }
        } else {
            if (element instanceof PsiReferenceExpression) {
                return ((PsiReferenceExpression)element).getQualifierExpression();
            }
            if (element instanceof PsiMethodCallExpression) {
                return ((PsiMethodCallExpression)element).getMethodExpression().getQualifierExpression();
            }
        }
        return null;
    }

    protected static PsiSubstitutor getTargetSubstitutor(PsiElement element) {
        PsiType type;
        if (element instanceof PsiNewExpression) {
            JavaResolveResult result = ((PsiNewExpression)element).getClassOrAnonymousClassReference().advancedResolve(false);
            PsiSubstitutor substitutor = result.getSubstitutor();
            return substitutor == null ? PsiSubstitutor.EMPTY : substitutor;
        }
        PsiExpression qualifier = CreateFromUsageBaseFix.getQualifier(element);
        if (qualifier != null && (type = qualifier.getType()) instanceof PsiClassType) {
            return ((PsiClassType)type).resolveGenerics().getSubstitutor();
        }
        return PsiSubstitutor.EMPTY;
    }

    protected boolean isAllowOuterTargetClass() {
        return true;
    }

    @NotNull
    protected List<PsiClass> getTargetClasses(PsiElement element) {
        PsiAnnotation annotation;
        PsiClass psiClass = null;
        PsiExpression qualifier = null;
        if (element instanceof PsiNameValuePair && (annotation = (PsiAnnotation)PsiTreeUtil.getParentOfType((PsiElement)element, PsiAnnotation.class)) != null) {
            PsiJavaCodeReferenceElement nameRef = annotation.getNameReferenceElement();
            if (nameRef == null) {
                return Collections.emptyList();
            }
            PsiElement resolve = nameRef.resolve();
            if (resolve instanceof PsiClass) {
                return Collections.singletonList((PsiClass)resolve);
            }
            return Collections.emptyList();
        }
        if (element instanceof PsiNewExpression) {
            PsiNewExpression newExpression = (PsiNewExpression)element;
            PsiJavaCodeReferenceElement ref = newExpression.getClassOrAnonymousClassReference();
            if (ref != null) {
                PsiElement refElement = ref.resolve();
                if (refElement instanceof PsiClass) {
                    psiClass = (PsiClass)refElement;
                } else {
                    PsiElement refQualifier = ref.getQualifier();
                    if (refQualifier instanceof PsiJavaCodeReferenceElement && (refElement = ((PsiJavaCodeReferenceElement)refQualifier).resolve()) instanceof PsiClass) {
                        psiClass = (PsiClass)refElement;
                    }
                }
            }
        } else if (element instanceof PsiReferenceExpression) {
            PsiExpression expression;
            PsiSwitchStatement switchStatement;
            PsiElement parent;
            qualifier = ((PsiReferenceExpression)element).getQualifierExpression();
            if (qualifier == null && element instanceof PsiMethodReferenceExpression) {
                PsiTypeElement qualifierTypeElement = ((PsiMethodReferenceExpression)element).getQualifierType();
                if (qualifierTypeElement != null) {
                    psiClass = PsiUtil.resolveClassInType((PsiType)qualifierTypeElement.getType());
                }
            } else if (qualifier == null && (parent = element.getParent()) instanceof PsiSwitchLabelStatement && (switchStatement = (PsiSwitchStatement)PsiTreeUtil.getParentOfType((PsiElement)parent, PsiSwitchStatement.class)) != null && (expression = switchStatement.getExpression()) != null) {
                psiClass = PsiUtil.resolveClassInClassTypeOnly((PsiType)expression.getType());
            }
        } else if (element instanceof PsiMethodCallExpression) {
            PsiReferenceExpression methodExpression = ((PsiMethodCallExpression)element).getMethodExpression();
            qualifier = methodExpression.getQualifierExpression();
            String referenceName = methodExpression.getReferenceName();
            if (referenceName == null) {
                return Collections.emptyList();
            }
        }
        boolean allowOuterClasses = false;
        if (qualifier != null) {
            PsiElement resolved;
            PsiType type = qualifier.getType();
            if (type instanceof PsiClassType) {
                psiClass = ((PsiClassType)type).resolve();
            }
            if (qualifier instanceof PsiJavaCodeReferenceElement && (resolved = ((PsiJavaCodeReferenceElement)qualifier).resolve()) instanceof PsiClass && psiClass == null) {
                psiClass = (PsiClass)resolved;
            }
        } else if (psiClass == null) {
            psiClass = (PsiClass)PsiTreeUtil.getParentOfType((PsiElement)element, PsiClass.class);
            allowOuterClasses = true;
        }
        if (psiClass instanceof PsiTypeParameter) {
            PsiClass[] supers = psiClass.getSupers();
            ArrayList<PsiClass> filtered = new ArrayList<PsiClass>();
            for (PsiClass aSuper : supers) {
                if (!aSuper.getManager().isInProject((PsiElement)aSuper) || aSuper instanceof PsiTypeParameter) continue;
                filtered.add(aSuper);
            }
            return filtered;
        }
        if (psiClass == null || !psiClass.getManager().isInProject((PsiElement)psiClass)) {
            return Collections.emptyList();
        }
        if (!allowOuterClasses || !this.isAllowOuterTargetClass()) {
            ArrayList<PsiClass> classes = new ArrayList<PsiClass>();
            this.collectSupers(psiClass, classes);
            return classes;
        }
        ArrayList<PsiClass> result = new ArrayList<PsiClass>();
        while (psiClass != null) {
            result.add(psiClass);
            if (psiClass.hasModifierProperty("static")) break;
            psiClass = (PsiClass)PsiTreeUtil.getParentOfType((PsiElement)psiClass, PsiClass.class);
        }
        return result;
    }

    private void collectSupers(PsiClass psiClass, ArrayList<PsiClass> classes) {
        PsiClass[] supers;
        classes.add(psiClass);
        for (PsiClass aSuper : supers = psiClass.getSupers()) {
            if (classes.contains(aSuper) || !this.canBeTargetClass(aSuper)) continue;
            this.collectSupers(aSuper, classes);
        }
    }

    protected boolean canBeTargetClass(PsiClass psiClass) {
        return psiClass.getManager().isInProject((PsiElement)psiClass);
    }

    protected static void startTemplate(@NotNull Editor editor, Template template, @NotNull Project project2) {
        CreateFromUsageBaseFix.startTemplate(editor, template, project2, null);
    }

    protected static void startTemplate(@NotNull Editor editor, Template template, @NotNull Project project2, TemplateEditingListener listener2) {
        CreateFromUsageBaseFix.startTemplate(editor, template, project2, listener2, null);
    }

    public static void startTemplate(final @NotNull Editor editor, final Template template, final @NotNull Project project2, final TemplateEditingListener listener2, final String commandName) {
        Runnable runnable2 = new Runnable(){

            @Override
            public void run() {
                if (project2.isDisposed() || editor.isDisposed()) {
                    return;
                }
                CommandProcessor.getInstance().executeCommand(project2, new Runnable(){

                    @Override
                    public void run() {
                        TemplateManager.getInstance(project2).startTemplate(editor, template, listener2);
                    }
                }, commandName, (Object)commandName);
            }
        };
        if (ApplicationManager.getApplication().isUnitTestMode()) {
            runnable2.run();
        } else {
            ApplicationManager.getApplication().invokeLater(runnable2);
        }
    }

    public boolean startInWriteAction() {
        return false;
    }

    public static void setupGenericParameters(PsiClass targetClass, PsiJavaCodeReferenceElement ref) {
        int numParams = ref.getTypeParameters().length;
        if (numParams == 0) {
            return;
        }
        PsiElementFactory factory = JavaPsiFacade.getInstance((Project)ref.getProject()).getElementFactory();
        HashSet<String> typeParamNames = new HashSet<String>();
        for (PsiType type : ref.getTypeParameters()) {
            PsiClass psiClass = PsiUtil.resolveClassInType((PsiType)type);
            if (!(psiClass instanceof PsiTypeParameter)) continue;
            typeParamNames.add(psiClass.getName());
        }
        int idx = 0;
        block1: for (PsiType type : ref.getTypeParameters()) {
            PsiClass psiClass = PsiUtil.resolveClassInType((PsiType)type);
            if (psiClass instanceof PsiTypeParameter) {
                targetClass.getTypeParameterList().add((PsiElement)factory.createTypeParameterFromText(psiClass.getName(), null));
                continue;
            }
            while (true) {
                String paramName;
                String string = paramName = idx > 0 ? "T" + idx : "T";
                if (typeParamNames.add(paramName)) {
                    targetClass.getTypeParameterList().add((PsiElement)factory.createTypeParameterFromText(paramName, null));
                    continue block1;
                }
                ++idx;
            }
        }
    }
}

