/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.daemon.impl.quickfix;

import com.intellij.codeInsight.daemon.QuickFixBundle;
import com.intellij.codeInsight.daemon.impl.quickfix.CreateConstructorFromThisOrSuperFix;
import com.intellij.psi.PsiAnonymousClass;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiTypeParameter;
import com.intellij.psi.util.PsiTreeUtil;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class CreateConstructorFromSuperFix
extends CreateConstructorFromThisOrSuperFix {
    public CreateConstructorFromSuperFix(@NotNull PsiMethodCallExpression methodCall) {
        super(methodCall);
    }

    @Override
    protected String getSyntheticMethodName() {
        return "super";
    }

    @Override
    @NotNull
    protected List<PsiClass> getTargetClasses(PsiElement element) {
        while ((element = PsiTreeUtil.getParentOfType((PsiElement)element, PsiClass.class)) instanceof PsiTypeParameter) {
        }
        PsiClass curClass = (PsiClass)element;
        if (curClass == null || curClass instanceof PsiAnonymousClass) {
            return Collections.emptyList();
        }
        PsiClassType[] extendsTypes = curClass.getExtendsListTypes();
        if (extendsTypes.length == 0) {
            return Collections.emptyList();
        }
        PsiClass aClass = extendsTypes[0].resolve();
        if (aClass instanceof PsiTypeParameter) {
            return Collections.emptyList();
        }
        if (aClass != null && aClass.isValid() && aClass.getManager().isInProject((PsiElement)aClass)) {
            return Collections.singletonList(aClass);
        }
        return Collections.emptyList();
    }

    @NotNull
    public String getFamilyName() {
        return QuickFixBundle.message("create.constructor.from.super.call.family", new Object[0]);
    }
}

