/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.daemon.impl.quickfix;

import com.intellij.codeInsight.daemon.impl.quickfix.RemoveUnusedVariableUtil;
import com.intellij.codeInsight.daemon.impl.quickfix.SwitchStatementBranch;
import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiBlockStatement;
import com.intellij.psi.PsiBreakStatement;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiDeclarationStatement;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiEnumConstant;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiIdentifier;
import com.intellij.psi.PsiLocalVariable;
import com.intellij.psi.PsiParenthesizedExpression;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiStatement;
import com.intellij.psi.PsiSwitchLabelStatement;
import com.intellij.psi.PsiSwitchStatement;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.codeStyle.JavaCodeStyleManager;
import com.intellij.psi.controlFlow.AnalysisCanceledException;
import com.intellij.psi.controlFlow.ControlFlow;
import com.intellij.psi.controlFlow.ControlFlowFactory;
import com.intellij.psi.controlFlow.ControlFlowUtil;
import com.intellij.psi.controlFlow.LocalsOrMyInstanceFieldsControlFlowPolicy;
import com.intellij.psi.search.LocalSearchScope;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.search.searches.ReferencesSearch;
import com.intellij.psi.util.PsiUtil;
import com.intellij.refactoring.util.RefactoringUtil;
import com.intellij.util.IncorrectOperationException;
import com.siyeh.ig.psiutils.ParenthesesUtils;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public class ConvertSwitchToIfIntention
implements IntentionAction {
    private final PsiSwitchStatement mySwitchExpression;

    public ConvertSwitchToIfIntention(@NotNull PsiSwitchStatement switchStatement) {
        this.mySwitchExpression = switchStatement;
    }

    @NotNull
    public String getText() {
        return "Replace 'switch' with 'if'";
    }

    @NotNull
    public String getFamilyName() {
        return this.getText();
    }

    public boolean isAvailable(@NotNull Project project2, Editor editor, PsiFile file2) {
        PsiCodeBlock body = this.mySwitchExpression.getBody();
        return body != null && body.getStatements().length > 0;
    }

    public void invoke(@NotNull Project project2, Editor editor, PsiFile file2) throws IncorrectOperationException {
        ConvertSwitchToIfIntention.doProcessIntention(this.mySwitchExpression);
    }

    public boolean startInWriteAction() {
        return true;
    }

    public static void doProcessIntention(@NotNull PsiSwitchStatement switchStatement) {
        String declarationString;
        String expressionText;
        boolean hadSideEffects;
        PsiExpression switchExpression = switchStatement.getExpression();
        if (switchExpression == null) {
            return;
        }
        PsiType switchExpressionType = RefactoringUtil.getTypeByExpressionWithExpectedType(switchExpression);
        if (switchExpressionType == null) {
            return;
        }
        boolean isSwitchOnString = switchExpressionType.equalsToText("java.lang.String");
        boolean useEquals = isSwitchOnString;
        if (!useEquals) {
            PsiClass aClass = PsiUtil.resolveClassInType((PsiType)switchExpressionType);
            useEquals = aClass != null && !aClass.isEnum();
        }
        Project project2 = switchStatement.getProject();
        if (RemoveUnusedVariableUtil.checkSideEffects(switchExpression, null, new ArrayList<PsiElement>())) {
            hadSideEffects = true;
            JavaCodeStyleManager javaCodeStyleManager = JavaCodeStyleManager.getInstance((Project)project2);
            String variableName = isSwitchOnString ? javaCodeStyleManager.suggestUniqueVariableName("s", (PsiElement)switchExpression, true) : javaCodeStyleManager.suggestUniqueVariableName("i", (PsiElement)switchExpression, true);
            expressionText = variableName;
            declarationString = switchExpressionType.getCanonicalText() + ' ' + variableName + " = " + switchExpression.getText() + ';';
        } else {
            hadSideEffects = false;
            declarationString = null;
            expressionText = ParenthesesUtils.getPrecedence(switchExpression) > 9 ? '(' + switchExpression.getText() + ')' : switchExpression.getText();
        }
        PsiCodeBlock body = switchStatement.getBody();
        if (body == null) {
            return;
        }
        ArrayList<SwitchStatementBranch> openBranches = new ArrayList<SwitchStatementBranch>();
        HashSet<PsiLocalVariable> declaredVariables = new HashSet<PsiLocalVariable>();
        ArrayList<SwitchStatementBranch> allBranches = new ArrayList<SwitchStatementBranch>();
        SwitchStatementBranch currentBranch = null;
        PsiElement[] children2 = body.getChildren();
        for (int i = 1; i < children2.length - 1; ++i) {
            PsiElement statement2 = children2[i];
            if (statement2 instanceof PsiSwitchLabelStatement) {
                PsiSwitchLabelStatement label = (PsiSwitchLabelStatement)statement2;
                if (currentBranch == null) {
                    openBranches.clear();
                    currentBranch = new SwitchStatementBranch();
                    currentBranch.addPendingVariableDeclarations(declaredVariables);
                    allBranches.add(currentBranch);
                    openBranches.add(currentBranch);
                } else if (currentBranch.hasStatements()) {
                    currentBranch = new SwitchStatementBranch();
                    allBranches.add(currentBranch);
                    openBranches.add(currentBranch);
                }
                if (label.isDefaultCase()) {
                    currentBranch.setDefault();
                    continue;
                }
                PsiExpression psiExpression = label.getCaseValue();
                String string = ConvertSwitchToIfIntention.getCaseValueText(psiExpression);
                currentBranch.addCaseValue(string);
                continue;
            }
            if (statement2 instanceof PsiStatement) {
                if (statement2 instanceof PsiDeclarationStatement) {
                    PsiElement[] psiElementArray;
                    PsiDeclarationStatement declarationStatement = (PsiDeclarationStatement)statement2;
                    for (PsiElement varElement : psiElementArray = declarationStatement.getDeclaredElements()) {
                        PsiLocalVariable variable = (PsiLocalVariable)varElement;
                        declaredVariables.add(variable);
                    }
                }
                for (SwitchStatementBranch switchStatementBranch : openBranches) {
                    switchStatementBranch.addStatement(statement2);
                }
                try {
                    ControlFlow controlFlow = ControlFlowFactory.getInstance(project2).getControlFlow(statement2, LocalsOrMyInstanceFieldsControlFlowPolicy.getInstance());
                    int n = controlFlow.getStartOffset(statement2);
                    int n2 = controlFlow.getEndOffset(statement2);
                    if (n == -1 || n2 == -1 || ControlFlowUtil.canCompleteNormally(controlFlow, n, n2)) continue;
                    currentBranch = null;
                }
                catch (AnalysisCanceledException e) {
                    currentBranch = null;
                }
                continue;
            }
            for (SwitchStatementBranch switchStatementBranch : openBranches) {
                if (statement2 instanceof PsiWhiteSpace) {
                    switchStatementBranch.addWhiteSpace(statement2);
                    continue;
                }
                switchStatementBranch.addComment(statement2);
            }
        }
        StringBuilder ifStatementText = new StringBuilder();
        boolean firstBranch = true;
        SwitchStatementBranch defaultBranch = null;
        for (SwitchStatementBranch switchStatementBranch : allBranches) {
            if (switchStatementBranch.isDefault()) {
                defaultBranch = switchStatementBranch;
                continue;
            }
            List<String> caseValues = switchStatementBranch.getCaseValues();
            List<PsiElement> bodyElements = switchStatementBranch.getBodyElements();
            Set<PsiLocalVariable> pendingVariableDeclarations = switchStatementBranch.getPendingVariableDeclarations();
            ConvertSwitchToIfIntention.dumpBranch(expressionText, caseValues, bodyElements, pendingVariableDeclarations, firstBranch, useEquals, ifStatementText);
            firstBranch = false;
        }
        if (defaultBranch != null) {
            List<PsiElement> list = defaultBranch.getBodyElements();
            Set<PsiLocalVariable> set = defaultBranch.getPendingVariableDeclarations();
            ConvertSwitchToIfIntention.dumpDefaultBranch(list, set, firstBranch, ifStatementText);
        }
        if (ifStatementText.length() == 0) {
            return;
        }
        JavaPsiFacade javaPsiFacade = JavaPsiFacade.getInstance((Project)project2);
        PsiElementFactory psiElementFactory = javaPsiFacade.getElementFactory();
        if (hadSideEffects) {
            PsiStatement declarationStatement = psiElementFactory.createStatementFromText(declarationString, (PsiElement)switchStatement);
            PsiStatement ifStatement = psiElementFactory.createStatementFromText(ifStatementText.toString(), (PsiElement)switchStatement);
            PsiElement parent = switchStatement.getParent();
            parent.addBefore((PsiElement)declarationStatement, (PsiElement)switchStatement);
            switchStatement.replace((PsiElement)ifStatement);
        } else {
            PsiStatement newStatement = psiElementFactory.createStatementFromText(ifStatementText.toString(), (PsiElement)switchStatement);
            switchStatement.replace((PsiElement)newStatement);
        }
    }

    private static String getCaseValueText(PsiExpression value) {
        if (value == null) {
            return "";
        }
        if (value instanceof PsiParenthesizedExpression) {
            PsiParenthesizedExpression parenthesizedExpression = (PsiParenthesizedExpression)value;
            PsiExpression expression = parenthesizedExpression.getExpression();
            return ConvertSwitchToIfIntention.getCaseValueText(expression);
        }
        if (!(value instanceof PsiReferenceExpression)) {
            return value.getText();
        }
        PsiReferenceExpression referenceExpression = (PsiReferenceExpression)value;
        PsiElement target = referenceExpression.resolve();
        String text = referenceExpression.getText();
        if (!(target instanceof PsiEnumConstant)) {
            return value.getText();
        }
        PsiEnumConstant enumConstant = (PsiEnumConstant)target;
        PsiClass aClass = enumConstant.getContainingClass();
        if (aClass == null) {
            return value.getText();
        }
        String name = aClass.getQualifiedName();
        return name + '.' + text;
    }

    private static void dumpBranch(String expressionText, List<String> caseValues, List<PsiElement> bodyStatements, Set<PsiLocalVariable> variables, boolean firstBranch, boolean useEquals, @NonNls StringBuilder ifStatementString) {
        if (!firstBranch) {
            ifStatementString.append("else ");
        }
        ConvertSwitchToIfIntention.dumpCaseValues(expressionText, caseValues, useEquals, ifStatementString);
        ConvertSwitchToIfIntention.dumpBody(bodyStatements, variables, ifStatementString);
    }

    private static void dumpDefaultBranch(List<PsiElement> bodyStatements, Set<PsiLocalVariable> variables, boolean firstBranch, @NonNls StringBuilder ifStatementString) {
        if (!firstBranch) {
            ifStatementString.append("else ");
        }
        ConvertSwitchToIfIntention.dumpBody(bodyStatements, variables, ifStatementString);
    }

    private static void dumpCaseValues(String expressionText, List<String> caseValues, boolean useEquals, @NonNls StringBuilder ifStatementString) {
        ifStatementString.append("if(");
        boolean firstCaseValue = true;
        for (String caseValue : caseValues) {
            if (!firstCaseValue) {
                ifStatementString.append("||");
            }
            firstCaseValue = false;
            ifStatementString.append(expressionText);
            if (useEquals) {
                ifStatementString.append(".equals(");
                ifStatementString.append(caseValue);
                ifStatementString.append(')');
                continue;
            }
            ifStatementString.append("==");
            ifStatementString.append(caseValue);
        }
        ifStatementString.append(')');
    }

    private static void dumpBody(List<PsiElement> bodyStatements, Set<PsiLocalVariable> variables, @NonNls StringBuilder ifStatementString) {
        ifStatementString.append('{');
        for (PsiLocalVariable variable : variables) {
            if (ReferencesSearch.search((PsiElement)variable, (SearchScope)new LocalSearchScope(bodyStatements.toArray(new PsiElement[bodyStatements.size()]))).findFirst() == null) continue;
            PsiType varType = variable.getType();
            ifStatementString.append(varType.getCanonicalText());
            ifStatementString.append(' ');
            ifStatementString.append(variable.getName());
            ifStatementString.append(';');
        }
        for (PsiElement bodyStatement : bodyStatements) {
            if (bodyStatement instanceof PsiBlockStatement) {
                PsiStatement[] statements;
                PsiBlockStatement blockStatement = (PsiBlockStatement)bodyStatement;
                PsiCodeBlock codeBlock = blockStatement.getCodeBlock();
                for (PsiStatement statement2 : statements = codeBlock.getStatements()) {
                    ConvertSwitchToIfIntention.appendElement((PsiElement)statement2, ifStatementString);
                }
                continue;
            }
            ConvertSwitchToIfIntention.appendElement(bodyStatement, ifStatementString);
        }
        ifStatementString.append("\n}");
    }

    private static void appendElement(PsiElement element, @NonNls StringBuilder ifStatementString) {
        PsiBreakStatement breakStatement;
        PsiIdentifier identifier;
        if (element instanceof PsiBreakStatement && (identifier = (breakStatement = (PsiBreakStatement)element).getLabelIdentifier()) == null) {
            return;
        }
        String text = element.getText();
        ifStatementString.append(text);
    }
}

