/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.daemon.impl.quickfix;

import com.intellij.codeInsight.FileModificationService;
import com.intellij.codeInsight.daemon.QuickFixBundle;
import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.codeInspection.util.ChangeToAppendUtil;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaTokenType;
import com.intellij.psi.PsiAssignmentExpression;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiType;
import com.intellij.psi.tree.IElementType;
import com.intellij.util.IncorrectOperationException;
import org.jetbrains.annotations.NotNull;

public class ChangeToAppendFix
implements IntentionAction {
    private final IElementType myTokenType;
    private final PsiType myLhsType;
    private final PsiAssignmentExpression myAssignmentExpression;

    public ChangeToAppendFix(@NotNull IElementType eqOpSign, @NotNull PsiType lType, @NotNull PsiAssignmentExpression assignmentExpression) {
        this.myTokenType = eqOpSign;
        this.myLhsType = lType;
        this.myAssignmentExpression = assignmentExpression;
    }

    @NotNull
    public String getText() {
        return QuickFixBundle.message("change.to.append.text", ChangeToAppendUtil.buildAppendExpression(this.myAssignmentExpression.getRExpression(), this.myLhsType.equalsToText("java.lang.Appendable"), new StringBuilder(this.myAssignmentExpression.getLExpression().getText())));
    }

    @NotNull
    public String getFamilyName() {
        return QuickFixBundle.message("change.to.append.family", new Object[0]);
    }

    public boolean isAvailable(@NotNull Project project2, Editor editor, PsiFile file2) {
        return JavaTokenType.PLUSEQ == this.myTokenType && this.myAssignmentExpression.isValid() && PsiManager.getInstance((Project)project2).isInProject((PsiElement)this.myAssignmentExpression) && (this.myLhsType.equalsToText("java.lang.StringBuilder") || this.myLhsType.equalsToText("java.lang.StringBuffer") || this.myLhsType.equalsToText("java.lang.Appendable"));
    }

    public boolean startInWriteAction() {
        return true;
    }

    public void invoke(@NotNull Project project2, Editor editor, PsiFile file2) throws IncorrectOperationException {
        if (!FileModificationService.getInstance().prepareFileForWrite(file2)) {
            return;
        }
        PsiExpression appendExpression = ChangeToAppendUtil.buildAppendExpression(this.myAssignmentExpression.getLExpression(), this.myAssignmentExpression.getRExpression());
        if (appendExpression == null) {
            return;
        }
        this.myAssignmentExpression.replace((PsiElement)appendExpression);
    }
}

