/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.daemon.impl.quickfix;

import com.intellij.codeInsight.FileModificationService;
import com.intellij.codeInsight.daemon.QuickFixBundle;
import com.intellij.codeInsight.daemon.impl.HighlightInfo;
import com.intellij.codeInsight.daemon.impl.quickfix.QuickFixAction;
import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiCall;
import com.intellij.psi.PsiConstructorCall;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiLiteralExpression;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiParameterList;
import com.intellij.psi.PsiType;
import com.intellij.psi.infos.CandidateInfo;
import com.intellij.psi.infos.MethodCandidateInfo;
import com.intellij.util.IncorrectOperationException;
import java.util.HashSet;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ChangeStringLiteralToCharInMethodCallFix
implements IntentionAction {
    private final PsiLiteralExpression myLiteral;
    private final PsiCall myCall;

    public ChangeStringLiteralToCharInMethodCallFix(PsiLiteralExpression literal, PsiCall methodCall) {
        this.myLiteral = literal;
        this.myCall = methodCall;
    }

    @NotNull
    public String getText() {
        String convertedValue = this.convertedValue();
        boolean isString = ChangeStringLiteralToCharInMethodCallFix.isString(this.myLiteral.getType());
        return QuickFixBundle.message("fix.single.character.string.to.char.literal.text", this.myLiteral.getText(), ChangeStringLiteralToCharInMethodCallFix.quote(convertedValue, !isString), isString ? PsiType.CHAR.getCanonicalText() : "String");
    }

    @NotNull
    public String getFamilyName() {
        return QuickFixBundle.message("fix.single.character.string.to.char.literal.family", new Object[0]);
    }

    public boolean isAvailable(@NotNull Project project2, Editor editor, PsiFile file2) {
        return this.myCall.isValid() && this.myLiteral.isValid() && this.myCall.getManager().isInProject((PsiElement)this.myCall);
    }

    public void invoke(@NotNull Project project2, Editor editor, PsiFile file2) throws IncorrectOperationException {
        if (!FileModificationService.getInstance().prepareFileForWrite(file2)) {
            return;
        }
        Object value = this.myLiteral.getValue();
        if (value != null && value.toString().length() == 1) {
            PsiElementFactory factory = JavaPsiFacade.getInstance((Project)project2).getElementFactory();
            PsiExpression newExpression = factory.createExpressionFromText(ChangeStringLiteralToCharInMethodCallFix.quote(this.convertedValue(), !ChangeStringLiteralToCharInMethodCallFix.isString(this.myLiteral.getType())), this.myLiteral.getParent());
            this.myLiteral.replace((PsiElement)newExpression);
        }
    }

    public boolean startInWriteAction() {
        return true;
    }

    private static String quote(String value, boolean doubleQuotes) {
        char quote = doubleQuotes ? (char)'\"' : '\'';
        return quote + value + quote;
    }

    private String convertedValue() {
        String value = String.valueOf(this.myLiteral.getValue());
        StringBuilder builder = new StringBuilder();
        StringUtil.escapeStringCharacters((int)value.length(), (String)value, (String)"\"'", (StringBuilder)builder);
        return builder.toString();
    }

    public static void registerFixes(@NotNull PsiMethod[] candidates, @NotNull PsiConstructorCall call, @NotNull HighlightInfo out) {
        HashSet<PsiLiteralExpression> literals = new HashSet<PsiLiteralExpression>();
        if (call.getArgumentList() == null) {
            return;
        }
        boolean exactMatch = false;
        for (PsiMethod method : candidates) {
            exactMatch |= ChangeStringLiteralToCharInMethodCallFix.findMatchingExpressions(call.getArgumentList().getExpressions(), method, literals);
        }
        if (!exactMatch) {
            ChangeStringLiteralToCharInMethodCallFix.processLiterals(literals, (PsiCall)call, out);
        }
    }

    public static void registerFixes(@NotNull CandidateInfo[] candidates, @NotNull PsiMethodCallExpression methodCall, @Nullable HighlightInfo info) {
        if (info == null) {
            return;
        }
        HashSet<PsiLiteralExpression> literals = new HashSet<PsiLiteralExpression>();
        boolean exactMatch = false;
        for (CandidateInfo candidate : candidates) {
            if (!(candidate instanceof MethodCandidateInfo)) continue;
            PsiMethod method = ((MethodCandidateInfo)candidate).getElement();
            exactMatch |= ChangeStringLiteralToCharInMethodCallFix.findMatchingExpressions(methodCall.getArgumentList().getExpressions(), method, literals);
        }
        if (!exactMatch) {
            ChangeStringLiteralToCharInMethodCallFix.processLiterals(literals, (PsiCall)methodCall, info);
        }
    }

    private static void processLiterals(@NotNull Set<PsiLiteralExpression> literals, @NotNull PsiCall call, @NotNull HighlightInfo info) {
        for (PsiLiteralExpression literal : literals) {
            ChangeStringLiteralToCharInMethodCallFix fix = new ChangeStringLiteralToCharInMethodCallFix(literal, call);
            QuickFixAction.registerQuickFixAction(info, fix);
        }
    }

    private static boolean findMatchingExpressions(PsiExpression[] arguments, PsiMethod existingMethod, Set<PsiLiteralExpression> result) {
        PsiParameterList parameterList = existingMethod.getParameterList();
        PsiParameter[] parameters = parameterList.getParameters();
        if (arguments.length != parameters.length) {
            return false;
        }
        boolean typeMatch = true;
        for (int i = 0; i < parameters.length && i < arguments.length; ++i) {
            String value;
            PsiParameter parameter = parameters[i];
            PsiType parameterType = parameter.getType();
            PsiType argumentType = arguments[i].getType();
            typeMatch &= Comparing.equal((Object)parameterType, (Object)argumentType);
            if (!(arguments[i] instanceof PsiLiteralExpression) || result.contains(arguments[i]) || !ChangeStringLiteralToCharInMethodCallFix.charToString(parameterType, argumentType) && !ChangeStringLiteralToCharInMethodCallFix.charToString(argumentType, parameterType) || (value = String.valueOf(((PsiLiteralExpression)arguments[i]).getValue())) == null || value.length() != 1) continue;
            result.add((PsiLiteralExpression)arguments[i]);
        }
        return typeMatch;
    }

    private static boolean charToString(PsiType firstType, PsiType secondType) {
        return Comparing.equal((Object)PsiType.CHAR, (Object)firstType) && ChangeStringLiteralToCharInMethodCallFix.isString(secondType);
    }

    private static boolean isString(PsiType type) {
        return type != null && type.equalsToText("java.lang.String");
    }
}

