/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.daemon.impl.quickfix;

import com.intellij.codeInsight.FileModificationService;
import com.intellij.codeInsight.daemon.QuickFixBundle;
import com.intellij.codeInsight.daemon.impl.HighlightInfo;
import com.intellij.codeInsight.daemon.impl.quickfix.QuickFixAction;
import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.ScrollType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.UnfairTextRange;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiAnonymousClass;
import com.intellij.psi.PsiArrayType;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionList;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiNewExpression;
import com.intellij.psi.PsiResolveHelper;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeParameter;
import com.intellij.psi.PsiTypeParameterListOwner;
import com.intellij.psi.PsiWildcardType;
import com.intellij.psi.impl.PsiDiamondTypeUtil;
import com.intellij.psi.util.PsiExpressionTrimRenderer;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.psi.util.TypeConversionUtil;
import com.intellij.util.IncorrectOperationException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ChangeNewOperatorTypeFix
implements IntentionAction {
    private final PsiType myType;
    private final PsiNewExpression myExpression;

    private ChangeNewOperatorTypeFix(PsiType type, PsiNewExpression expression) {
        this.myType = type;
        this.myExpression = expression;
    }

    @NotNull
    public String getText() {
        return QuickFixBundle.message("change.new.operator.type.text", new PsiExpressionTrimRenderer.RenderFunction().fun((PsiExpression)this.myExpression), this.myType.getPresentableText(), this.myType instanceof PsiArrayType ? "" : "()");
    }

    @NotNull
    public String getFamilyName() {
        return QuickFixBundle.message("change.new.operator.type.family", new Object[0]);
    }

    public boolean isAvailable(@NotNull Project project2, Editor editor, PsiFile file2) {
        return this.myType.isValid() && this.myExpression.isValid() && this.myExpression.getManager().isInProject((PsiElement)this.myExpression) && !TypeConversionUtil.isPrimitiveAndNotNull((PsiType)this.myType) && (this.myType instanceof PsiArrayType || this.myExpression.getArgumentList() != null);
    }

    public void invoke(@NotNull Project project2, Editor editor, PsiFile file2) throws IncorrectOperationException {
        if (!FileModificationService.getInstance().prepareFileForWrite(file2)) {
            return;
        }
        ChangeNewOperatorTypeFix.changeNewOperatorType(this.myExpression, this.myType, editor);
    }

    private static void changeNewOperatorType(PsiNewExpression originalExpression, PsiType toType, Editor editor) throws IncorrectOperationException {
        UnfairTextRange selection;
        PsiNewExpression newExpression;
        int caretOffset;
        PsiElementFactory factory = JavaPsiFacade.getInstance((Project)originalExpression.getProject()).getElementFactory();
        if (toType instanceof PsiArrayType) {
            PsiExpression[] originalExpressionArrayDimensions = originalExpression.getArrayDimensions();
            caretOffset = 0;
            String text = "new " + toType.getDeepComponentType().getCanonicalText() + "[";
            if (originalExpressionArrayDimensions.length > 0) {
                text = text + originalExpressionArrayDimensions[0].getText();
            } else {
                text = text + "0";
                caretOffset = -2;
            }
            text = text + "]";
            for (int i = 1; i < toType.getArrayDimensions(); ++i) {
                text = text + "[";
                String arrayDimension = "";
                if (originalExpressionArrayDimensions.length > i) {
                    arrayDimension = originalExpressionArrayDimensions[i].getText();
                    text = text + arrayDimension;
                }
                text = text + "]";
                if (caretOffset >= 0) continue;
                caretOffset -= arrayDimension.length() + 2;
            }
            newExpression = (PsiNewExpression)factory.createExpressionFromText(text, (PsiElement)originalExpression);
            selection = caretOffset < 0 ? new UnfairTextRange(caretOffset, caretOffset + 1) : null;
        } else {
            PsiAnonymousClass anonymousClass = originalExpression.getAnonymousClass();
            newExpression = (PsiNewExpression)factory.createExpressionFromText("new " + toType.getCanonicalText() + "()" + (anonymousClass != null ? "{}" : ""), (PsiElement)originalExpression);
            PsiExpressionList argumentList = originalExpression.getArgumentList();
            if (argumentList == null) {
                return;
            }
            newExpression.getArgumentList().replace((PsiElement)argumentList);
            if (anonymousClass == null && PsiDiamondTypeUtil.canCollapseToDiamond(newExpression, originalExpression, toType)) {
                PsiElement paramList = PsiDiamondTypeUtil.replaceExplicitWithDiamond((PsiElement)newExpression.getClassOrAnonymousClassReference().getParameterList());
                newExpression = (PsiNewExpression)PsiTreeUtil.getParentOfType((PsiElement)paramList, PsiNewExpression.class);
            }
            if (anonymousClass != null) {
                PsiAnonymousClass newAnonymousClass = newExpression.getAnonymousClass();
                PsiElement childInside = anonymousClass.getLBrace().getNextSibling();
                if (childInside != null) {
                    newAnonymousClass.addRange(childInside, anonymousClass.getRBrace().getPrevSibling());
                }
            }
            selection = null;
            caretOffset = -1;
        }
        PsiElement element = originalExpression.replace((PsiElement)newExpression);
        editor.getCaretModel().moveToOffset(element.getTextRange().getEndOffset() + caretOffset);
        editor.getScrollingModel().scrollToCaret(ScrollType.RELATIVE);
        if (selection != null) {
            selection = selection.shiftRight(element.getTextRange().getEndOffset());
            editor.getSelectionModel().setSelection(selection.getStartOffset(), selection.getEndOffset());
        }
    }

    public boolean startInWriteAction() {
        return true;
    }

    public static void register(HighlightInfo highlightInfo, PsiExpression expression, PsiType lType) {
        if (!((expression = PsiUtil.deparenthesizeExpression((PsiExpression)expression)) instanceof PsiNewExpression)) {
            return;
        }
        PsiType rType = expression.getType();
        PsiType newType = lType;
        if (rType instanceof PsiClassType && newType instanceof PsiClassType) {
            PsiSubstitutor substitutor;
            PsiClassType.ClassResolveResult lResolveResult;
            PsiClass lClass;
            PsiClassType.ClassResolveResult rResolveResult = ((PsiClassType)rType).resolveGenerics();
            PsiClass rClass = rResolveResult.getElement();
            if (rClass instanceof PsiAnonymousClass) {
                rClass = ((PsiAnonymousClass)rClass).getBaseClassType().resolve();
            }
            if (rClass != null && (lClass = (lResolveResult = ((PsiClassType)newType).resolveGenerics()).getElement()) != null && (substitutor = ChangeNewOperatorTypeFix.getInheritorSubstitutorForNewExpression(lClass, rClass, lResolveResult.getSubstitutor(), (PsiElement)expression)) != null) {
                newType = JavaPsiFacade.getInstance((Project)lClass.getProject()).getElementFactory().createType(rClass, substitutor);
            }
        }
        PsiNewExpression newExpression = (PsiNewExpression)expression;
        QuickFixAction.registerQuickFixAction(highlightInfo, new ChangeNewOperatorTypeFix(newType, newExpression));
    }

    @Nullable
    private static PsiSubstitutor getInheritorSubstitutorForNewExpression(PsiClass baseClass, PsiClass inheritor, PsiSubstitutor baseSubstitutor, PsiElement context) {
        Project project2 = baseClass.getProject();
        JavaPsiFacade facade = JavaPsiFacade.getInstance((Project)project2);
        PsiResolveHelper resolveHelper = facade.getResolveHelper();
        PsiSubstitutor superSubstitutor = TypeConversionUtil.getClassSubstitutor((PsiClass)baseClass, (PsiClass)inheritor, (PsiSubstitutor)PsiSubstitutor.EMPTY);
        if (superSubstitutor == null) {
            return null;
        }
        PsiSubstitutor inheritorSubstitutor = PsiSubstitutor.EMPTY;
        block0: for (PsiTypeParameter inheritorParameter : PsiUtil.typeParametersIterable((PsiTypeParameterListOwner)inheritor)) {
            for (PsiTypeParameter baseParameter : PsiUtil.typeParametersIterable((PsiTypeParameterListOwner)baseClass)) {
                PsiType substitution;
                PsiType substituted = superSubstitutor.substitute(baseParameter);
                PsiType arg = baseSubstitutor.substitute(baseParameter);
                if (arg instanceof PsiWildcardType) {
                    arg = ((PsiWildcardType)arg).getBound();
                }
                if (PsiType.NULL.equals((Object)(substitution = resolveHelper.getSubstitutionForTypeParameter(inheritorParameter, substituted, arg, true, PsiUtil.getLanguageLevel((PsiElement)context))))) continue;
                if (substitution == null) {
                    return facade.getElementFactory().createRawSubstitutor((PsiTypeParameterListOwner)inheritor);
                }
                inheritorSubstitutor = inheritorSubstitutor.put(inheritorParameter, substitution);
                continue block0;
            }
        }
        return inheritorSubstitutor;
    }
}

