/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.daemon.impl.quickfix;

import com.intellij.codeInsight.daemon.impl.quickfix.ChangeMethodSignatureFromUsageFix;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.PsiType;
import com.intellij.psi.codeStyle.JavaCodeStyleManager;
import com.intellij.psi.util.TypeConversionUtil;
import com.intellij.refactoring.changeSignature.ParameterInfoImpl;
import com.intellij.refactoring.util.RefactoringUtil;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class ChangeMethodSignatureFromUsageReverseOrderFix
extends ChangeMethodSignatureFromUsageFix {
    public ChangeMethodSignatureFromUsageReverseOrderFix(@NotNull PsiMethod targetMethod, @NotNull PsiExpression[] expressions, @NotNull PsiSubstitutor substitutor, @NotNull PsiElement context, boolean changeAllUsages, int minUsagesNumberToShowDialog) {
        super(targetMethod, expressions, substitutor, context, changeAllUsages, minUsagesNumberToShowDialog);
    }

    @Override
    public boolean isAvailable(@NotNull Project project2, Editor editor, PsiFile file2) {
        if (this.myTargetMethod.isValid() && this.myExpressions.length > this.myTargetMethod.getParameterList().getParametersCount() && super.isAvailable(project2, editor, file2)) {
            ArrayList<ParameterInfoImpl> result = new ArrayList<ParameterInfoImpl>();
            if (super.findNewParamsPlace(this.myExpressions, this.myTargetMethod, this.mySubstitutor, new StringBuilder(), new HashSet<ParameterInfoImpl>(), this.myTargetMethod.getParameterList().getParameters(), result)) {
                if (this.myNewParametersInfo.length != result.size()) {
                    return true;
                }
                int size = result.size();
                for (int i = 0; i < size; ++i) {
                    ParameterInfoImpl info = result.get(i);
                    if (this.myNewParametersInfo[i].equals(info)) continue;
                    return true;
                }
            }
        }
        return false;
    }

    @Override
    protected boolean findNewParamsPlace(PsiExpression[] expressions, PsiMethod targetMethod, PsiSubstitutor substitutor, StringBuilder buf, HashSet<ParameterInfoImpl> newParams, PsiParameter[] parameters, List<ParameterInfoImpl> result) {
        HashSet<String> existingNames = new HashSet<String>();
        for (PsiParameter parameter : parameters) {
            existingNames.add(parameter.getName());
        }
        int ei = expressions.length - 1;
        int pi = parameters.length - 1;
        PsiParameter varargParam = targetMethod.isVarArgs() ? parameters[parameters.length - 1] : null;
        ArrayList<String> params = new ArrayList<String>();
        while (ei >= 0 || pi >= 0) {
            PsiType type;
            boolean parameterAssignable;
            PsiExpression expression = ei >= 0 ? expressions[ei] : null;
            PsiParameter parameter = pi >= 0 ? parameters[pi] : null;
            PsiType paramType = parameter == null ? null : substitutor.substitute(parameter.getType());
            boolean bl = parameterAssignable = paramType != null && (expression == null || TypeConversionUtil.areTypesAssignmentCompatible((PsiType)paramType, (PsiExpression)expression));
            if (parameterAssignable) {
                type = parameter.getType();
                result.add(0, new ParameterInfoImpl(pi, parameter.getName(), type));
                params.add(0, ChangeMethodSignatureFromUsageReverseOrderFix.escapePresentableType(type));
                --pi;
                --ei;
                continue;
            }
            if (ChangeMethodSignatureFromUsageReverseOrderFix.isArgumentInVarargPosition(expressions, ei, varargParam, substitutor)) {
                if (pi == parameters.length - 1) {
                    assert (varargParam != null);
                    type = varargParam.getType();
                    result.add(0, new ParameterInfoImpl(pi, varargParam.getName(), type));
                    params.add(0, ChangeMethodSignatureFromUsageReverseOrderFix.escapePresentableType(type));
                }
                --pi;
                --ei;
                continue;
            }
            if (expression == null) continue;
            if (varargParam != null && pi >= parameters.length) {
                return false;
            }
            PsiType exprType = RefactoringUtil.getTypeByExpression(expression);
            if (exprType == null) {
                return false;
            }
            JavaCodeStyleManager codeStyleManager = JavaCodeStyleManager.getInstance((Project)expression.getProject());
            String name = ChangeMethodSignatureFromUsageReverseOrderFix.suggestUniqueParameterName(codeStyleManager, expression, exprType, existingNames);
            ParameterInfoImpl newParameterInfo = new ParameterInfoImpl(-1, name, exprType, expression.getText().replace('\n', ' '));
            result.add(0, newParameterInfo);
            newParams.add(newParameterInfo);
            params.add(0, "<b>" + ChangeMethodSignatureFromUsageReverseOrderFix.escapePresentableType(exprType) + "</b>");
            --ei;
        }
        if (result.size() != expressions.length && varargParam == null) {
            return false;
        }
        buf.append(StringUtil.join(params, (String)", "));
        return true;
    }
}

