/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.daemon.impl.quickfix;

import com.intellij.codeInsight.ExceptionUtil;
import com.intellij.codeInsight.FileModificationService;
import com.intellij.codeInsight.daemon.QuickFixBundle;
import com.intellij.codeInsight.daemon.impl.quickfix.AddExceptionToThrowsFix;
import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiJavaFile;
import com.intellij.psi.PsiLambdaExpression;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiThrowStatement;
import com.intellij.psi.PsiType;
import com.intellij.psi.util.PsiTreeUtil;
import java.util.Collections;
import org.jetbrains.annotations.NotNull;

public class AddRuntimeExceptionToThrowsAction
implements IntentionAction {
    public boolean startInWriteAction() {
        return false;
    }

    @NotNull
    public String getText() {
        return QuickFixBundle.message("add.runtime.exception.to.throws.text", new Object[0]);
    }

    public void invoke(@NotNull Project project2, Editor editor, PsiFile file2) {
        if (!FileModificationService.getInstance().prepareFileForWrite(file2)) {
            return;
        }
        PsiDocumentManager.getInstance((Project)project2).commitAllDocuments();
        PsiClassType aClass = AddRuntimeExceptionToThrowsAction.getRuntimeExceptionAtCaret(editor, file2);
        PsiMethod method = (PsiMethod)PsiTreeUtil.getParentOfType((PsiElement)AddRuntimeExceptionToThrowsAction.elementAtCaret(editor, file2), PsiMethod.class);
        AddExceptionToThrowsFix.addExceptionsToThrowsList(project2, method, Collections.singleton(aClass));
    }

    private static boolean isMethodThrows(PsiMethod method, PsiClassType exception) {
        PsiClassType[] throwsTypes;
        for (PsiClassType throwsType : throwsTypes = method.getThrowsList().getReferencedTypes()) {
            if (!throwsType.isAssignableFrom((PsiType)exception)) continue;
            return true;
        }
        return false;
    }

    public boolean isAvailable(@NotNull Project project2, Editor editor, PsiFile file2) {
        if (!(file2 instanceof PsiJavaFile)) {
            return false;
        }
        PsiClassType exception = AddRuntimeExceptionToThrowsAction.getRuntimeExceptionAtCaret(editor, file2);
        if (exception == null) {
            return false;
        }
        PsiMethod method = (PsiMethod)PsiTreeUtil.getParentOfType((PsiElement)AddRuntimeExceptionToThrowsAction.elementAtCaret(editor, file2), PsiMethod.class, (boolean)true, (Class[])new Class[]{PsiLambdaExpression.class});
        if (method == null || !method.getThrowsList().isPhysical()) {
            return false;
        }
        return !AddRuntimeExceptionToThrowsAction.isMethodThrows(method, exception);
    }

    private static PsiClassType getRuntimeExceptionAtCaret(Editor editor, PsiFile file2) {
        PsiElement element = AddRuntimeExceptionToThrowsAction.elementAtCaret(editor, file2);
        if (element == null) {
            return null;
        }
        PsiThrowStatement expression = (PsiThrowStatement)PsiTreeUtil.getParentOfType((PsiElement)element, PsiThrowStatement.class);
        if (expression == null) {
            return null;
        }
        PsiExpression exception = expression.getException();
        if (exception == null) {
            return null;
        }
        PsiType type = exception.getType();
        if (!(type instanceof PsiClassType)) {
            return null;
        }
        if (!ExceptionUtil.isUncheckedException((PsiClassType)type)) {
            return null;
        }
        return (PsiClassType)type;
    }

    private static PsiElement elementAtCaret(Editor editor, PsiFile file2) {
        int offset = editor.getCaretModel().getOffset();
        return file2.findElementAt(offset);
    }

    @NotNull
    public String getFamilyName() {
        return QuickFixBundle.message("add.runtime.exception.to.throws.family", new Object[0]);
    }
}

