/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.daemon.impl.quickfix;

import com.intellij.codeInsight.FileModificationService;
import com.intellij.codeInsight.daemon.QuickFixBundle;
import com.intellij.codeInsight.daemon.impl.quickfix.CreateFromUsageUtils;
import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.popup.ListPopupStep;
import com.intellij.openapi.ui.popup.PopupStep;
import com.intellij.openapi.ui.popup.util.BaseListPopupStep;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.SmartPointerManager;
import com.intellij.psi.SmartPsiElementPointer;
import com.intellij.ui.popup.list.ListPopupImpl;
import com.intellij.util.IncorrectOperationException;
import java.util.ArrayList;
import java.util.List;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;

public class AddMethodQualifierFix
implements IntentionAction {
    private static final boolean UNIT_TEST_MODE = ApplicationManager.getApplication().isUnitTestMode();
    private final SmartPsiElementPointer<PsiMethodCallExpression> myMethodCall;
    private List<PsiVariable> myCandidates = null;

    public AddMethodQualifierFix(PsiMethodCallExpression methodCallExpression) {
        this.myMethodCall = SmartPointerManager.getInstance((Project)methodCallExpression.getProject()).createSmartPsiElementPointer((PsiElement)methodCallExpression);
    }

    @NotNull
    public String getText() {
        String text = QuickFixBundle.message("add.method.qualifier.fix.text", this.myCandidates.size() > 1 ? "" : this.myCandidates.get(0).getName());
        if (this.myCandidates.size() > 1) {
            text = text + "...";
        }
        return text;
    }

    @NotNull
    public String getFamilyName() {
        return this.getText();
    }

    public boolean isAvailable(@NotNull Project project2, Editor editor, PsiFile file2) {
        PsiMethodCallExpression element = (PsiMethodCallExpression)this.myMethodCall.getElement();
        if (element == null || !element.isValid()) {
            return false;
        }
        return this.getOrFindCandidates().size() != 0;
    }

    private synchronized List<PsiVariable> getOrFindCandidates() {
        if (this.myCandidates == null) {
            this.findCandidates();
        }
        return this.myCandidates;
    }

    private void findCandidates() {
        this.myCandidates = new ArrayList<PsiVariable>();
        PsiMethodCallExpression methodCallElement = (PsiMethodCallExpression)this.myMethodCall.getElement();
        String methodName = methodCallElement.getMethodExpression().getReferenceName();
        if (methodName == null) {
            return;
        }
        for (PsiVariable var : CreateFromUsageUtils.guessMatchingVariables((PsiExpression)methodCallElement)) {
            PsiClass resolvedClass;
            PsiType type;
            if (var.getName() == null || !((type = var.getType()) instanceof PsiClassType) || (resolvedClass = ((PsiClassType)type).resolve()) == null || resolvedClass.findMethodsByName(methodName, true).length <= 0) continue;
            this.myCandidates.add(var);
        }
    }

    public List<PsiVariable> getCandidates() {
        return this.myCandidates;
    }

    public void invoke(@NotNull Project project2, Editor editor, PsiFile file2) throws IncorrectOperationException {
        if (!FileModificationService.getInstance().preparePsiElementsForWrite(new PsiElement[]{file2})) {
            return;
        }
        if (this.myCandidates.size() == 1 || UNIT_TEST_MODE) {
            this.qualify(this.myCandidates.get(0), editor);
        } else {
            this.chooseAndQualify(editor);
        }
    }

    private void chooseAndQualify(final Editor editor) {
        BaseListPopupStep<PsiVariable> step = new BaseListPopupStep<PsiVariable>(QuickFixBundle.message("add.qualifier", new Object[0]), this.myCandidates){

            public PopupStep onChosen(final PsiVariable selectedValue, boolean finalChoice) {
                if (selectedValue != null && finalChoice) {
                    WriteCommandAction.runWriteCommandAction((Project)selectedValue.getProject(), (Runnable)new Runnable(){

                        @Override
                        public void run() {
                            AddMethodQualifierFix.this.qualify(selectedValue, editor);
                        }
                    });
                }
                return FINAL_CHOICE;
            }

            @NotNull
            public String getTextFor(PsiVariable value) {
                return value.getName();
            }

            public Icon getIconFor(PsiVariable aValue) {
                return aValue.getIcon(0);
            }
        };
        ListPopupImpl popup = new ListPopupImpl((ListPopupStep)step);
        popup.showInBestPositionFor(editor);
    }

    private void qualify(PsiVariable qualifier, Editor editor) {
        String qualifierPresentableText = qualifier.getName();
        PsiMethodCallExpression oldExpression = (PsiMethodCallExpression)this.myMethodCall.getElement();
        PsiElementFactory elementFactory = JavaPsiFacade.getElementFactory((Project)qualifier.getProject());
        PsiExpression expression = elementFactory.createExpressionFromText(qualifierPresentableText + "." + oldExpression.getMethodExpression().getReferenceName() + "()", null);
        PsiElement replacedExpression = oldExpression.replace((PsiElement)expression);
        editor.getCaretModel().moveToOffset(replacedExpression.getTextOffset() + replacedExpression.getTextLength());
    }

    public boolean startInWriteAction() {
        return true;
    }
}

