/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.daemon.impl.quickfix;

import com.intellij.codeInsight.FileModificationService;
import com.intellij.codeInsight.daemon.QuickFixBundle;
import com.intellij.codeInsight.generation.GenerateMembersUtil;
import com.intellij.codeInspection.LocalQuickFixAndIntentionActionOnPsiElement;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.codeStyle.CodeStyleManager;
import com.intellij.psi.codeStyle.JavaCodeStyleManager;
import com.intellij.psi.util.MethodSignatureUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AddMethodFix
extends LocalQuickFixAndIntentionActionOnPsiElement {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.codeInsight.daemon.impl.quickfix.AddMethodFix");
    private final PsiMethod myMethodPrototype;
    private final List<String> myExceptions = new ArrayList<String>();
    private String myText;

    public AddMethodFix(@NotNull PsiMethod methodPrototype, @NotNull PsiClass implClass) {
        super((PsiElement)implClass);
        this.myMethodPrototype = methodPrototype;
        this.setText(QuickFixBundle.message("add.method.text", methodPrototype.getName(), implClass.getName()));
    }

    public AddMethodFix(@NonNls @NotNull String methodText, @NotNull PsiClass implClass, String ... exceptions) {
        this(AddMethodFix.createMethod(methodText, implClass), implClass);
        ContainerUtil.addAll(this.myExceptions, (Object[])exceptions);
    }

    private static PsiMethod createMethod(String methodText, PsiClass implClass) {
        try {
            return JavaPsiFacade.getInstance((Project)implClass.getProject()).getElementFactory().createMethodFromText(methodText, (PsiElement)implClass);
        }
        catch (IncorrectOperationException e) {
            LOG.error((Throwable)e);
            return null;
        }
    }

    private static PsiMethod reformat(Project project2, PsiMethod result) throws IncorrectOperationException {
        CodeStyleManager codeStyleManager = CodeStyleManager.getInstance((Project)project2);
        result = (PsiMethod)codeStyleManager.reformat((PsiElement)result);
        JavaCodeStyleManager javaCodeStyleManager = JavaCodeStyleManager.getInstance((Project)project2);
        result = (PsiMethod)javaCodeStyleManager.shortenClassReferences((PsiElement)result);
        return result;
    }

    @NotNull
    public String getText() {
        return this.myText;
    }

    protected void setText(@NotNull String text) {
        this.myText = text;
    }

    @NotNull
    public String getFamilyName() {
        return QuickFixBundle.message("add.method.family", new Object[0]);
    }

    public boolean isAvailable(@NotNull Project project2, @NotNull PsiFile file2, @NotNull PsiElement startElement, @NotNull PsiElement endElement) {
        PsiClass myClass = (PsiClass)startElement;
        return this.myMethodPrototype.isValid() && myClass.isValid() && myClass.getManager().isInProject((PsiElement)myClass) && this.myText != null && MethodSignatureUtil.findMethodBySignature((PsiClass)myClass, (PsiMethod)this.myMethodPrototype, (boolean)false) == null;
    }

    public void invoke(@NotNull Project project2, @NotNull PsiFile file2, @Nullable(value="is null when called from inspection") Editor editor, @NotNull PsiElement startElement, @NotNull PsiElement endElement) {
        PsiCodeBlock body;
        PsiClass myClass = (PsiClass)startElement;
        if (!FileModificationService.getInstance().prepareFileForWrite(myClass.getContainingFile())) {
            return;
        }
        if (myClass.isInterface() && (body = this.myMethodPrototype.getBody()) != null) {
            body.delete();
        }
        for (String exception : this.myExceptions) {
            PsiUtil.addException((PsiMethod)this.myMethodPrototype, (String)exception);
        }
        PsiMethod method = (PsiMethod)myClass.add((PsiElement)this.myMethodPrototype);
        method = (PsiMethod)method.replace((PsiElement)AddMethodFix.reformat(project2, method));
        this.postAddAction(file2, editor, method);
    }

    protected void postAddAction(@NotNull PsiFile file2, @Nullable(value="is null when called from inspection") Editor editor, PsiMethod newMethod) {
        if (editor != null && newMethod.getContainingFile() == file2) {
            GenerateMembersUtil.positionCaret(editor, (PsiElement)newMethod, true);
        }
    }
}

