/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.daemon.impl.quickfix;

import com.intellij.codeInsight.FileModificationService;
import com.intellij.codeInsight.daemon.QuickFixBundle;
import com.intellij.codeInsight.daemon.impl.quickfix.CreateFromUsageUtils;
import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.util.PsiUtil;
import com.intellij.util.IncorrectOperationException;
import org.jetbrains.annotations.NotNull;

public class AddMethodBodyFix
implements IntentionAction {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.codeInsight.daemon.impl.quickfix.AddMethodBodyFix");
    private final PsiMethod myMethod;

    public AddMethodBodyFix(@NotNull PsiMethod method) {
        this.myMethod = method;
    }

    @NotNull
    public String getText() {
        return QuickFixBundle.message("add.method.body.text", new Object[0]);
    }

    @NotNull
    public String getFamilyName() {
        return this.getText();
    }

    public boolean isAvailable(@NotNull Project project2, Editor editor, PsiFile file2) {
        return this.myMethod.isValid() && this.myMethod.getBody() == null && this.myMethod.getContainingClass() != null && this.myMethod.getManager().isInProject((PsiElement)this.myMethod);
    }

    public void invoke(@NotNull Project project2, Editor editor, PsiFile file2) {
        if (!FileModificationService.getInstance().prepareFileForWrite(this.myMethod.getContainingFile())) {
            return;
        }
        try {
            PsiUtil.setModifierProperty((PsiModifierListOwner)this.myMethod, (String)"abstract", (boolean)false);
            CreateFromUsageUtils.setupMethodBody(this.myMethod);
            CreateFromUsageUtils.setupEditor(this.myMethod, editor);
        }
        catch (IncorrectOperationException e) {
            LOG.error((Throwable)e);
        }
    }

    public boolean startInWriteAction() {
        return true;
    }
}

