/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.daemon.impl.quickfix;

import com.intellij.codeInsight.daemon.QuickFixBundle;
import com.intellij.codeInsight.daemon.impl.quickfix.OrderEntryFix;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.DependencyScope;
import com.intellij.openapi.roots.JavaProjectModelModificationService;
import com.intellij.openapi.roots.impl.libraries.LibraryEx;
import com.intellij.openapi.roots.libraries.Library;
import com.intellij.openapi.roots.libraries.LibraryUtil;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiReference;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class AddLibraryToDependenciesFix
extends OrderEntryFix {
    private final Library myLibrary;
    private final Module myCurrentModule;
    private final PsiReference myReference;
    private final String myQualifiedClassName;

    public AddLibraryToDependenciesFix(@NotNull Module currentModule, @NotNull Library library, @NotNull PsiReference reference, @Nullable String qualifiedClassName) {
        this.myLibrary = library;
        this.myCurrentModule = currentModule;
        this.myReference = reference;
        this.myQualifiedClassName = qualifiedClassName;
    }

    @NotNull
    public String getText() {
        return QuickFixBundle.message("orderEntry.fix.add.library.to.classpath", LibraryUtil.getPresentableName((Library)this.myLibrary));
    }

    @NotNull
    public String getFamilyName() {
        return QuickFixBundle.message("orderEntry.fix.family.add.library.to.classpath", new Object[0]);
    }

    public boolean isAvailable(@NotNull Project project2, Editor editor, PsiFile file2) {
        return !project2.isDisposed() && !this.myCurrentModule.isDisposed() && !((LibraryEx)this.myLibrary).isDisposed();
    }

    public void invoke(@NotNull Project project2, @Nullable Editor editor, PsiFile file2) {
        DependencyScope scope = AddLibraryToDependenciesFix.suggestScopeByLocation(this.myCurrentModule, this.myReference.getElement());
        JavaProjectModelModificationService.getInstance(project2).addDependency(this.myCurrentModule, this.myLibrary, scope);
        if (editor != null) {
            AddLibraryToDependenciesFix.importClass(this.myCurrentModule, editor, this.myReference, this.myQualifiedClassName);
        }
    }
}

