/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.daemon.impl.analysis.encoding;

import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.codeInsight.lookup.LookupElementBuilder;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.vfs.CharsetToolkit;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiReference;
import com.intellij.util.IncorrectOperationException;
import java.nio.charset.Charset;
import java.util.ArrayList;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class EncodingReference
implements PsiReference {
    private final PsiElement myElement;
    private final String myCharsetName;
    private final TextRange myRangeInElement;

    public EncodingReference(PsiElement element, String charsetName, TextRange rangeInElement) {
        this.myElement = element;
        this.myCharsetName = charsetName;
        this.myRangeInElement = rangeInElement;
    }

    public PsiElement getElement() {
        return this.myElement;
    }

    public TextRange getRangeInElement() {
        return this.myRangeInElement;
    }

    @Nullable
    public PsiElement resolve() {
        return CharsetToolkit.forName((String)this.myCharsetName) == null ? null : this.myElement;
    }

    @NotNull
    public String getCanonicalText() {
        return this.myCharsetName;
    }

    public PsiElement handleElementRename(String newElementName) throws IncorrectOperationException {
        return null;
    }

    public PsiElement bindToElement(@NotNull PsiElement element) throws IncorrectOperationException {
        return null;
    }

    public boolean isReferenceTo(PsiElement element) {
        return false;
    }

    @NotNull
    public Object[] getVariants() {
        Charset[] charsets = CharsetToolkit.getAvailableCharsets();
        ArrayList<LookupElementBuilder> suggestions = new ArrayList<LookupElementBuilder>(charsets.length);
        for (Charset charset : charsets) {
            suggestions.add(LookupElementBuilder.create((String)charset.name()).withCaseSensitivity(false));
        }
        return suggestions.toArray(new LookupElement[suggestions.size()]);
    }

    public boolean isSoft() {
        return false;
    }
}

