/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.daemon.impl.analysis;

import com.intellij.lang.annotation.AnnotationHolder;
import com.intellij.lang.annotation.Annotator;
import com.intellij.openapi.editor.XmlHighlighterColors;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.impl.source.xml.SchemaPrefixReference;
import com.intellij.psi.xml.XmlAttribute;
import com.intellij.psi.xml.XmlTag;
import com.intellij.util.containers.ContainerUtil;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class XmlNsPrefixAnnotator
implements Annotator {
    public void annotate(@NotNull PsiElement element, @NotNull AnnotationHolder holder) {
        if (element instanceof XmlTag || element instanceof XmlAttribute) {
            List references = ContainerUtil.findAll((Object[])element.getReferences(), SchemaPrefixReference.class);
            for (SchemaPrefixReference reference : references) {
                TextRange rangeInElement = reference.getRangeInElement();
                if (rangeInElement.isEmpty()) continue;
                TextRange range = rangeInElement.shiftRight(element.getTextRange().getStartOffset());
                holder.createInfoAnnotation(range, null).setTextAttributes(XmlHighlighterColors.XML_NS_PREFIX);
            }
        }
    }
}

