/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.daemon.impl.analysis;

import com.intellij.codeInsight.CodeInsightBundle;
import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.ex.JavaSdkUtil;
import com.intellij.openapi.roots.JavaProjectModelModificationService;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.pom.java.LanguageLevel;
import com.intellij.psi.PsiFile;
import com.intellij.util.IncorrectOperationException;
import org.jetbrains.annotations.NotNull;

public class IncreaseLanguageLevelFix
implements IntentionAction {
    private static final Logger LOG = Logger.getInstance((String)("#" + IncreaseLanguageLevelFix.class.getName()));
    private final LanguageLevel myLevel;

    public IncreaseLanguageLevelFix(@NotNull LanguageLevel targetLevel) {
        this.myLevel = targetLevel;
    }

    @NotNull
    public String getText() {
        return CodeInsightBundle.message((String)"set.language.level.to.0", (Object[])new Object[]{this.myLevel.getPresentableText()});
    }

    @NotNull
    public String getFamilyName() {
        return CodeInsightBundle.message((String)"set.language.level", (Object[])new Object[0]);
    }

    public boolean isAvailable(@NotNull Project project2, Editor editor, PsiFile file2) {
        VirtualFile virtualFile = file2.getVirtualFile();
        if (virtualFile == null) {
            return false;
        }
        Module module2 = ModuleUtilCore.findModuleForFile((VirtualFile)virtualFile, (Project)project2);
        if (module2 == null) {
            return false;
        }
        return JavaSdkUtil.isLanguageLevelAcceptable(project2, module2, this.myLevel);
    }

    public void invoke(@NotNull Project project2, Editor editor, PsiFile file2) throws IncorrectOperationException {
        VirtualFile virtualFile = file2.getVirtualFile();
        LOG.assertTrue(virtualFile != null);
        Module module2 = ModuleUtilCore.findModuleForFile((VirtualFile)virtualFile, (Project)project2);
        if (module2 == null) {
            return;
        }
        JavaProjectModelModificationService.getInstance(project2).changeLanguageLevel(module2, this.myLevel);
    }

    public boolean startInWriteAction() {
        return true;
    }
}

