/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.daemon.impl.analysis;

import com.intellij.codeInsight.daemon.impl.analysis.DefaultHighlightingSettingProvider;
import com.intellij.codeInsight.daemon.impl.analysis.FileHighlightingSetting;
import com.intellij.codeInsight.daemon.impl.analysis.HighlightingLevelManager;
import com.intellij.lang.Language;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.PersistentStateComponent;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.components.State;
import com.intellij.openapi.components.Storage;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectCoreUtil;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.psi.FileViewProvider;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.SingleRootFileViewProvider;
import com.intellij.psi.search.ProjectScope;
import com.intellij.psi.util.PsiUtilBase;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jdom.Element;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

@State(name="HighlightingSettingsPerFile", storages={@Storage(value="$WORKSPACE_FILE$")})
public class HighlightingSettingsPerFile
extends HighlightingLevelManager
implements PersistentStateComponent<Element> {
    @NonNls
    private static final String SETTING_TAG = "setting";
    @NonNls
    private static final String ROOT_ATT_PREFIX = "root";
    @NonNls
    private static final String FILE_ATT = "file";
    private final Map<VirtualFile, FileHighlightingSetting[]> myHighlightSettings = new HashMap<VirtualFile, FileHighlightingSetting[]>();

    public static HighlightingSettingsPerFile getInstance(Project project2) {
        return (HighlightingSettingsPerFile)ServiceManager.getService((Project)project2, HighlightingLevelManager.class);
    }

    private static int getRootIndex(PsiFile file2) {
        FileViewProvider provider = file2.getViewProvider();
        Set languages = provider.getLanguages();
        if (languages.size() == 1) {
            return 0;
        }
        ArrayList array = new ArrayList(languages);
        Collections.sort(array, PsiUtilBase.LANGUAGE_COMPARATOR);
        for (int i = 0; i < array.size(); ++i) {
            Language language = (Language)array.get(i);
            if (provider.getPsi(language) != file2) continue;
            return i;
        }
        throw new RuntimeException("Cannot find root for: " + file2);
    }

    @NotNull
    public FileHighlightingSetting getHighlightingSettingForRoot(@NotNull PsiElement root) {
        PsiFile containingFile = root.getContainingFile();
        VirtualFile virtualFile = containingFile.getVirtualFile();
        FileHighlightingSetting[] fileHighlightingSettings = this.myHighlightSettings.get(virtualFile);
        int index = HighlightingSettingsPerFile.getRootIndex(containingFile);
        if (fileHighlightingSettings == null || fileHighlightingSettings.length <= index) {
            return HighlightingSettingsPerFile.getDefaultHighlightingSetting(root.getProject(), virtualFile);
        }
        return fileHighlightingSettings[index];
    }

    @NotNull
    private static FileHighlightingSetting getDefaultHighlightingSetting(@NotNull Project project2, VirtualFile virtualFile) {
        if (virtualFile != null) {
            Object[] providers = (DefaultHighlightingSettingProvider[])DefaultHighlightingSettingProvider.EP_NAME.getExtensions();
            List filtered = DumbService.getInstance((Project)project2).filterByDumbAwareness(providers);
            for (DefaultHighlightingSettingProvider p : filtered) {
                FileHighlightingSetting setting = p.getDefaultSetting(project2, virtualFile);
                if (setting == null) continue;
                return setting;
            }
        }
        return FileHighlightingSetting.FORCE_HIGHLIGHTING;
    }

    @NotNull
    private static FileHighlightingSetting[] getDefaults(@NotNull PsiFile file2) {
        int rootsCount = file2.getViewProvider().getLanguages().size();
        FileHighlightingSetting[] fileHighlightingSettings = new FileHighlightingSetting[rootsCount];
        for (int i = 0; i < fileHighlightingSettings.length; ++i) {
            fileHighlightingSettings[i] = FileHighlightingSetting.FORCE_HIGHLIGHTING;
        }
        return fileHighlightingSettings;
    }

    public void setHighlightingSettingForRoot(@NotNull PsiElement root, @NotNull FileHighlightingSetting setting) {
        PsiFile containingFile = root.getContainingFile();
        VirtualFile virtualFile = containingFile.getVirtualFile();
        if (virtualFile == null) {
            return;
        }
        FileHighlightingSetting[] defaults = this.myHighlightSettings.get(virtualFile);
        int rootIndex = HighlightingSettingsPerFile.getRootIndex(containingFile);
        if (defaults != null && rootIndex >= defaults.length) {
            defaults = null;
        }
        if (defaults == null) {
            defaults = HighlightingSettingsPerFile.getDefaults(containingFile);
        }
        defaults[rootIndex] = setting;
        boolean toRemove = true;
        for (FileHighlightingSetting aDefault : defaults) {
            if (aDefault == FileHighlightingSetting.NONE) continue;
            toRemove = false;
        }
        if (toRemove) {
            this.myHighlightSettings.remove(virtualFile);
        } else {
            this.myHighlightSettings.put(virtualFile, defaults);
        }
    }

    public void loadState(Element element) {
        List children2 = element.getChildren(SETTING_TAG);
        for (Object aChildren : children2) {
            VirtualFile fileByUrl;
            Element child = (Element)aChildren;
            String url = child.getAttributeValue(FILE_ATT);
            if (url == null || (fileByUrl = VirtualFileManager.getInstance().findFileByUrl(url)) == null) continue;
            ArrayList<FileHighlightingSetting> settings = new ArrayList<FileHighlightingSetting>();
            int index = 0;
            while (child.getAttributeValue(ROOT_ATT_PREFIX + index) != null) {
                String attributeValue = child.getAttributeValue(ROOT_ATT_PREFIX + index++);
                settings.add(Enum.valueOf(FileHighlightingSetting.class, attributeValue));
            }
            this.myHighlightSettings.put(fileByUrl, settings.toArray(new FileHighlightingSetting[settings.size()]));
        }
    }

    public Element getState() {
        Element element = new Element("state");
        for (Map.Entry<VirtualFile, FileHighlightingSetting[]> entry : this.myHighlightSettings.entrySet()) {
            Element child = new Element(SETTING_TAG);
            VirtualFile vFile = entry.getKey();
            if (!vFile.isValid()) continue;
            child.setAttribute(FILE_ATT, vFile.getUrl());
            for (int i = 0; i < entry.getValue().length; ++i) {
                FileHighlightingSetting fileHighlightingSetting = entry.getValue()[i];
                child.setAttribute(ROOT_ATT_PREFIX + i, fileHighlightingSetting.toString());
            }
            element.addContent(child);
        }
        return element;
    }

    @Override
    public boolean shouldHighlight(@NotNull PsiElement psiRoot) {
        FileHighlightingSetting settingForRoot = this.getHighlightingSettingForRoot(psiRoot);
        return settingForRoot != FileHighlightingSetting.SKIP_HIGHLIGHTING;
    }

    @Override
    public boolean shouldInspect(@NotNull PsiElement psiRoot) {
        if (ApplicationManager.getApplication().isUnitTestMode()) {
            return true;
        }
        FileHighlightingSetting settingForRoot = this.getHighlightingSettingForRoot(psiRoot);
        if (settingForRoot == FileHighlightingSetting.SKIP_HIGHLIGHTING || settingForRoot == FileHighlightingSetting.SKIP_INSPECTION) {
            return false;
        }
        Project project2 = psiRoot.getProject();
        VirtualFile virtualFile = psiRoot.getContainingFile().getVirtualFile();
        if (virtualFile == null || !virtualFile.isValid()) {
            return false;
        }
        if (ProjectCoreUtil.isProjectOrWorkspaceFile((VirtualFile)virtualFile)) {
            return false;
        }
        ProjectFileIndex fileIndex = ProjectRootManager.getInstance((Project)project2).getFileIndex();
        if (ProjectScope.getLibrariesScope((Project)project2).contains(virtualFile) && !fileIndex.isInContent(virtualFile)) {
            return false;
        }
        return !SingleRootFileViewProvider.isTooLargeForIntelligence(virtualFile);
    }
}

