/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.daemon.impl.actions;

import com.intellij.codeInsight.daemon.HighlightDisplayKey;
import com.intellij.codeInsight.daemon.impl.actions.AbstractBatchSuppressByNoInspectionCommentFix;
import com.intellij.codeInsight.daemon.impl.actions.SuppressFix;
import com.intellij.codeInspection.JavaSuppressionUtil;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiModifierList;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.IncorrectOperationException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SuppressParameterFix
extends AbstractBatchSuppressByNoInspectionCommentFix {
    private String myAlternativeID;

    public SuppressParameterFix(@NotNull HighlightDisplayKey key) {
        this(key.getID());
        this.myAlternativeID = HighlightDisplayKey.getAlternativeID((HighlightDisplayKey)key);
    }

    public SuppressParameterFix(String ID2) {
        super(ID2, false);
    }

    @Override
    @NotNull
    public String getText() {
        return "Suppress for parameter";
    }

    @Override
    @Nullable
    public PsiElement getContainer(PsiElement context) {
        PsiParameter psiParameter = (PsiParameter)PsiTreeUtil.getParentOfType((PsiElement)context, PsiParameter.class, (boolean)false);
        return psiParameter != null && psiParameter.getTypeElement() != null && JavaSuppressionUtil.canHave15Suppressions((PsiElement)psiParameter) ? psiParameter : null;
    }

    @Override
    protected boolean replaceSuppressionComments(PsiElement container) {
        return false;
    }

    @Override
    protected void createSuppression(@NotNull Project project2, @NotNull PsiElement element, @NotNull PsiElement cont) throws IncorrectOperationException {
        PsiModifierListOwner container = (PsiModifierListOwner)cont;
        PsiModifierList modifierList = container.getModifierList();
        if (modifierList != null) {
            String id = SuppressFix.getID((PsiElement)container, this.myAlternativeID);
            JavaSuppressionUtil.addSuppressAnnotation(project2, (PsiElement)container, container, id != null ? id : this.myID);
        }
    }
}

