/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.daemon.impl.actions;

import com.intellij.codeInsight.daemon.HighlightDisplayKey;
import com.intellij.codeInsight.daemon.impl.actions.SuppressByCommentFix;
import com.intellij.codeInspection.JavaSuppressionUtil;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiLocalVariable;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiStatement;
import com.intellij.psi.SyntheticElement;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.IncorrectOperationException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SuppressByJavaCommentFix
extends SuppressByCommentFix {
    public SuppressByJavaCommentFix(@NotNull HighlightDisplayKey key) {
        super(key, PsiStatement.class);
    }

    @Override
    @Nullable
    public PsiElement getContainer(PsiElement context) {
        if (SuppressByJavaCommentFix.hasJspMethodCallAsParent(context)) {
            return null;
        }
        return PsiTreeUtil.getParentOfType((PsiElement)context, PsiStatement.class, (boolean)false);
    }

    private static boolean hasJspMethodCallAsParent(PsiElement context) {
        PsiMethod method;
        while ((method = (PsiMethod)PsiTreeUtil.getParentOfType((PsiElement)context, PsiMethod.class)) != null) {
            if (method instanceof SyntheticElement) {
                return true;
            }
            context = method;
        }
        return false;
    }

    @Override
    protected void createSuppression(@NotNull Project project2, @NotNull PsiElement element, @NotNull PsiElement container) throws IncorrectOperationException {
        PsiElement declaredElement = JavaSuppressionUtil.getElementToAnnotate(element, container);
        if (declaredElement == null) {
            this.suppressWithComment(project2, element, container);
        } else {
            JavaSuppressionUtil.addSuppressAnnotation(project2, container, (PsiModifierListOwner)((PsiLocalVariable)declaredElement), this.myID);
        }
    }

    protected void suppressWithComment(Project project2, PsiElement element, PsiElement container) {
        super.createSuppression(project2, element, container);
    }
}

