/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.daemon.impl.actions;

import com.intellij.codeInsight.FileModificationService;
import com.intellij.codeInsight.daemon.impl.actions.SuppressFix;
import com.intellij.codeInspection.InspectionsBundle;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiDocCommentOwner;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiModifierList;
import com.intellij.psi.javadoc.PsiDocComment;
import com.intellij.psi.javadoc.PsiDocTag;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.IncorrectOperationException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SuppressAllForClassFix
extends SuppressFix {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.codeInsight.daemon.impl.actions.AddNoInspectionAllForClassFix");

    public SuppressAllForClassFix() {
        super("ALL");
    }

    @Override
    @Nullable
    public PsiDocCommentOwner getContainer(PsiElement element) {
        PsiDocCommentOwner container = super.getContainer(element);
        if (container == null) {
            return null;
        }
        while (container != null) {
            PsiClass parentClass = (PsiClass)PsiTreeUtil.getParentOfType((PsiElement)container, PsiClass.class);
            if (parentClass == null && container instanceof PsiClass) {
                return container;
            }
            container = parentClass;
        }
        return container;
    }

    @Override
    @NotNull
    public String getText() {
        return InspectionsBundle.message((String)"suppress.all.for.class", (Object[])new Object[0]);
    }

    @Override
    public void invoke(@NotNull Project project2, @NotNull PsiElement element) throws IncorrectOperationException {
        PsiDocCommentOwner container = this.getContainer(element);
        LOG.assertTrue(container != null);
        if (!FileModificationService.getInstance().preparePsiElementForWrite((PsiElement)container)) {
            return;
        }
        if (this.use15Suppressions(container)) {
            PsiAnnotation annotation;
            PsiModifierList modifierList = container.getModifierList();
            if (modifierList != null && (annotation = modifierList.findAnnotation("java.lang.SuppressWarnings")) != null) {
                annotation.replace((PsiElement)JavaPsiFacade.getInstance((Project)project2).getElementFactory().createAnnotationFromText("@java.lang.SuppressWarnings(\"ALL\")", (PsiElement)container));
                return;
            }
        } else {
            PsiDocTag noInspectionTag;
            PsiDocComment docComment = container.getDocComment();
            if (docComment != null && (noInspectionTag = docComment.findTagByName("noinspection")) != null) {
                String tagText = "@noinspection ALL";
                noInspectionTag.replace((PsiElement)JavaPsiFacade.getInstance((Project)project2).getElementFactory().createDocTagFromText(tagText));
                return;
            }
        }
        super.invoke(project2, element);
    }
}

