/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.daemon.impl;

import com.intellij.codeHighlighting.TextEditorHighlightingPass;
import com.intellij.codeHighlighting.TextEditorHighlightingPassFactory;
import com.intellij.codeHighlighting.TextEditorHighlightingPassRegistrar;
import com.intellij.codeInsight.daemon.impl.LineMarkersPass;
import com.intellij.codeInsight.daemon.impl.VisibleHighlightingPassFactory;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiFile;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class VisibleLineMarkersPassFactory
extends VisibleHighlightingPassFactory
implements TextEditorHighlightingPassFactory {
    public VisibleLineMarkersPassFactory(Project project2, TextEditorHighlightingPassRegistrar highlightingPassRegistrar) {
        super(project2);
        highlightingPassRegistrar.registerTextEditorHighlightingPass((TextEditorHighlightingPassFactory)this, null, null, false, 10);
    }

    @NonNls
    @NotNull
    public String getComponentName() {
        return "VisibleLineMarkersPassFactory";
    }

    @Override
    @Nullable
    public TextEditorHighlightingPass createHighlightingPass(@NotNull PsiFile file2, @NotNull Editor editor) {
        TextRange textRange = VisibleLineMarkersPassFactory.calculateRangeToProcess(editor);
        if (textRange == null) {
            return null;
        }
        return new LineMarkersPass(file2.getProject(), file2, editor, editor.getDocument(), textRange);
    }
}

