/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.daemon.impl;

import com.intellij.codeInsight.daemon.GutterMark;
import com.intellij.codeInsight.daemon.impl.DaemonCodeAnalyzerEx;
import com.intellij.codeInsight.daemon.impl.HighlightInfo;
import com.intellij.codeInsight.daemon.impl.HighlightInfoType;
import com.intellij.codeInsight.daemon.impl.HighlightersRecycler;
import com.intellij.codeInsight.daemon.impl.SeverityRegistrar;
import com.intellij.lang.annotation.HighlightSeverity;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.RangeMarker;
import com.intellij.openapi.editor.colors.EditorColorsScheme;
import com.intellij.openapi.editor.event.DocumentEvent;
import com.intellij.openapi.editor.ex.DocumentEx;
import com.intellij.openapi.editor.ex.MarkupModelEx;
import com.intellij.openapi.editor.ex.RangeHighlighterEx;
import com.intellij.openapi.editor.impl.DocumentMarkupModel;
import com.intellij.openapi.editor.impl.RangeMarkerTree;
import com.intellij.openapi.editor.impl.RedBlackTree;
import com.intellij.openapi.editor.markup.GutterIconRenderer;
import com.intellij.openapi.editor.markup.HighlighterTargetArea;
import com.intellij.openapi.editor.markup.MarkupModel;
import com.intellij.openapi.editor.markup.RangeHighlighter;
import com.intellij.openapi.editor.markup.TextAttributes;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.ProperTextRange;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.util.Consumer;
import com.intellij.util.Processor;
import com.intellij.util.containers.ContainerUtil;
import gnu.trove.THashMap;
import gnu.trove.THashSet;
import java.awt.Color;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class UpdateHighlightersUtil {
    private static final Comparator<HighlightInfo> BY_START_OFFSET_NODUPS = (o1, o2) -> {
        int d = o1.getActualStartOffset() - o2.getActualStartOffset();
        if (d != 0) {
            return d;
        }
        d = o1.getActualEndOffset() - o2.getActualEndOffset();
        if (d != 0) {
            return d;
        }
        d = Comparing.compare((Comparable)o1.getSeverity(), (Comparable)o2.getSeverity());
        if (d != 0) {
            return -d;
        }
        if (!Comparing.equal((Object)o1.type, (Object)o2.type)) {
            return String.valueOf(o1.type).compareTo(String.valueOf(o2.type));
        }
        if (!Comparing.equal((Object)o1.getGutterIconRenderer(), (Object)o2.getGutterIconRenderer())) {
            return String.valueOf(o1.getGutterIconRenderer()).compareTo(String.valueOf(o2.getGutterIconRenderer()));
        }
        if (!Comparing.equal((Object)o1.forcedTextAttributes, (Object)o2.forcedTextAttributes)) {
            return String.valueOf(o1.getGutterIconRenderer()).compareTo(String.valueOf(o2.getGutterIconRenderer()));
        }
        if (!Comparing.equal((Object)o1.forcedTextAttributesKey, (Object)o2.forcedTextAttributesKey)) {
            return String.valueOf(o1.getGutterIconRenderer()).compareTo(String.valueOf(o2.getGutterIconRenderer()));
        }
        return Comparing.compare((Comparable)((Object)o1.getDescription()), (Comparable)((Object)o2.getDescription()));
    };
    private static final Key<Boolean> TYPING_INSIDE_HIGHLIGHTER_OCCURRED = Key.create((String)"TYPING_INSIDE_HIGHLIGHTER_OCCURRED");

    private static boolean isCoveredByOffsets(HighlightInfo info, HighlightInfo coveredBy) {
        return coveredBy.startOffset <= info.startOffset && info.endOffset <= coveredBy.endOffset && info.getGutterIconRenderer() == null;
    }

    static void addHighlighterToEditorIncrementally(@NotNull Project project2, @NotNull Document document, @NotNull PsiFile file2, int startOffset, int endOffset, @NotNull HighlightInfo info, @Nullable EditorColorsScheme colorsScheme, int group, @NotNull Map<TextRange, RangeMarker> ranges2markersCache) {
        ApplicationManager.getApplication().assertIsDispatchThread();
        if (UpdateHighlightersUtil.isFileLevelOrGutterAnnotation(info)) {
            return;
        }
        if (info.getStartOffset() < startOffset || info.getEndOffset() > endOffset) {
            return;
        }
        MarkupModel markup = DocumentMarkupModel.forDocument(document, project2, true);
        SeverityRegistrar severityRegistrar = SeverityRegistrar.getSeverityRegistrar(project2);
        boolean myInfoIsError = UpdateHighlightersUtil.isSevere(info, severityRegistrar);
        Processor otherHighlightInTheWayProcessor = oldInfo -> {
            if (!myInfoIsError && UpdateHighlightersUtil.isCovered(info, severityRegistrar, oldInfo)) {
                return false;
            }
            return oldInfo.getGroup() != group || !oldInfo.equalsByActualOffset(info);
        };
        boolean allIsClear = DaemonCodeAnalyzerEx.processHighlights(document, project2, null, info.getActualStartOffset(), info.getActualEndOffset(), (Processor<HighlightInfo>)otherHighlightInTheWayProcessor);
        if (allIsClear) {
            UpdateHighlightersUtil.createOrReuseHighlighterFor(info, colorsScheme, document, group, file2, (MarkupModelEx)markup, null, ranges2markersCache, severityRegistrar);
            UpdateHighlightersUtil.clearWhiteSpaceOptimizationFlag(document);
            UpdateHighlightersUtil.assertMarkupConsistent(markup, project2);
        }
    }

    public static boolean isFileLevelOrGutterAnnotation(HighlightInfo info) {
        return info.isFileLevelAnnotation() || info.getGutterIconRenderer() != null;
    }

    public static void setHighlightersToEditor(@NotNull Project project2, @NotNull Document document, int startOffset, int endOffset, @NotNull Collection<HighlightInfo> highlights, @Nullable EditorColorsScheme colorsScheme, int group) {
        TextRange range = new TextRange(startOffset, endOffset);
        ApplicationManager.getApplication().assertIsDispatchThread();
        PsiFile psiFile = PsiDocumentManager.getInstance((Project)project2).getPsiFile(document);
        DaemonCodeAnalyzerEx codeAnalyzer = DaemonCodeAnalyzerEx.getInstanceEx(project2);
        codeAnalyzer.cleanFileLevelHighlights(project2, group, psiFile);
        MarkupModel markup = DocumentMarkupModel.forDocument(document, project2, true);
        UpdateHighlightersUtil.assertMarkupConsistent(markup, project2);
        UpdateHighlightersUtil.setHighlightersInRange(project2, document, range, colorsScheme, new ArrayList<HighlightInfo>(highlights), (MarkupModelEx)markup, group);
    }

    @Deprecated
    public static void setHighlightersToEditor(@NotNull Project project2, @NotNull Document document, int startOffset, int endOffset, @NotNull Collection<HighlightInfo> highlights, int group) {
        UpdateHighlightersUtil.setHighlightersToEditor(project2, document, startOffset, endOffset, highlights, null, group);
    }

    static void setHighlightersOutsideRange(@NotNull Project project2, @NotNull Document document, @NotNull PsiFile psiFile, @NotNull List<HighlightInfo> infos, @Nullable EditorColorsScheme colorsScheme, int startOffset, int endOffset, @NotNull ProperTextRange priorityRange, int group) {
        ApplicationManager.getApplication().assertIsDispatchThread();
        DaemonCodeAnalyzerEx codeAnalyzer = DaemonCodeAnalyzerEx.getInstanceEx(project2);
        if (startOffset == 0 && endOffset == document.getTextLength()) {
            codeAnalyzer.cleanFileLevelHighlights(project2, group, psiFile);
        }
        MarkupModel markup = DocumentMarkupModel.forDocument(document, project2, true);
        UpdateHighlightersUtil.assertMarkupConsistent(markup, project2);
        SeverityRegistrar severityRegistrar = SeverityRegistrar.getSeverityRegistrar(project2);
        HighlightersRecycler infosToRemove = new HighlightersRecycler();
        ContainerUtil.quickSort(infos, BY_START_OFFSET_NODUPS);
        THashSet infoSet = new THashSet(infos);
        Processor processor2 = arg_0 -> UpdateHighlightersUtil.lambda$setHighlightersOutsideRange$2(group, document, startOffset, endOffset, (Set)infoSet, priorityRange, infosToRemove, arg_0);
        DaemonCodeAnalyzerEx.processHighlightsOverlappingOutside(document, project2, null, priorityRange.getStartOffset(), priorityRange.getEndOffset(), (Processor<HighlightInfo>)processor2);
        THashMap ranges2markersCache = new THashMap(10);
        boolean[] changed = new boolean[]{false};
        RangeMarkerTree.sweep(processor1 -> ContainerUtil.process((List)infos, (Processor)processor1), (arg_0, arg_1, arg_2, arg_3) -> UpdateHighlightersUtil.lambda$setHighlightersOutsideRange$4(document, startOffset, endOffset, codeAnalyzer, project2, group, psiFile, changed, severityRegistrar, priorityRange, colorsScheme, markup, infosToRemove, (Map)ranges2markersCache, arg_0, arg_1, arg_2, arg_3));
        for (RangeHighlighter rangeHighlighter : infosToRemove.forAllInGarbageBin()) {
            rangeHighlighter.dispose();
            changed[0] = true;
        }
        if (changed[0]) {
            UpdateHighlightersUtil.clearWhiteSpaceOptimizationFlag(document);
        }
        UpdateHighlightersUtil.assertMarkupConsistent(markup, project2);
    }

    static void setHighlightersInRange(@NotNull Project project2, @NotNull Document document, @NotNull TextRange range, @Nullable EditorColorsScheme colorsScheme, @NotNull List<HighlightInfo> infos, @NotNull MarkupModelEx markup, int group) {
        ApplicationManager.getApplication().assertIsDispatchThread();
        SeverityRegistrar severityRegistrar = SeverityRegistrar.getSeverityRegistrar(project2);
        HighlightersRecycler infosToRemove = new HighlightersRecycler();
        DaemonCodeAnalyzerEx.processHighlights(document, project2, null, range.getStartOffset(), range.getEndOffset(), (Processor<HighlightInfo>)((Processor)info -> {
            if (info.getGroup() == group) {
                boolean willBeRemoved;
                RangeHighlighterEx highlighter = info.highlighter;
                int hiStart = highlighter.getStartOffset();
                int hiEnd = highlighter.getEndOffset();
                boolean bl = willBeRemoved = hiEnd == document.getTextLength() && range.getEndOffset() == document.getTextLength() || range.containsRange(hiStart, hiEnd);
                if (willBeRemoved) {
                    infosToRemove.recycleHighlighter(highlighter);
                    info.highlighter = null;
                }
            }
            return true;
        }));
        ContainerUtil.quickSort(infos, BY_START_OFFSET_NODUPS);
        THashMap ranges2markersCache = new THashMap(10);
        PsiFile psiFile = PsiDocumentManager.getInstance((Project)project2).getPsiFile(document);
        DaemonCodeAnalyzerEx codeAnalyzer = DaemonCodeAnalyzerEx.getInstanceEx(project2);
        boolean[] changed = new boolean[]{false};
        RangeMarkerTree.sweep(processor2 -> ContainerUtil.process((List)infos, (Processor)processor2), (arg_0, arg_1, arg_2, arg_3) -> UpdateHighlightersUtil.lambda$setHighlightersInRange$7(psiFile, codeAnalyzer, project2, group, changed, severityRegistrar, range, colorsScheme, document, markup, infosToRemove, (Map)ranges2markersCache, arg_0, arg_1, arg_2, arg_3));
        for (RangeHighlighter rangeHighlighter : infosToRemove.forAllInGarbageBin()) {
            rangeHighlighter.dispose();
            changed[0] = true;
        }
        if (changed[0]) {
            UpdateHighlightersUtil.clearWhiteSpaceOptimizationFlag(document);
        }
        UpdateHighlightersUtil.assertMarkupConsistent(markup, project2);
    }

    private static boolean isWarningCoveredByError(@NotNull HighlightInfo info, @NotNull Collection<HighlightInfo> overlappingIntervals, @NotNull SeverityRegistrar severityRegistrar) {
        if (!UpdateHighlightersUtil.isSevere(info, severityRegistrar)) {
            for (HighlightInfo overlapping : overlappingIntervals) {
                if (!UpdateHighlightersUtil.isCovered(info, severityRegistrar, overlapping)) continue;
                return true;
            }
        }
        return false;
    }

    private static boolean isCovered(@NotNull HighlightInfo warning, @NotNull SeverityRegistrar severityRegistrar, @NotNull HighlightInfo candidate) {
        if (!UpdateHighlightersUtil.isCoveredByOffsets(warning, candidate)) {
            return false;
        }
        HighlightSeverity severity = candidate.getSeverity();
        if (severity == HighlightInfoType.SYMBOL_TYPE_SEVERITY) {
            return false;
        }
        return UpdateHighlightersUtil.isSevere(candidate, severityRegistrar);
    }

    private static boolean isSevere(@NotNull HighlightInfo info, @NotNull SeverityRegistrar severityRegistrar) {
        HighlightSeverity severity = info.getSeverity();
        return severityRegistrar.compare(HighlightSeverity.ERROR, severity) <= 0 || severity == HighlightInfoType.SYMBOL_TYPE_SEVERITY;
    }

    private static void createOrReuseHighlighterFor(@NotNull HighlightInfo info, @Nullable EditorColorsScheme colorsScheme, @NotNull Document document, int group, @NotNull PsiFile psiFile, @NotNull MarkupModelEx markup, @Nullable HighlightersRecycler infosToRemove, @NotNull Map<TextRange, RangeMarker> ranges2markersCache, @NotNull SeverityRegistrar severityRegistrar) {
        int infoStartOffset = info.startOffset;
        int infoEndOffset = info.endOffset;
        int docLength = document.getTextLength();
        if (infoEndOffset > docLength) {
            infoEndOffset = docLength;
            infoStartOffset = Math.min(infoStartOffset, infoEndOffset);
        }
        if (infoEndOffset == infoStartOffset && !info.isAfterEndOfLine()) {
            if (infoEndOffset == docLength) {
                return;
            }
            ++infoEndOffset;
        }
        info.setGroup(group);
        int layer = UpdateHighlightersUtil.getLayer(info, severityRegistrar);
        RangeHighlighterEx highlighter = infosToRemove == null ? null : (RangeHighlighterEx)infosToRemove.pickupHighlighterFromGarbageBin(info.startOffset, info.endOffset, layer);
        TextRange finalInfoRange = new TextRange(infoStartOffset, infoEndOffset);
        TextAttributes infoAttributes = info.getTextAttributes((PsiElement)psiFile, colorsScheme);
        Consumer changeAttributes = finalHighlighter -> {
            ProperTextRange fixRange;
            if (infoAttributes != null) {
                finalHighlighter.setTextAttributes(infoAttributes);
            }
            highlightInfo.highlighter = finalHighlighter;
            finalHighlighter.setAfterEndOfLine(info.isAfterEndOfLine());
            Color color = info.getErrorStripeMarkColor((PsiElement)psiFile, colorsScheme);
            finalHighlighter.setErrorStripeMarkColor(color);
            if (info != finalHighlighter.getErrorStripeTooltip()) {
                finalHighlighter.setErrorStripeTooltip(info);
            }
            GutterMark renderer = info.getGutterIconRenderer();
            finalHighlighter.setGutterIconRenderer((GutterIconRenderer)renderer);
            ranges2markersCache.put(finalInfoRange, highlightInfo.highlighter);
            if (highlightInfo.quickFixActionRanges != null) {
                ArrayList<Pair> list = new ArrayList<Pair>(highlightInfo.quickFixActionRanges.size());
                for (Pair<HighlightInfo.IntentionActionDescriptor, TextRange> pair : highlightInfo.quickFixActionRanges) {
                    TextRange textRange2 = (TextRange)pair.second;
                    RangeMarker marker = UpdateHighlightersUtil.getOrCreate(document, ranges2markersCache, textRange2);
                    list.add(Pair.create((Object)pair.first, (Object)marker));
                }
                highlightInfo.quickFixActionMarkers = ContainerUtil.createLockFreeCopyOnWriteList(list);
            }
            highlightInfo.fixMarker = finalInfoRange.equals((Object)(fixRange = info.getFixTextRange())) ? null : UpdateHighlightersUtil.getOrCreate(document, ranges2markersCache, (TextRange)fixRange);
        };
        if (highlighter == null) {
            highlighter = markup.addRangeHighlighterAndChangeAttributes(infoStartOffset, infoEndOffset, layer, null, HighlighterTargetArea.EXACT_RANGE, false, (Consumer<RangeHighlighterEx>)changeAttributes);
        } else {
            markup.changeAttributesInBatch(highlighter, (Consumer<RangeHighlighterEx>)changeAttributes);
        }
        boolean attributesSet = Comparing.equal((Object)infoAttributes, (Object)highlighter.getTextAttributes());
        assert (attributesSet) : "Info: " + infoAttributes + "; colorsScheme: " + (colorsScheme == null ? "[global]" : colorsScheme.getName()) + "; highlighter:" + highlighter.getTextAttributes();
    }

    private static int getLayer(@NotNull HighlightInfo info, @NotNull SeverityRegistrar severityRegistrar) {
        HighlightSeverity severity = info.getSeverity();
        int layer = severity == HighlightSeverity.WARNING ? 4000 : (severityRegistrar.compare(severity, HighlightSeverity.ERROR) >= 0 ? 5000 : (severity == HighlightInfoType.INJECTED_FRAGMENT_SEVERITY ? 1999 : (severity == HighlightInfoType.ELEMENT_UNDER_CARET_SEVERITY ? 5500 : 3000)));
        return layer;
    }

    private static RangeMarker getOrCreate(@NotNull Document document, @NotNull Map<TextRange, RangeMarker> ranges2markersCache, @NotNull TextRange textRange) {
        RangeMarker marker = ranges2markersCache.get(textRange);
        if (marker == null) {
            marker = document.createRangeMarker(textRange);
            ranges2markersCache.put(textRange, marker);
        }
        return marker;
    }

    static boolean isWhitespaceOptimizationAllowed(@NotNull Document document) {
        return document.getUserData(TYPING_INSIDE_HIGHLIGHTER_OCCURRED) == null;
    }

    private static void disableWhiteSpaceOptimization(@NotNull Document document) {
        document.putUserData(TYPING_INSIDE_HIGHLIGHTER_OCCURRED, (Object)Boolean.TRUE);
    }

    private static void clearWhiteSpaceOptimizationFlag(@NotNull Document document) {
        document.putUserData(TYPING_INSIDE_HIGHLIGHTER_OCCURRED, null);
    }

    static void updateHighlightersByTyping(@NotNull Project project2, @NotNull DocumentEvent e) {
        ApplicationManager.getApplication().assertIsDispatchThread();
        Document document = e.getDocument();
        if (document instanceof DocumentEx && ((DocumentEx)document).isInBulkUpdate()) {
            return;
        }
        MarkupModel markup = DocumentMarkupModel.forDocument(document, project2, true);
        UpdateHighlightersUtil.assertMarkupConsistent(markup, project2);
        int start = e.getOffset() - 1;
        int end = start + Math.max(e.getOldLength(), e.getNewLength());
        ArrayList toRemove = new ArrayList();
        DaemonCodeAnalyzerEx.processHighlights(document, project2, null, start, end, (Processor<HighlightInfo>)((Processor)info -> {
            RangeHighlighterEx highlighter = info.highlighter;
            boolean remove = false;
            if (info.needUpdateOnTyping()) {
                int highlighterStart = highlighter.getStartOffset();
                int highlighterEnd = highlighter.getEndOffset();
                if (info.isAfterEndOfLine()) {
                    if (highlighterStart < document.getTextLength()) {
                        ++highlighterStart;
                    }
                    if (highlighterEnd < document.getTextLength()) {
                        ++highlighterEnd;
                    }
                }
                if (!highlighter.isValid() || start < highlighterEnd && highlighterStart <= end) {
                    remove = true;
                }
            }
            if (remove) {
                toRemove.add(info);
            }
            return true;
        }));
        for (HighlightInfo info2 : toRemove) {
            if (info2.highlighter.isValid() && !info2.type.equals(HighlightInfoType.WRONG_REF)) continue;
            info2.highlighter.dispose();
        }
        UpdateHighlightersUtil.assertMarkupConsistent(markup, project2);
        if (!toRemove.isEmpty()) {
            UpdateHighlightersUtil.disableWhiteSpaceOptimization(document);
        }
    }

    private static void assertMarkupConsistent(@NotNull MarkupModel markup, @NotNull Project project2) {
        RangeHighlighter[] allHighlighters;
        if (!RedBlackTree.VERIFY) {
            return;
        }
        Document document = markup.getDocument();
        DaemonCodeAnalyzerEx.processHighlights(document, project2, null, 0, document.getTextLength(), (Processor<HighlightInfo>)((Processor)info -> {
            assert (((MarkupModelEx)markup).containsHighlighter(info.highlighter));
            return true;
        }));
        for (RangeHighlighter highlighter : allHighlighters = markup.getAllHighlighters()) {
            boolean contains;
            Object tooltip;
            if (!highlighter.isValid() || !((tooltip = highlighter.getErrorStripeTooltip()) instanceof HighlightInfo)) continue;
            HighlightInfo info2 = (HighlightInfo)tooltip;
            boolean bl = contains = !DaemonCodeAnalyzerEx.processHighlights(document, project2, null, info2.getActualStartOffset(), info2.getActualEndOffset(), (Processor<HighlightInfo>)((Processor)highlightInfo2 -> BY_START_OFFSET_NODUPS.compare((HighlightInfo)highlightInfo2, info2) != 0));
            assert (contains) : info2;
        }
    }

    private static /* synthetic */ boolean lambda$setHighlightersInRange$7(PsiFile psiFile, DaemonCodeAnalyzerEx daemonCodeAnalyzerEx, Project project2, int n, boolean[] blArray, SeverityRegistrar severityRegistrar, TextRange textRange, EditorColorsScheme editorColorsScheme, Document document, MarkupModelEx markupModelEx, HighlightersRecycler highlightersRecycler, Map map, int offset, HighlightInfo info, boolean atStart, Collection overlappingIntervals) {
        if (!atStart) {
            return true;
        }
        if (info.isFileLevelAnnotation() && psiFile != null && psiFile.getViewProvider().isPhysical()) {
            daemonCodeAnalyzerEx.addFileLevelHighlight(project2, n, info, psiFile);
            blArray[0] = true;
            return true;
        }
        if (UpdateHighlightersUtil.isWarningCoveredByError(info, overlappingIntervals, severityRegistrar)) {
            return true;
        }
        if (info.getStartOffset() >= textRange.getStartOffset() && info.getEndOffset() <= textRange.getEndOffset() && psiFile != null) {
            UpdateHighlightersUtil.createOrReuseHighlighterFor(info, editorColorsScheme, document, n, psiFile, markupModelEx, highlightersRecycler, map, severityRegistrar);
            blArray[0] = true;
        }
        return true;
    }

    private static /* synthetic */ boolean lambda$setHighlightersOutsideRange$4(Document document, int n, int n2, DaemonCodeAnalyzerEx daemonCodeAnalyzerEx, Project project2, int n3, PsiFile psiFile, boolean[] blArray, SeverityRegistrar severityRegistrar, ProperTextRange properTextRange, EditorColorsScheme editorColorsScheme, MarkupModel markupModel, HighlightersRecycler highlightersRecycler, Map map, int offset, HighlightInfo info, boolean atStart, Collection overlappingIntervals) {
        if (!atStart) {
            return true;
        }
        if (!(info.isFromInjection() || info.getEndOffset() >= document.getTextLength() || info.getEndOffset() > n && info.getStartOffset() < n2)) {
            return true;
        }
        if (info.isFileLevelAnnotation()) {
            daemonCodeAnalyzerEx.addFileLevelHighlight(project2, n3, info, psiFile);
            blArray[0] = true;
            return true;
        }
        if (UpdateHighlightersUtil.isWarningCoveredByError(info, overlappingIntervals, severityRegistrar)) {
            return true;
        }
        if (info.getStartOffset() < properTextRange.getStartOffset() || info.getEndOffset() > properTextRange.getEndOffset()) {
            UpdateHighlightersUtil.createOrReuseHighlighterFor(info, editorColorsScheme, document, n3, psiFile, (MarkupModelEx)markupModel, highlightersRecycler, map, severityRegistrar);
            blArray[0] = true;
        }
        return true;
    }

    private static /* synthetic */ boolean lambda$setHighlightersOutsideRange$2(int n, Document document, int n2, int n3, Set set, ProperTextRange properTextRange, HighlightersRecycler highlightersRecycler, HighlightInfo info) {
        if (info.getGroup() == n) {
            boolean toRemove;
            RangeHighlighterEx highlighter = info.highlighter;
            int hiStart = highlighter.getStartOffset();
            int hiEnd = highlighter.getEndOffset();
            if (!(info.isFromInjection() || hiEnd >= document.getTextLength() || hiEnd > n2 && hiStart < n3)) {
                return true;
            }
            boolean bl = toRemove = set.contains(info) || !properTextRange.containsRange(hiStart, hiEnd) && (hiEnd != document.getTextLength() || properTextRange.getEndOffset() != document.getTextLength());
            if (toRemove) {
                highlightersRecycler.recycleHighlighter(highlighter);
                info.highlighter = null;
            }
        }
        return true;
    }
}

