/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.daemon.impl;

import com.intellij.codeHighlighting.TextEditorHighlightingPass;
import com.intellij.codeInsight.daemon.DaemonBundle;
import com.intellij.codeInsight.daemon.DaemonCodeAnalyzer;
import com.intellij.codeInsight.daemon.impl.DaemonCodeAnalyzerImpl;
import com.intellij.codeInsight.daemon.impl.HighlightInfo;
import com.intellij.codeInsight.daemon.impl.ProgressableTextEditorHighlightingPass;
import com.intellij.codeInsight.daemon.impl.SeverityRegistrar;
import com.intellij.codeInsight.daemon.impl.analysis.FileHighlightingSetting;
import com.intellij.codeInsight.daemon.impl.analysis.HighlightingSettingsPerFile;
import com.intellij.icons.AllIcons;
import com.intellij.ide.PowerSaveMode;
import com.intellij.lang.Language;
import com.intellij.lang.annotation.HighlightSeverity;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.ex.EditorMarkupModel;
import com.intellij.openapi.editor.ex.MarkupModelEx;
import com.intellij.openapi.editor.ex.RangeHighlighterEx;
import com.intellij.openapi.editor.impl.DocumentMarkupModel;
import com.intellij.openapi.editor.impl.EditorImpl;
import com.intellij.openapi.editor.impl.EditorMarkupModelImpl;
import com.intellij.openapi.editor.impl.event.MarkupModelListener;
import com.intellij.openapi.editor.markup.ErrorStripeRenderer;
import com.intellij.openapi.editor.markup.RangeHighlighter;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.FileViewProvider;
import com.intellij.psi.PsiCompiledElement;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.util.ArrayUtil;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.io.storage.HeavyProcessLatch;
import com.intellij.util.ui.UIUtil;
import com.intellij.xml.util.XmlStringUtil;
import gnu.trove.TIntArrayList;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.Icon;
import javax.swing.JLabel;
import javax.swing.JProgressBar;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TrafficLightRenderer
implements ErrorStripeRenderer,
Disposable {
    private final Project myProject;
    private final Document myDocument;
    private final PsiFile myFile;
    private final DaemonCodeAnalyzerImpl myDaemonCodeAnalyzer;
    private final SeverityRegistrar mySeverityRegistrar;
    private Icon icon;
    String statistics;
    String statusLabel;
    String statusExtraLine;
    boolean passStatusesVisible;
    final Map<ProgressableTextEditorHighlightingPass, Pair<JProgressBar, JLabel>> passes = ContainerUtil.newLinkedHashMap();
    static final int MAX = 100;
    boolean progressBarsEnabled;
    Boolean progressBarsCompleted;
    private int[] errorCount;

    public TrafficLightRenderer(@Nullable Project project2, Document document, PsiFile file2) {
        this.myProject = project2;
        this.myDaemonCodeAnalyzer = project2 == null ? null : (DaemonCodeAnalyzerImpl)DaemonCodeAnalyzer.getInstance((Project)project2);
        this.myDocument = document;
        this.myFile = file2;
        this.mySeverityRegistrar = SeverityRegistrar.getSeverityRegistrar(this.myProject);
        this.refresh();
        if (project2 != null) {
            final MarkupModelEx model = (MarkupModelEx)DocumentMarkupModel.forDocument(document, project2, true);
            model.addMarkupModelListener(this, new MarkupModelListener.Adapter(){

                @Override
                public void afterAdded(@NotNull RangeHighlighterEx highlighter) {
                    TrafficLightRenderer.this.incErrorCount(highlighter, 1);
                }

                @Override
                public void beforeRemoved(@NotNull RangeHighlighterEx highlighter) {
                    TrafficLightRenderer.this.incErrorCount(highlighter, -1);
                }
            });
            UIUtil.invokeLaterIfNeeded((Runnable)new Runnable(){

                @Override
                public void run() {
                    for (RangeHighlighter rangeHighlighter : model.getAllHighlighters()) {
                        TrafficLightRenderer.this.incErrorCount(rangeHighlighter, 1);
                    }
                }
            });
        }
    }

    private void refresh() {
        int maxIndex = this.mySeverityRegistrar.getSeverityMaxIndex();
        if (this.errorCount != null && maxIndex == this.errorCount.length) {
            return;
        }
        int[] newErrors = new int[maxIndex + 1];
        if (this.errorCount != null) {
            System.arraycopy(this.errorCount, 0, newErrors, 0, Math.min(this.errorCount.length, newErrors.length));
        }
        this.errorCount = newErrors;
    }

    static void setOrRefreshErrorStripeRenderer(@NotNull EditorMarkupModel editorMarkupModel, @NotNull Project project2, @NotNull Document document, PsiFile file2) {
        EditorImpl editor;
        ApplicationManager.getApplication().assertIsDispatchThread();
        if (!editorMarkupModel.isErrorStripeVisible() || !DaemonCodeAnalyzer.getInstance((Project)project2).isHighlightingAvailable(file2)) {
            return;
        }
        ErrorStripeRenderer renderer = editorMarkupModel.getErrorStripeRenderer();
        if (renderer instanceof TrafficLightRenderer) {
            TrafficLightRenderer tlr = (TrafficLightRenderer)renderer;
            tlr.refresh();
            ((EditorMarkupModelImpl)editorMarkupModel).repaintVerticalScrollBar();
            if (tlr.myFile == null || tlr.myFile.isValid()) {
                return;
            }
            Disposer.dispose((Disposable)tlr);
        }
        if (!(editor = (EditorImpl)editorMarkupModel.getEditor()).isDisposed()) {
            renderer = new TrafficLightRenderer(project2, document, file2);
            Disposer.register((Disposable)editor.getDisposable(), (Disposable)((Disposable)renderer));
            editorMarkupModel.setErrorStripeRenderer(renderer);
        }
    }

    public void dispose() {
    }

    private void incErrorCount(RangeHighlighter highlighter, int delta) {
        Object o = highlighter.getErrorStripeTooltip();
        if (!(o instanceof HighlightInfo)) {
            return;
        }
        HighlightInfo info = (HighlightInfo)o;
        HighlightSeverity infoSeverity = info.getSeverity();
        int severityIdx = this.mySeverityRegistrar.getSeverityIdx(infoSeverity);
        if (severityIdx != -1) {
            int n = severityIdx;
            this.errorCount[n] = this.errorCount[n] + delta;
        }
    }

    @NotNull
    protected DaemonCodeAnalyzerStatus getDaemonCodeAnalyzerStatus(@NotNull SeverityRegistrar severityRegistrar) {
        DaemonCodeAnalyzerStatus status = new DaemonCodeAnalyzerStatus();
        if (this.myFile == null) {
            status.reasonWhyDisabled = "No file";
            status.errorAnalyzingFinished = true;
            return status;
        }
        if (this.myProject != null && this.myProject.isDisposed()) {
            status.reasonWhyDisabled = "Project is disposed";
            status.errorAnalyzingFinished = true;
            return status;
        }
        if (!this.myDaemonCodeAnalyzer.isHighlightingAvailable(this.myFile)) {
            if (!this.myFile.isPhysical()) {
                status.reasonWhyDisabled = "File is generated";
                status.errorAnalyzingFinished = true;
                return status;
            }
            if (this.myFile instanceof PsiCompiledElement) {
                status.reasonWhyDisabled = "File is decompiled";
                status.errorAnalyzingFinished = true;
                return status;
            }
            FileType fileType = this.myFile.getFileType();
            if (fileType.isBinary()) {
                status.reasonWhyDisabled = "File is binary";
                status.errorAnalyzingFinished = true;
                return status;
            }
            status.reasonWhyDisabled = "Highlighting is disabled for this file";
            status.errorAnalyzingFinished = true;
            return status;
        }
        FileViewProvider provider = this.myFile.getViewProvider();
        Set languages = provider.getLanguages();
        HighlightingSettingsPerFile levelSettings = HighlightingSettingsPerFile.getInstance(this.myProject);
        boolean shouldHighlight = languages.isEmpty();
        for (Language language : languages) {
            PsiFile root = provider.getPsi(language);
            FileHighlightingSetting level = levelSettings.getHighlightingSettingForRoot((PsiElement)root);
            shouldHighlight |= level != FileHighlightingSetting.SKIP_HIGHLIGHTING;
        }
        if (!shouldHighlight) {
            status.reasonWhyDisabled = "Highlighting level is None";
            status.errorAnalyzingFinished = true;
            return status;
        }
        if (HeavyProcessLatch.INSTANCE.isRunning()) {
            status.reasonWhySuspended = StringUtil.defaultIfEmpty((String)HeavyProcessLatch.INSTANCE.getRunningOperationName(), (String)"Heavy operation is running");
            status.errorAnalyzingFinished = true;
            return status;
        }
        status.errorCount = (int[])this.errorCount.clone();
        this.fillDaemonCodeAnalyzerErrorsStatus(status, severityRegistrar);
        List<TextEditorHighlightingPass> passes = this.myDaemonCodeAnalyzer.getPassesToShowProgressFor(this.myDocument);
        status.passStati = passes.isEmpty() ? Collections.emptyList() : new ArrayList(passes.size());
        for (int i = 0; i < passes.size(); ++i) {
            ProgressableTextEditorHighlightingPass pass;
            TextEditorHighlightingPass tepass = passes.get(i);
            if (!(tepass instanceof ProgressableTextEditorHighlightingPass) || (pass = (ProgressableTextEditorHighlightingPass)tepass).getProgress() < 0.0) continue;
            status.passStati.add(pass);
        }
        status.errorAnalyzingFinished = this.myDaemonCodeAnalyzer.isAllAnalysisFinished(this.myFile);
        status.reasonWhySuspended = this.myDaemonCodeAnalyzer.isUpdateByTimerEnabled() ? null : "Highlighting is paused temporarily";
        return status;
    }

    protected void fillDaemonCodeAnalyzerErrorsStatus(@NotNull DaemonCodeAnalyzerStatus status, @NotNull SeverityRegistrar severityRegistrar) {
    }

    protected final Project getProject() {
        return this.myProject;
    }

    public String getTooltipMessage() {
        return null;
    }

    public void paint(Component c, Graphics g, Rectangle r) {
        DaemonCodeAnalyzerStatus status = this.getDaemonCodeAnalyzerStatus(this.mySeverityRegistrar);
        Icon icon = this.getIcon(status);
        icon.paintIcon(c, g, r.x, r.y);
    }

    @NotNull
    private Icon getIcon(@NotNull DaemonCodeAnalyzerStatus status) {
        this.updatePanel(status, this.getProject());
        Icon icon = this.icon;
        if (PowerSaveMode.isEnabled() || status.reasonWhySuspended != null || status.reasonWhyDisabled != null || status.errorAnalyzingFinished) {
            return icon;
        }
        return AllIcons.General.InspectionsEye;
    }

    boolean updatePanel(@NotNull DaemonCodeAnalyzerStatus status, Project project2) {
        this.progressBarsEnabled = false;
        this.progressBarsCompleted = null;
        this.statistics = "";
        this.passStatusesVisible = false;
        this.statusLabel = null;
        this.statusExtraLine = null;
        boolean result = false;
        if (!status.passStati.equals(new ArrayList<ProgressableTextEditorHighlightingPass>(this.passes.keySet()))) {
            this.rebuildPassesMap(status);
            result = true;
        }
        if (PowerSaveMode.isEnabled()) {
            this.statusLabel = "Code analysis is disabled in power save mode";
            status.errorAnalyzingFinished = true;
            this.icon = AllIcons.General.SafeMode;
            return result;
        }
        if (status.reasonWhyDisabled != null) {
            this.statusLabel = "No analysis has been performed";
            this.statusExtraLine = "(" + status.reasonWhyDisabled + ")";
            this.passStatusesVisible = true;
            this.progressBarsCompleted = Boolean.FALSE;
            this.icon = AllIcons.General.InspectionsTrafficOff;
            return result;
        }
        if (status.reasonWhySuspended != null) {
            this.statusLabel = "Code analysis has been suspended";
            this.statusExtraLine = "(" + status.reasonWhySuspended + ")";
            this.passStatusesVisible = true;
            this.progressBarsCompleted = Boolean.FALSE;
            this.icon = AllIcons.General.InspectionsPause;
            return result;
        }
        Icon icon = AllIcons.General.InspectionsOK;
        for (int i = status.errorCount.length - 1; i >= 0; --i) {
            if (status.errorCount[i] == 0) continue;
            icon = SeverityRegistrar.getSeverityRegistrar(project2).getRendererIconByIndex(i);
            break;
        }
        if (status.errorAnalyzingFinished) {
            boolean isDumb;
            boolean bl = isDumb = project2 != null && DumbService.isDumb((Project)project2);
            if (isDumb) {
                this.statusLabel = "Shallow analysis completed";
                this.statusExtraLine = "Complete results will be available after indexing";
            } else {
                this.statusLabel = DaemonBundle.message((String)"analysis.completed", (Object[])new Object[0]);
            }
            this.progressBarsCompleted = Boolean.TRUE;
        } else {
            this.statusLabel = DaemonBundle.message((String)"performing.code.analysis", (Object[])new Object[0]);
            this.passStatusesVisible = true;
            this.progressBarsEnabled = true;
            this.progressBarsCompleted = null;
        }
        int currentSeverityErrors = 0;
        String text = "";
        for (int i = status.errorCount.length - 1; i >= 0; --i) {
            if (status.errorCount[i] <= 0) continue;
            HighlightSeverity severity = SeverityRegistrar.getSeverityRegistrar(project2).getSeverityByIndex(i);
            String name = status.errorCount[i] > 1 ? StringUtil.pluralize((String)severity.getName().toLowerCase()) : severity.getName().toLowerCase();
            text = text + (status.errorAnalyzingFinished ? DaemonBundle.message((String)"errors.found", (Object[])new Object[]{status.errorCount[i], name}) : DaemonBundle.message((String)"errors.found.so.far", (Object[])new Object[]{status.errorCount[i], name}));
            text = text + "<br>";
            currentSeverityErrors += status.errorCount[i];
        }
        if (currentSeverityErrors == 0) {
            text = text + (status.errorAnalyzingFinished ? DaemonBundle.message((String)"no.errors.or.warnings.found", (Object[])new Object[0]) : DaemonBundle.message((String)"no.errors.or.warnings.found.so.far", (Object[])new Object[0]) + "<br>");
        }
        this.statistics = XmlStringUtil.wrapInHtml((CharSequence)text);
        this.icon = icon;
        return result;
    }

    private void rebuildPassesMap(@NotNull DaemonCodeAnalyzerStatus status) {
        this.passes.clear();
        for (ProgressableTextEditorHighlightingPass pass : status.passStati) {
            JProgressBar progressBar = new JProgressBar(0, 100);
            progressBar.setMaximum(100);
            progressBar.putClientProperty("JComponent.sizeVariant", "mini");
            JLabel percLabel = new JLabel();
            percLabel.setText("100%");
            this.passes.put(pass, (Pair<JProgressBar, JLabel>)Pair.create((Object)progressBar, (Object)percLabel));
        }
    }

    protected static class DaemonCodeAnalyzerStatus {
        public boolean errorAnalyzingFinished;
        List<ProgressableTextEditorHighlightingPass> passStati = Collections.emptyList();
        public int[] errorCount = ArrayUtil.EMPTY_INT_ARRAY;
        private String reasonWhyDisabled;
        private String reasonWhySuspended;

        public String toString() {
            String s = "DS: finished=" + this.errorAnalyzingFinished;
            s = s + "; pass statuses: " + this.passStati.size() + "; ";
            for (ProgressableTextEditorHighlightingPass passStatus : this.passStati) {
                s = s + String.format("(%s %2.0f%% %b)", passStatus.getPresentableName(), passStatus.getProgress() * 100.0, passStatus.isFinished());
            }
            s = s + "; error count: " + this.errorCount.length + ": " + new TIntArrayList(this.errorCount);
            return s;
        }
    }
}

