/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.daemon.impl;

import com.intellij.codeHighlighting.DirtyScopeTrackingHighlightingPassFactory;
import com.intellij.codeHighlighting.MainHighlightingPassFactory;
import com.intellij.codeHighlighting.TextEditorHighlightingPass;
import com.intellij.codeHighlighting.TextEditorHighlightingPassFactory;
import com.intellij.codeHighlighting.TextEditorHighlightingPassRegistrar;
import com.intellij.codeInsight.daemon.impl.DaemonCodeAnalyzerEx;
import com.intellij.codeInsight.daemon.impl.FileStatusMap;
import com.intellij.codeInsight.daemon.impl.HighlightInfoProcessor;
import com.intellij.codeInsight.daemon.impl.TextEditorHighlightingPassRegistrarEx;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiCompiledElement;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.util.ArrayUtil;
import gnu.trove.THashSet;
import gnu.trove.TIntArrayList;
import gnu.trove.TIntHashSet;
import gnu.trove.TIntObjectHashMap;
import gnu.trove.TIntObjectProcedure;
import gnu.trove.TIntProcedure;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TextEditorHighlightingPassRegistrarImpl
extends TextEditorHighlightingPassRegistrarEx {
    private final TIntObjectHashMap<PassConfig> myRegisteredPassFactories = new TIntObjectHashMap();
    private final List<DirtyScopeTrackingHighlightingPassFactory> myDirtyScopeTrackingFactories = new ArrayList<DirtyScopeTrackingHighlightingPassFactory>();
    private int nextAvailableId = 13;
    private boolean checkedForCycles;
    private final Project myProject;

    public TextEditorHighlightingPassRegistrarImpl(Project project2) {
        this.myProject = project2;
    }

    @Override
    public void registerTextEditorHighlightingPass(TextEditorHighlightingPassFactory factory, int anchor, int anchorPass) {
        TextEditorHighlightingPassRegistrar.Anchor anc = TextEditorHighlightingPassRegistrar.Anchor.FIRST;
        switch (anchor) {
            case 0: {
                anc = TextEditorHighlightingPassRegistrar.Anchor.FIRST;
                break;
            }
            case 1: {
                anc = TextEditorHighlightingPassRegistrar.Anchor.LAST;
                break;
            }
            case 3: {
                anc = TextEditorHighlightingPassRegistrar.Anchor.BEFORE;
                break;
            }
            case 2: {
                anc = TextEditorHighlightingPassRegistrar.Anchor.AFTER;
            }
        }
        this.registerTextEditorHighlightingPass(factory, anc, anchorPass, true, true);
    }

    @Override
    public synchronized int registerTextEditorHighlightingPass(@NotNull TextEditorHighlightingPassFactory factory, @Nullable int[] runAfterCompletionOf, @Nullable int[] runAfterOfStartingOf, boolean runIntentionsPassAfter, int forcedPassId) {
        int n;
        assert (!this.checkedForCycles);
        PassConfig info = new PassConfig(factory, runAfterCompletionOf == null || runAfterCompletionOf.length == 0 ? ArrayUtil.EMPTY_INT_ARRAY : runAfterCompletionOf, runAfterOfStartingOf == null || runAfterOfStartingOf.length == 0 ? ArrayUtil.EMPTY_INT_ARRAY : runAfterOfStartingOf);
        if (forcedPassId == -1) {
            int n2 = this.nextAvailableId;
            n = n2;
            this.nextAvailableId = n2 + 1;
        } else {
            n = forcedPassId;
        }
        int passId = n;
        PassConfig registered = (PassConfig)this.myRegisteredPassFactories.get(passId);
        assert (registered == null) : "Pass id " + passId + " has already been registered in: " + PassConfig.access$100(registered);
        this.myRegisteredPassFactories.put(passId, (Object)info);
        if (factory instanceof DirtyScopeTrackingHighlightingPassFactory) {
            this.myDirtyScopeTrackingFactories.add((DirtyScopeTrackingHighlightingPassFactory)factory);
        }
        return passId;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @NotNull
    public List<TextEditorHighlightingPass> instantiatePasses(final @NotNull PsiFile psiFile, final @NotNull Editor editor, final @NotNull int[] passesToIgnore) {
        TextEditorHighlightingPassRegistrarImpl textEditorHighlightingPassRegistrarImpl = this;
        synchronized (textEditorHighlightingPassRegistrarImpl) {
            if (!this.checkedForCycles) {
                this.checkedForCycles = true;
                this.checkForCycles();
            }
        }
        PsiDocumentManager documentManager = PsiDocumentManager.getInstance((Project)this.myProject);
        final Document document = editor.getDocument();
        PsiFile fileFromDoc = documentManager.getPsiFile(document);
        if (!(fileFromDoc instanceof PsiCompiledElement)) {
            assert (fileFromDoc == psiFile) : "Files are different: " + psiFile + ";" + fileFromDoc;
            Document documentFromFile = documentManager.getDocument(psiFile);
            assert (documentFromFile == document) : "Documents are different. Doc: " + document + "; Doc from file: " + documentFromFile + "; File: " + psiFile + "; Virtual file: " + PsiUtilCore.getVirtualFile((PsiElement)psiFile);
        }
        final TIntObjectHashMap id2Pass = new TIntObjectHashMap();
        final TIntArrayList passesRefusedToCreate = new TIntArrayList();
        this.myRegisteredPassFactories.forEachKey(new TIntProcedure(){

            public boolean execute(int passId) {
                if (ArrayUtil.find((int[])passesToIgnore, (int)passId) != -1) {
                    return true;
                }
                PassConfig passConfig = (PassConfig)TextEditorHighlightingPassRegistrarImpl.this.myRegisteredPassFactories.get(passId);
                TextEditorHighlightingPassFactory factory = passConfig.passFactory;
                TextEditorHighlightingPass pass = factory.createHighlightingPass(psiFile, editor);
                if (pass == null) {
                    passesRefusedToCreate.add(passId);
                } else {
                    pass.setColorsScheme(editor.getColorsScheme());
                    TIntArrayList ids = new TIntArrayList(passConfig.completionPredecessorIds.length);
                    for (int id : passConfig.completionPredecessorIds) {
                        if (!TextEditorHighlightingPassRegistrarImpl.this.myRegisteredPassFactories.containsKey(id)) continue;
                        ids.add(id);
                    }
                    pass.setCompletionPredecessorIds(ids.isEmpty() ? ArrayUtil.EMPTY_INT_ARRAY : ids.toNativeArray());
                    ids = new TIntArrayList(passConfig.startingPredecessorIds.length);
                    for (int id : passConfig.startingPredecessorIds) {
                        if (!TextEditorHighlightingPassRegistrarImpl.this.myRegisteredPassFactories.containsKey(id)) continue;
                        ids.add(id);
                    }
                    pass.setStartingPredecessorIds(ids.isEmpty() ? ArrayUtil.EMPTY_INT_ARRAY : ids.toNativeArray());
                    pass.setId(passId);
                    id2Pass.put(passId, (Object)pass);
                }
                return true;
            }
        });
        DaemonCodeAnalyzerEx daemonCodeAnalyzer = DaemonCodeAnalyzerEx.getInstanceEx(this.myProject);
        final FileStatusMap statusMap = daemonCodeAnalyzer.getFileStatusMap();
        passesRefusedToCreate.forEach(new TIntProcedure(){

            public boolean execute(int passId) {
                statusMap.markFileUpToDate(document, passId);
                return true;
            }
        });
        return Arrays.asList(id2Pass.getValues());
    }

    @Override
    @NotNull
    public List<TextEditorHighlightingPass> instantiateMainPasses(final @NotNull PsiFile psiFile, final @NotNull Document document, final @NotNull HighlightInfoProcessor highlightInfoProcessor) {
        final THashSet ids = new THashSet();
        this.myRegisteredPassFactories.forEachKey(new TIntProcedure(){

            public boolean execute(int passId) {
                TextEditorHighlightingPass pass;
                PassConfig passConfig = (PassConfig)TextEditorHighlightingPassRegistrarImpl.this.myRegisteredPassFactories.get(passId);
                TextEditorHighlightingPassFactory factory = passConfig.passFactory;
                if (factory instanceof MainHighlightingPassFactory && (pass = ((MainHighlightingPassFactory)factory).createMainHighlightingPass(psiFile, document, highlightInfoProcessor)) != null) {
                    ids.add((Object)pass);
                    pass.setId(passId);
                }
                return true;
            }
        });
        return new ArrayList<TextEditorHighlightingPass>((Collection<TextEditorHighlightingPass>)ids);
    }

    private void checkForCycles() {
        final TIntObjectHashMap transitivePredecessors = new TIntObjectHashMap();
        this.myRegisteredPassFactories.forEachEntry((TIntObjectProcedure)new TIntObjectProcedure<PassConfig>(){

            public boolean execute(int passId, PassConfig config) {
                TIntHashSet allPredecessors = new TIntHashSet(config.completionPredecessorIds);
                allPredecessors.addAll(config.startingPredecessorIds);
                transitivePredecessors.put(passId, (Object)allPredecessors);
                allPredecessors.forEach(new TIntProcedure(){

                    public boolean execute(int predecessorId) {
                        PassConfig predecessor = (PassConfig)TextEditorHighlightingPassRegistrarImpl.this.myRegisteredPassFactories.get(predecessorId);
                        if (predecessor == null) {
                            return true;
                        }
                        TIntHashSet transitives = (TIntHashSet)transitivePredecessors.get(predecessorId);
                        if (transitives == null) {
                            transitives = new TIntHashSet();
                            transitivePredecessors.put(predecessorId, (Object)transitives);
                        }
                        transitives.addAll(predecessor.completionPredecessorIds);
                        transitives.addAll(predecessor.startingPredecessorIds);
                        return true;
                    }
                });
                return true;
            }
        });
        transitivePredecessors.forEachKey(new TIntProcedure(){

            public boolean execute(int passId) {
                if (((TIntHashSet)transitivePredecessors.get(passId)).contains(passId)) {
                    throw new IllegalArgumentException("There is a cycle introduced involving pass " + ((PassConfig)TextEditorHighlightingPassRegistrarImpl.this.myRegisteredPassFactories.get(passId)).passFactory);
                }
                return true;
            }
        });
    }

    @Override
    @NotNull
    public List<DirtyScopeTrackingHighlightingPassFactory> getDirtyScopeTrackingFactories() {
        return this.myDirtyScopeTrackingFactories;
    }

    private static class PassConfig {
        private final TextEditorHighlightingPassFactory passFactory;
        private final int[] startingPredecessorIds;
        private final int[] completionPredecessorIds;

        private PassConfig(@NotNull TextEditorHighlightingPassFactory passFactory, @NotNull int[] completionPredecessorIds, @NotNull int[] startingPredecessorIds) {
            this.completionPredecessorIds = completionPredecessorIds;
            this.startingPredecessorIds = startingPredecessorIds;
            this.passFactory = passFactory;
        }
    }
}

