/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.daemon.impl;

import com.intellij.codeHighlighting.BackgroundEditorHighlighter;
import com.intellij.codeHighlighting.TextEditorHighlightingPass;
import com.intellij.codeInsight.daemon.DaemonCodeAnalyzer;
import com.intellij.codeInsight.daemon.impl.TextEditorHighlightingPassRegistrarEx;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiCompiledFile;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiFile;
import com.intellij.psi.impl.PsiFileEx;
import com.intellij.util.ArrayUtil;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class TextEditorBackgroundHighlighter
implements BackgroundEditorHighlighter {
    private static final int[] EXCEPT_OVERRIDDEN = new int[]{1, 3, 4, 7, 12, 8};
    private final Editor myEditor;
    private final Document myDocument;
    private PsiFile myFile;
    private final Project myProject;
    private boolean myCompiled;

    public TextEditorBackgroundHighlighter(@NotNull Project project2, @NotNull Editor editor) {
        this.myProject = project2;
        this.myEditor = editor;
        this.myDocument = this.myEditor.getDocument();
        this.renewFile();
    }

    private void renewFile() {
        if (this.myFile == null || !this.myFile.isValid()) {
            this.myFile = PsiDocumentManager.getInstance((Project)this.myProject).getPsiFile(this.myDocument);
            this.myCompiled = this.myFile instanceof PsiCompiledFile;
            if (this.myCompiled) {
                this.myFile = ((PsiCompiledFile)this.myFile).getDecompiledPsiFile();
            }
            if (this.myFile != null && !this.myFile.isValid()) {
                this.myFile = null;
            }
        }
        if (this.myFile != null) {
            this.myFile.putUserData(PsiFileEx.BATCH_REFERENCE_PROCESSING, (Object)Boolean.TRUE);
        }
    }

    @NotNull
    List<TextEditorHighlightingPass> getPasses(@NotNull int[] passesToIgnore) {
        if (this.myProject.isDisposed()) {
            return Collections.emptyList();
        }
        PsiDocumentManager.getInstance((Project)this.myProject).commitAllDocuments();
        this.renewFile();
        if (this.myFile == null) {
            return Collections.emptyList();
        }
        if (this.myCompiled) {
            passesToIgnore = EXCEPT_OVERRIDDEN;
        } else if (!DaemonCodeAnalyzer.getInstance((Project)this.myProject).isHighlightingAvailable(this.myFile)) {
            return Collections.emptyList();
        }
        TextEditorHighlightingPassRegistrarEx passRegistrar = TextEditorHighlightingPassRegistrarEx.getInstanceEx(this.myProject);
        return passRegistrar.instantiatePasses(this.myFile, this.myEditor, passesToIgnore);
    }

    @NotNull
    public TextEditorHighlightingPass[] createPassesForVisibleArea() {
        return this.createPassesForEditor();
    }

    @NotNull
    public TextEditorHighlightingPass[] createPassesForEditor() {
        List<TextEditorHighlightingPass> passes = this.getPasses(ArrayUtil.EMPTY_INT_ARRAY);
        return passes.isEmpty() ? TextEditorHighlightingPass.EMPTY_ARRAY : passes.toArray(new TextEditorHighlightingPass[passes.size()]);
    }
}

