/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.daemon.impl;

import com.intellij.codeHighlighting.TextEditorHighlightingPass;
import com.intellij.codeInsight.daemon.LineMarkerInfo;
import com.intellij.codeInsight.daemon.LineMarkerProvider;
import com.intellij.codeInsight.daemon.impl.CollectHighlightsUtil;
import com.intellij.codeInsight.daemon.impl.DaemonCodeAnalyzerEx;
import com.intellij.codeInsight.daemon.impl.LineMarkersPass;
import com.intellij.codeInsight.daemon.impl.LineMarkersProcessor;
import com.intellij.codeInsight.daemon.impl.LineMarkersUtil;
import com.intellij.codeInsight.daemon.impl.analysis.HighlightingLevelManager;
import com.intellij.lang.Language;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Segment;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.FileViewProvider;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.util.SmartList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

class SlowLineMarkersPass
extends TextEditorHighlightingPass
implements LineMarkersProcessor,
DumbAware {
    private final PsiFile myFile;
    @NotNull
    private final Editor myEditor;
    @NotNull
    private final TextRange myBounds;
    private volatile Collection<LineMarkerInfo> myMarkers = Collections.emptyList();

    public SlowLineMarkersPass(@NotNull Project project2, @NotNull PsiFile file2, @NotNull Editor editor, @NotNull TextRange bounds) {
        super(project2, editor.getDocument(), false);
        this.myFile = file2;
        this.myEditor = editor;
        this.myBounds = bounds;
    }

    @Override
    public void doCollectInformation(@NotNull ProgressIndicator progress) {
        FileViewProvider viewProvider = this.myFile.getViewProvider();
        Set relevantLanguages = viewProvider.getLanguages();
        SmartList markers = new SmartList();
        for (Language language : relevantLanguages) {
            PsiFile psiRoot = viewProvider.getPsi(language);
            if (psiRoot == null || !HighlightingLevelManager.getInstance(this.myProject).shouldHighlight((PsiElement)psiRoot)) continue;
            List<PsiElement> elements = CollectHighlightsUtil.getElementsInRange((PsiElement)psiRoot, this.myBounds.getStartOffset(), this.myBounds.getEndOffset());
            List<LineMarkerProvider> providers = LineMarkersPass.getMarkerProviders(language, this.myProject);
            this.addLineMarkers(elements, providers, (List<LineMarkerInfo>)markers, progress);
            LineMarkersPass.collectLineMarkersForInjected((List<LineMarkerInfo>)markers, elements, this, this.myFile, progress);
        }
        this.myMarkers = LineMarkersPass.mergeLineMarkers((List<LineMarkerInfo>)markers, this.myEditor);
    }

    @Override
    public void addLineMarkers(@NotNull List<PsiElement> elements, @NotNull List<LineMarkerProvider> providers, @NotNull List<LineMarkerInfo> result, @NotNull ProgressIndicator progress) throws ProcessCanceledException {
        for (LineMarkerProvider provider : providers) {
            provider.collectSlowLineMarkers(elements, result);
        }
    }

    @Override
    public void doApplyInformationToEditor() {
        LineMarkersUtil.setLineMarkersToEditor(this.myProject, this.getDocument(), (Segment)this.myBounds, this.myMarkers, this.getId());
        DaemonCodeAnalyzerEx daemonCodeAnalyzer = DaemonCodeAnalyzerEx.getInstanceEx(this.myProject);
        daemonCodeAnalyzer.getFileStatusMap().markFileUpToDate(this.getDocument(), this.getId());
    }
}

