/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.daemon.impl;

import com.intellij.codeHighlighting.TextEditorHighlightingPass;
import com.intellij.codeInsight.CodeInsightSettings;
import com.intellij.codeInsight.daemon.DaemonBundle;
import com.intellij.codeInsight.daemon.DaemonCodeAnalyzer;
import com.intellij.codeInsight.daemon.DaemonCodeAnalyzerSettings;
import com.intellij.codeInsight.daemon.ReferenceImporter;
import com.intellij.codeInsight.daemon.impl.DaemonCodeAnalyzerEx;
import com.intellij.codeInsight.daemon.impl.HighlightInfo;
import com.intellij.codeInsight.daemon.impl.VisibleHighlightingPassFactory;
import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.codeInspection.HintAction;
import com.intellij.lang.annotation.HighlightSeverity;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.extensions.Extensions;
import com.intellij.openapi.keymap.KeymapUtil;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.ProperTextRange;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiReference;
import com.intellij.util.Processor;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class ShowAutoImportPass
extends TextEditorHighlightingPass {
    private final Editor myEditor;
    private final PsiFile myFile;
    private final int myStartOffset;
    private final int myEndOffset;

    public ShowAutoImportPass(@NotNull Project project2, @NotNull PsiFile file2, @NotNull Editor editor) {
        super(project2, editor.getDocument(), false);
        ApplicationManager.getApplication().assertIsDispatchThread();
        this.myEditor = editor;
        ProperTextRange range = VisibleHighlightingPassFactory.calculateVisibleRange(this.myEditor);
        this.myStartOffset = range.getStartOffset();
        this.myEndOffset = range.getEndOffset();
        this.myFile = file2;
    }

    @Override
    public void doCollectInformation(@NotNull ProgressIndicator progress) {
    }

    @Override
    public void doApplyInformationToEditor() {
        Application application = ApplicationManager.getApplication();
        application.assertIsDispatchThread();
        if (!application.isUnitTestMode() && !this.myEditor.getContentComponent().hasFocus()) {
            return;
        }
        int caretOffset = this.myEditor.getCaretModel().getOffset();
        this.importUnambiguousImports(caretOffset);
        List<HighlightInfo> visibleHighlights = ShowAutoImportPass.getVisibleHighlights(this.myStartOffset, this.myEndOffset, this.myProject, this.myEditor);
        for (int i = visibleHighlights.size() - 1; i >= 0; --i) {
            HighlightInfo info = visibleHighlights.get(i);
            if (info.startOffset > caretOffset || !this.showAddImportHint(info)) continue;
            return;
        }
        for (HighlightInfo visibleHighlight : visibleHighlights) {
            if (visibleHighlight.startOffset <= caretOffset || !this.showAddImportHint(visibleHighlight)) continue;
            return;
        }
    }

    private void importUnambiguousImports(final int caretOffset) {
        if (!DaemonCodeAnalyzerSettings.getInstance().isImportHintEnabled()) {
            return;
        }
        if (!DaemonCodeAnalyzer.getInstance((Project)this.myProject).isImportHintsEnabled(this.myFile)) {
            return;
        }
        CodeInsightSettings codeInsightSettings = CodeInsightSettings.getInstance();
        if (!codeInsightSettings.ADD_UNAMBIGIOUS_IMPORTS_ON_THE_FLY && !codeInsightSettings.ADD_MEMBER_IMPORTS_ON_THE_FLY) {
            return;
        }
        Document document = this.getDocument();
        final ArrayList infos = new ArrayList();
        DaemonCodeAnalyzerEx.processHighlights(document, this.myProject, null, 0, document.getTextLength(), new Processor<HighlightInfo>(){

            public boolean process(HighlightInfo info) {
                if (!info.hasHint() || info.getSeverity() != HighlightSeverity.ERROR) {
                    return true;
                }
                PsiReference reference = ShowAutoImportPass.this.myFile.findReferenceAt(info.getActualStartOffset());
                if (reference != null && reference.getElement().getTextRange().containsOffset(caretOffset)) {
                    return true;
                }
                infos.add(info);
                return true;
            }
        });
        ReferenceImporter[] importers = (ReferenceImporter[])Extensions.getExtensions(ReferenceImporter.EP_NAME);
        for (HighlightInfo info : infos) {
            for (ReferenceImporter importer : importers) {
                if (importer.autoImportReferenceAt(this.myEditor, this.myFile, info.getActualStartOffset())) break;
            }
        }
    }

    @NotNull
    private static List<HighlightInfo> getVisibleHighlights(int startOffset, int endOffset, Project project2, final Editor editor) {
        final ArrayList<HighlightInfo> highlights = new ArrayList<HighlightInfo>();
        DaemonCodeAnalyzerEx.processHighlights(editor.getDocument(), project2, null, startOffset, endOffset, new Processor<HighlightInfo>(){

            public boolean process(HighlightInfo info) {
                if (info.hasHint() && !editor.getFoldingModel().isOffsetCollapsed(info.startOffset)) {
                    highlights.add(info);
                }
                return true;
            }
        });
        return highlights;
    }

    private boolean showAddImportHint(HighlightInfo info) {
        if (!DaemonCodeAnalyzerSettings.getInstance().isImportHintEnabled()) {
            return false;
        }
        if (!DaemonCodeAnalyzer.getInstance((Project)this.myProject).isImportHintsEnabled(this.myFile)) {
            return false;
        }
        PsiElement element = this.myFile.findElementAt(info.startOffset);
        if (element == null || !element.isValid()) {
            return false;
        }
        List<Pair<HighlightInfo.IntentionActionDescriptor, TextRange>> list = info.quickFixActionRanges;
        for (Pair<HighlightInfo.IntentionActionDescriptor, TextRange> pair : list) {
            IntentionAction action = ((HighlightInfo.IntentionActionDescriptor)pair.getFirst()).getAction();
            if (!(action instanceof HintAction) || !action.isAvailable(this.myProject, this.myEditor, this.myFile)) continue;
            return ((HintAction)action).showHint(this.myEditor);
        }
        return false;
    }

    public static String getMessage(boolean multiple, String name) {
        String messageKey = multiple ? "import.popup.multiple" : "import.popup.text";
        String hintText = DaemonBundle.message((String)messageKey, (Object[])new Object[]{name});
        hintText = hintText + " " + KeymapUtil.getFirstKeyboardShortcutText((AnAction)ActionManager.getInstance().getAction("ShowIntentionActions"));
        return hintText;
    }
}

