/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.daemon.impl;

import com.intellij.codeHighlighting.HighlightDisplayLevel;
import com.intellij.codeInsight.daemon.impl.HighlightInfoType;
import com.intellij.codeInsight.daemon.impl.SeveritiesProvider;
import com.intellij.lang.annotation.HighlightSeverity;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.colors.TextAttributesKey;
import com.intellij.openapi.editor.markup.TextAttributes;
import com.intellij.openapi.extensions.Extensions;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.JDOMExternalizableStringList;
import com.intellij.profile.codeInspection.InspectionProfileManager;
import com.intellij.profile.codeInspection.InspectionProjectProfileManager;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.concurrency.AtomicFieldUpdater;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.messages.MessageBus;
import com.intellij.util.messages.Topic;
import gnu.trove.TIntFunction;
import gnu.trove.TObjectIntHashMap;
import gnu.trove.TObjectIntProcedure;
import java.awt.Color;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import javax.swing.Icon;
import org.jdom.Element;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SeverityRegistrar
implements Comparator<HighlightSeverity> {
    private static final Logger LOG = Logger.getInstance(SeverityRegistrar.class);
    @NonNls
    private static final String INFO_TAG = "info";
    @NonNls
    private static final String COLOR_ATTRIBUTE = "color";
    private final Map<String, SeverityBasedTextAttributes> myMap = ContainerUtil.newConcurrentMap();
    private final Map<String, Color> myRendererColors = ContainerUtil.newConcurrentMap();
    public static final Topic<Runnable> SEVERITIES_CHANGED_TOPIC = Topic.create((String)"SEVERITIES_CHANGED_TOPIC", Runnable.class, (Topic.BroadcastDirection)Topic.BroadcastDirection.TO_PARENT);
    @NotNull
    private final MessageBus myMessageBus;
    private volatile OrderMap myOrderMap;
    private JDOMExternalizableStringList myReadOrder;
    private static final Map<String, HighlightInfoType> STANDARD_SEVERITIES = ContainerUtil.newConcurrentMap();
    private static final AtomicFieldUpdater<SeverityRegistrar, OrderMap> ORDER_MAP_UPDATER;

    public SeverityRegistrar(@NotNull MessageBus messageBus) {
        this.myMessageBus = messageBus;
    }

    public static void registerStandard(@NotNull HighlightInfoType highlightInfoType, @NotNull HighlightSeverity highlightSeverity) {
        STANDARD_SEVERITIES.put(highlightSeverity.getName(), highlightInfoType);
    }

    @NotNull
    public static SeverityRegistrar getSeverityRegistrar(@Nullable Project project2) {
        return project2 == null ? InspectionProfileManager.getInstance().getSeverityRegistrar() : InspectionProjectProfileManager.getInstance(project2).getSeverityRegistrar();
    }

    public void registerSeverity(@NotNull SeverityBasedTextAttributes info, Color renderColor) {
        HighlightSeverity severity = info.getType().getSeverity(null);
        this.myMap.put(severity.getName(), info);
        if (renderColor != null) {
            this.myRendererColors.put(severity.getName(), renderColor);
        }
        this.myOrderMap = null;
        HighlightDisplayLevel.registerSeverity((HighlightSeverity)severity, (TextAttributesKey)this.getHighlightInfoTypeBySeverity(severity).getAttributesKey(), null);
        this.severitiesChanged();
    }

    private void severitiesChanged() {
        ((Runnable)this.myMessageBus.syncPublisher(SEVERITIES_CHANGED_TOPIC)).run();
    }

    public SeverityBasedTextAttributes unregisterSeverity(@NotNull HighlightSeverity severity) {
        return this.myMap.remove(severity.getName());
    }

    @NotNull
    public HighlightInfoType.HighlightInfoTypeImpl getHighlightInfoTypeBySeverity(@NotNull HighlightSeverity severity) {
        HighlightInfoType infoType = STANDARD_SEVERITIES.get(severity.getName());
        if (infoType != null) {
            return (HighlightInfoType.HighlightInfoTypeImpl)infoType;
        }
        if (severity == HighlightSeverity.INFORMATION) {
            return (HighlightInfoType.HighlightInfoTypeImpl)HighlightInfoType.INFORMATION;
        }
        SeverityBasedTextAttributes type = this.getAttributesBySeverity(severity);
        return (HighlightInfoType.HighlightInfoTypeImpl)(type == null ? HighlightInfoType.WARNING : type.getType());
    }

    private SeverityBasedTextAttributes getAttributesBySeverity(@NotNull HighlightSeverity severity) {
        return this.myMap.get(severity.getName());
    }

    @Nullable
    public TextAttributes getTextAttributesBySeverity(@NotNull HighlightSeverity severity) {
        SeverityBasedTextAttributes infoType = this.getAttributesBySeverity(severity);
        if (infoType != null) {
            return infoType.getAttributes();
        }
        return null;
    }

    public void readExternal(Element element) {
        this.myMap.clear();
        this.myRendererColors.clear();
        for (Element infoElement : element.getChildren(INFO_TAG)) {
            SeverityBasedTextAttributes highlightInfo = new SeverityBasedTextAttributes(infoElement);
            String colorStr = infoElement.getAttributeValue(COLOR_ATTRIBUTE);
            Color color = colorStr == null ? null : new Color(Integer.parseInt(colorStr, 16));
            this.registerSeverity(highlightInfo, color);
        }
        this.myReadOrder = new JDOMExternalizableStringList();
        this.myReadOrder.readExternal(element);
        ArrayList<HighlightSeverity> read = new ArrayList<HighlightSeverity>(this.myReadOrder.size());
        List<HighlightSeverity> knownSeverities = this.getDefaultOrder();
        for (String name : this.myReadOrder) {
            HighlightSeverity severity = this.getSeverity(name);
            if (severity == null || !knownSeverities.contains(severity)) continue;
            read.add(severity);
        }
        OrderMap orderMap = SeverityRegistrar.fromList(read);
        if (orderMap.isEmpty()) {
            orderMap = SeverityRegistrar.fromList(knownSeverities);
        } else {
            List<HighlightSeverity> list = SeverityRegistrar.getOrderAsList(orderMap);
            block2: for (int i = 0; i < knownSeverities.size(); ++i) {
                HighlightSeverity stdSeverity = knownSeverities.get(i);
                if (list.contains(stdSeverity)) continue;
                for (int oIdx = 0; oIdx < list.size(); ++oIdx) {
                    HighlightSeverity orderSeverity = list.get(oIdx);
                    HighlightInfoType type = STANDARD_SEVERITIES.get(orderSeverity.getName());
                    if (type == null || knownSeverities.indexOf(type.getSeverity(null)) <= i) continue;
                    list.add(oIdx, stdSeverity);
                    this.myReadOrder = null;
                    continue block2;
                }
            }
            orderMap = SeverityRegistrar.fromList(list);
        }
        this.myOrderMap = orderMap;
        this.severitiesChanged();
    }

    public void writeExternal(Element element) {
        List<HighlightSeverity> list = SeverityRegistrar.getOrderAsList(this.getOrderMap());
        for (HighlightSeverity severity : list) {
            Element info = new Element(INFO_TAG);
            String severityName = severity.getName();
            SeverityBasedTextAttributes infoType = this.getAttributesBySeverity(severity);
            if (infoType == null) continue;
            infoType.writeExternal(info);
            Color color = this.myRendererColors.get(severityName);
            if (color != null) {
                info.setAttribute(COLOR_ATTRIBUTE, Integer.toString(color.getRGB() & 0xFFFFFF, 16));
            }
            element.addContent(info);
        }
        if (this.myReadOrder != null && !this.myReadOrder.isEmpty()) {
            this.myReadOrder.writeExternal(element);
        } else if (!this.getDefaultOrder().equals(list)) {
            final JDOMExternalizableStringList ext = new JDOMExternalizableStringList(Collections.nCopies(this.getOrderMap().size(), ""));
            this.getOrderMap().forEachEntry((TObjectIntProcedure)new TObjectIntProcedure<HighlightSeverity>(){

                public boolean execute(HighlightSeverity orderSeverity, int oIdx) {
                    ext.set(oIdx, (Object)orderSeverity.getName());
                    return true;
                }
            });
            ext.writeExternal(element);
        }
    }

    @NotNull
    private static List<HighlightSeverity> getOrderAsList(final @NotNull OrderMap orderMap) {
        ArrayList<HighlightSeverity> list = new ArrayList<HighlightSeverity>();
        for (Object o : orderMap.keys()) {
            list.add((HighlightSeverity)o);
        }
        Collections.sort(list, new Comparator<HighlightSeverity>(){

            @Override
            public int compare(HighlightSeverity o1, HighlightSeverity o2) {
                return SeverityRegistrar.compare(o1, o2, orderMap);
            }
        });
        return list;
    }

    public int getSeveritiesCount() {
        return this.createCurrentSeverityNames().size();
    }

    public HighlightSeverity getSeverityByIndex(final int i) {
        final HighlightSeverity[] found = new HighlightSeverity[1];
        this.getOrderMap().forEachEntry((TObjectIntProcedure)new TObjectIntProcedure<HighlightSeverity>(){

            public boolean execute(HighlightSeverity severity, int order) {
                if (order == i) {
                    found[0] = severity;
                    return false;
                }
                return true;
            }
        });
        return found[0];
    }

    public int getSeverityMaxIndex() {
        int[] values = this.getOrderMap().getValues();
        int max = values[0];
        for (int i = 1; i < values.length; ++i) {
            if (values[i] <= max) continue;
            max = values[i];
        }
        return max;
    }

    @Nullable
    public HighlightSeverity getSeverity(@NotNull String name) {
        HighlightInfoType type = STANDARD_SEVERITIES.get(name);
        if (type != null) {
            return type.getSeverity(null);
        }
        SeverityBasedTextAttributes attributes = this.myMap.get(name);
        if (attributes != null) {
            return attributes.getSeverity();
        }
        return null;
    }

    @NotNull
    private List<String> createCurrentSeverityNames() {
        ArrayList<String> list = new ArrayList<String>();
        list.addAll(STANDARD_SEVERITIES.keySet());
        list.addAll(this.myMap.keySet());
        ContainerUtil.sort(list);
        return list;
    }

    public Icon getRendererIconByIndex(int i) {
        HighlightSeverity severity = this.getSeverityByIndex(i);
        HighlightDisplayLevel level = HighlightDisplayLevel.find((HighlightSeverity)severity);
        if (level != null) {
            return level.getIcon();
        }
        return HighlightDisplayLevel.createIconByMask((Color)this.myRendererColors.get(severity.getName()));
    }

    public boolean isSeverityValid(@NotNull String severityName) {
        return this.createCurrentSeverityNames().contains(severityName);
    }

    @Override
    public int compare(@NotNull HighlightSeverity s1, @NotNull HighlightSeverity s2) {
        return SeverityRegistrar.compare(s1, s2, this.getOrderMap());
    }

    private static int compare(@NotNull HighlightSeverity s1, @NotNull HighlightSeverity s2, @NotNull OrderMap orderMap) {
        int o1 = orderMap.getOrder(s1, -1);
        int o2 = orderMap.getOrder(s2, -1);
        return o1 - o2;
    }

    @NotNull
    private OrderMap getOrderMap() {
        OrderMap orderMap;
        OrderMap defaultOrder = null;
        while ((orderMap = this.myOrderMap) == null) {
            boolean replaced;
            if (defaultOrder == null) {
                defaultOrder = SeverityRegistrar.fromList(this.getDefaultOrder());
            }
            if (!(replaced = ORDER_MAP_UPDATER.compareAndSet((Object)this, null, (Object)defaultOrder))) continue;
            orderMap = defaultOrder;
            break;
        }
        return orderMap;
    }

    @NotNull
    private static OrderMap fromList(@NotNull List<HighlightSeverity> orderList) {
        if (orderList.size() != new HashSet<HighlightSeverity>(orderList).size()) {
            LOG.error("Severities order list MUST contain only unique severities: " + orderList);
        }
        TObjectIntHashMap map = new TObjectIntHashMap();
        for (int i = 0; i < orderList.size(); ++i) {
            HighlightSeverity severity = orderList.get(i);
            map.put((Object)severity, i);
        }
        return new OrderMap(map);
    }

    @NotNull
    private List<HighlightSeverity> getDefaultOrder() {
        Collection<SeverityBasedTextAttributes> values = this.myMap.values();
        ArrayList<HighlightSeverity> order = new ArrayList<HighlightSeverity>(STANDARD_SEVERITIES.size() + values.size());
        for (HighlightInfoType type : STANDARD_SEVERITIES.values()) {
            order.add(type.getSeverity(null));
        }
        for (SeverityBasedTextAttributes attributes : values) {
            order.add(attributes.getSeverity());
        }
        ContainerUtil.sort(order);
        return order;
    }

    public void setOrder(@NotNull List<HighlightSeverity> orderList) {
        this.myOrderMap = SeverityRegistrar.fromList(orderList);
        this.myReadOrder = null;
        this.severitiesChanged();
    }

    public int getSeverityIdx(@NotNull HighlightSeverity severity) {
        return this.getOrderMap().getOrder(severity, -1);
    }

    public boolean isDefaultSeverity(@NotNull HighlightSeverity severity) {
        return STANDARD_SEVERITIES.containsKey(severity.myName);
    }

    public static boolean isGotoBySeverityEnabled(@NotNull HighlightSeverity minSeverity) {
        for (SeveritiesProvider provider : (SeveritiesProvider[])Extensions.getExtensions(SeveritiesProvider.EP_NAME)) {
            if (!provider.isGotoBySeverityEnabled(minSeverity)) continue;
            return true;
        }
        return minSeverity != HighlightSeverity.INFORMATION;
    }

    @NotNull
    Collection<SeverityBasedTextAttributes> allRegisteredAttributes() {
        return new ArrayList<SeverityBasedTextAttributes>(this.myMap.values());
    }

    @NotNull
    Collection<HighlightInfoType> standardSeverities() {
        return STANDARD_SEVERITIES.values();
    }

    static {
        SeverityRegistrar.registerStandard(HighlightInfoType.ERROR, HighlightSeverity.ERROR);
        SeverityRegistrar.registerStandard(HighlightInfoType.WARNING, HighlightSeverity.WARNING);
        SeverityRegistrar.registerStandard(HighlightInfoType.INFO, HighlightSeverity.INFO);
        SeverityRegistrar.registerStandard(HighlightInfoType.WEAK_WARNING, HighlightSeverity.WEAK_WARNING);
        SeverityRegistrar.registerStandard(HighlightInfoType.GENERIC_WARNINGS_OR_ERRORS_FROM_SERVER, HighlightSeverity.GENERIC_SERVER_ERROR_OR_WARNING);
        ORDER_MAP_UPDATER = AtomicFieldUpdater.forFieldOfType(SeverityRegistrar.class, OrderMap.class);
    }

    public static class SeverityBasedTextAttributes {
        private final TextAttributes myAttributes;
        private final HighlightInfoType.HighlightInfoTypeImpl myType;

        public SeverityBasedTextAttributes(@NotNull Element element) {
            this(new TextAttributes(element), new HighlightInfoType.HighlightInfoTypeImpl(element));
        }

        public SeverityBasedTextAttributes(@NotNull TextAttributes attributes, @NotNull HighlightInfoType.HighlightInfoTypeImpl type) {
            this.myAttributes = attributes;
            this.myType = type;
        }

        @NotNull
        public TextAttributes getAttributes() {
            return this.myAttributes;
        }

        @NotNull
        public HighlightInfoType.HighlightInfoTypeImpl getType() {
            return this.myType;
        }

        private void writeExternal(@NotNull Element element) {
            this.myAttributes.writeExternal(element);
            this.myType.writeExternal(element);
        }

        @NotNull
        public HighlightSeverity getSeverity() {
            return this.myType.getSeverity(null);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            SeverityBasedTextAttributes that = (SeverityBasedTextAttributes)o;
            if (!this.myAttributes.equals((Object)that.myAttributes)) {
                return false;
            }
            return this.myType.equals(that.myType);
        }

        public int hashCode() {
            int result = this.myAttributes.hashCode();
            result = 31 * result + this.myType.hashCode();
            return result;
        }
    }

    private static class OrderMap
    extends TObjectIntHashMap<HighlightSeverity> {
        private OrderMap(@NotNull TObjectIntHashMap<HighlightSeverity> map) {
            super(map.size());
            map.forEachEntry((TObjectIntProcedure)new TObjectIntProcedure<HighlightSeverity>(){

                public boolean execute(HighlightSeverity key, int value) {
                    OrderMap.super.put(key, value);
                    return true;
                }
            });
            this.trimToSize();
        }

        private int getOrder(@NotNull HighlightSeverity severity, int defaultOrder) {
            int index = this.index(severity);
            return index < 0 ? defaultOrder : this._values[index];
        }

        public void clear() {
            throw new IncorrectOperationException("readonly");
        }

        protected void removeAt(int index) {
            throw new IncorrectOperationException("readonly");
        }

        public void transformValues(TIntFunction function) {
            throw new IncorrectOperationException("readonly");
        }

        public boolean adjustValue(HighlightSeverity key, int amount) {
            throw new IncorrectOperationException("readonly");
        }

        public int put(HighlightSeverity key, int value) {
            throw new IncorrectOperationException("readonly");
        }

        public int remove(HighlightSeverity key) {
            throw new IncorrectOperationException("readonly");
        }
    }
}

