/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.daemon.impl;

import com.intellij.codeInsight.daemon.LineMarkerInfo;
import com.intellij.codeInsight.daemon.LineMarkerProviderDescriptor;
import com.intellij.icons.AllIcons;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.editor.markup.GutterIconRenderer;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.util.Comparing;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiLambdaExpression;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiStatement;
import com.intellij.psi.PsiThisExpression;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.FunctionUtil;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class RecursiveCallLineMarkerProvider
extends LineMarkerProviderDescriptor {
    public LineMarkerInfo getLineMarkerInfo(@NotNull PsiElement element) {
        return null;
    }

    public void collectSlowLineMarkers(@NotNull List<PsiElement> elements, @NotNull Collection<LineMarkerInfo> result) {
        HashSet<PsiStatement> statements = new HashSet<PsiStatement>();
        for (PsiElement element : elements) {
            PsiMethodCallExpression methodCall;
            PsiStatement statement2;
            ProgressManager.checkCanceled();
            if (!(element instanceof PsiMethodCallExpression) || statements.contains(statement2 = (PsiStatement)PsiTreeUtil.getParentOfType((PsiElement)(methodCall = (PsiMethodCallExpression)element), PsiStatement.class, (boolean)true, (Class[])new Class[]{PsiMethod.class})) || !RecursiveCallLineMarkerProvider.isRecursiveMethodCall(methodCall)) continue;
            statements.add(statement2);
            result.add(new RecursiveMethodCallMarkerInfo(methodCall));
        }
    }

    public static boolean isRecursiveMethodCall(@NotNull PsiMethodCallExpression methodCall) {
        PsiExpression qualifier = methodCall.getMethodExpression().getQualifierExpression();
        if (qualifier != null && !(qualifier instanceof PsiThisExpression)) {
            return false;
        }
        PsiMethod method = (PsiMethod)PsiTreeUtil.getParentOfType((PsiElement)methodCall, PsiMethod.class, (boolean)true, (Class[])new Class[]{PsiLambdaExpression.class, PsiClass.class});
        if (method == null || !method.getName().equals(methodCall.getMethodExpression().getReferenceName())) {
            return false;
        }
        return Comparing.equal((Object)method, (Object)methodCall.resolveMethod());
    }

    @NotNull
    public String getName() {
        return "Recursive call";
    }

    @Nullable
    public Icon getIcon() {
        return AllIcons.Gutter.RecursiveMethod;
    }

    private static class RecursiveMethodCallMarkerInfo
    extends LineMarkerInfo<PsiMethodCallExpression> {
        private RecursiveMethodCallMarkerInfo(@NotNull PsiMethodCallExpression methodCall) {
            super((PsiElement)methodCall, methodCall.getTextRange(), AllIcons.Gutter.RecursiveMethod, 6, FunctionUtil.constant((Object)"Recursive call"), null, GutterIconRenderer.Alignment.RIGHT);
        }

        public GutterIconRenderer createGutterRenderer() {
            if (this.myIcon == null) {
                return null;
            }
            return new LineMarkerInfo.LineMarkerGutterIconRenderer<PsiMethodCallExpression>((LineMarkerInfo)this){

                public AnAction getClickAction() {
                    return null;
                }
            };
        }
    }
}

