/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.daemon.impl;

import com.intellij.codeHighlighting.TextEditorHighlightingPass;
import com.intellij.codeHighlighting.TextEditorHighlightingPassFactory;
import com.intellij.codeHighlighting.TextEditorHighlightingPassRegistrar;
import com.intellij.codeInsight.daemon.impl.FileStatusMap;
import com.intellij.codeInsight.daemon.impl.LineMarkersPass;
import com.intellij.codeInsight.daemon.impl.ProgressableTextEditorHighlightingPass;
import com.intellij.openapi.components.AbstractProjectComponent;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiFile;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class LineMarkersPassFactory
extends AbstractProjectComponent
implements TextEditorHighlightingPassFactory {
    public LineMarkersPassFactory(Project project2, TextEditorHighlightingPassRegistrar highlightingPassRegistrar) {
        super(project2);
        highlightingPassRegistrar.registerTextEditorHighlightingPass((TextEditorHighlightingPassFactory)this, new int[]{10}, new int[]{4}, false, 11);
    }

    @NonNls
    @NotNull
    public String getComponentName() {
        return "LineMarkersPassFactory";
    }

    @Override
    @Nullable
    public TextEditorHighlightingPass createHighlightingPass(@NotNull PsiFile file2, @NotNull Editor editor) {
        TextRange textRange = LineMarkersPassFactory.calculateRangeToProcessForSyntaxPass(editor);
        if (textRange == null) {
            return new ProgressableTextEditorHighlightingPass.EmptyPass(this.myProject, editor.getDocument());
        }
        return new LineMarkersPass(this.myProject, file2, editor, editor.getDocument(), textRange);
    }

    @Nullable
    private static TextRange calculateRangeToProcessForSyntaxPass(Editor editor) {
        return FileStatusMap.getDirtyTextRange(editor, 4);
    }
}

