/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.daemon.impl;

import com.intellij.openapi.editor.ElementColorProvider;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionList;
import com.intellij.psi.PsiNewExpression;
import com.intellij.psi.PsiType;
import com.intellij.psi.impl.JavaConstantExpressionEvaluator;
import com.intellij.psi.util.PsiTypesUtil;
import com.intellij.ui.ColorUtil;
import java.awt.Color;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JavaColorProvider
implements ElementColorProvider {
    public Color getColorFrom(@NotNull PsiElement element) {
        return JavaColorProvider.getJavaColorFromExpression(element);
    }

    public static boolean isColorType(@Nullable PsiType type) {
        String fqn;
        PsiClass aClass;
        return type != null && (aClass = PsiTypesUtil.getPsiClass((PsiType)type)) != null && ("java.awt.Color".equals(fqn = aClass.getQualifiedName()) || "javax.swing.plaf.ColorUIResource".equals(fqn));
    }

    @Nullable
    public static Color getJavaColorFromExpression(@Nullable PsiElement element) {
        PsiNewExpression expr;
        if (element instanceof PsiNewExpression && JavaColorProvider.isColorType((expr = (PsiNewExpression)element).getType())) {
            return JavaColorProvider.getColor(expr.getArgumentList());
        }
        return null;
    }

    @Nullable
    private static Color getColor(PsiExpressionList list) {
        try {
            PsiExpression[] args = list.getExpressions();
            PsiType[] types = list.getExpressionTypes();
            ColorConstructors type = JavaColorProvider.getConstructorType(types);
            if (type != null) {
                switch (type) {
                    case INT: {
                        return new Color(JavaColorProvider.getInt(args[0]));
                    }
                    case INT_BOOL: {
                        return new Color(JavaColorProvider.getInt(args[0]), JavaColorProvider.getBoolean(args[1]));
                    }
                    case INT_x3: {
                        return new Color(JavaColorProvider.getInt(args[0]), JavaColorProvider.getInt(args[1]), JavaColorProvider.getInt(args[2]));
                    }
                    case INT_x4: {
                        return new Color(JavaColorProvider.getInt(args[0]), JavaColorProvider.getInt(args[1]), JavaColorProvider.getInt(args[2]), JavaColorProvider.getInt(args[3]));
                    }
                    case FLOAT_x3: {
                        return new Color(JavaColorProvider.getFloat(args[0]), JavaColorProvider.getFloat(args[1]), JavaColorProvider.getFloat(args[2]));
                    }
                    case FLOAT_x4: {
                        return new Color(JavaColorProvider.getFloat(args[0]), JavaColorProvider.getFloat(args[1]), JavaColorProvider.getFloat(args[2]), JavaColorProvider.getFloat(args[3]));
                    }
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }

    @Nullable
    private static ColorConstructors getConstructorType(PsiType[] types) {
        int len = types.length;
        if (len == 0) {
            return null;
        }
        switch (len) {
            case 1: {
                return ColorConstructors.INT;
            }
            case 2: {
                return ColorConstructors.INT_BOOL;
            }
            case 3: {
                return PsiType.INT.equals((Object)types[0]) ? ColorConstructors.INT_x3 : ColorConstructors.FLOAT_x3;
            }
            case 4: {
                return PsiType.INT.equals((Object)types[0]) ? ColorConstructors.INT_x4 : ColorConstructors.FLOAT_x4;
            }
        }
        return null;
    }

    public static int getInt(PsiExpression expr) {
        return (Integer)JavaColorProvider.getObject(expr);
    }

    public static float getFloat(PsiExpression expr) {
        return ((Float)JavaColorProvider.getObject(expr)).floatValue();
    }

    public static boolean getBoolean(PsiExpression expr) {
        return (Boolean)JavaColorProvider.getObject(expr);
    }

    private static Object getObject(PsiExpression expr) {
        return JavaConstantExpressionEvaluator.computeConstantExpression(expr, true);
    }

    public void setColorTo(@NotNull PsiElement element, @NotNull Color color) {
        PsiExpressionList argumentList = ((PsiNewExpression)element).getArgumentList();
        assert (argumentList != null);
        PsiExpression[] expr = argumentList.getExpressions();
        ColorConstructors type = JavaColorProvider.getConstructorType(argumentList.getExpressionTypes());
        assert (type != null);
        switch (type) {
            case INT: 
            case INT_BOOL: {
                JavaColorProvider.replaceInt(expr[0], color.getRGB(), true);
                return;
            }
            case INT_x3: 
            case INT_x4: {
                JavaColorProvider.replaceInt(expr[0], color.getRed());
                JavaColorProvider.replaceInt(expr[1], color.getGreen());
                JavaColorProvider.replaceInt(expr[2], color.getBlue());
                if (type == ColorConstructors.INT_x4) {
                    JavaColorProvider.replaceInt(expr[3], color.getAlpha());
                } else if (color.getAlpha() != 255) {
                    // empty if block
                }
                return;
            }
            case FLOAT_x3: 
            case FLOAT_x4: {
                float[] rgba = color.getColorComponents(null);
                JavaColorProvider.replaceFloat(expr[0], rgba[0]);
                JavaColorProvider.replaceFloat(expr[1], rgba[1]);
                JavaColorProvider.replaceFloat(expr[2], rgba[2]);
                if (type == ColorConstructors.FLOAT_x4) {
                    JavaColorProvider.replaceFloat(expr[3], rgba.length == 4 ? rgba[3] : 0.0f);
                    break;
                }
                if (color.getAlpha() == 255) break;
            }
        }
    }

    private static void replaceInt(PsiExpression expr, int newValue) {
        JavaColorProvider.replaceInt(expr, newValue, false);
    }

    private static void replaceInt(PsiExpression expr, int newValue, boolean hex) {
        PsiElementFactory factory = JavaPsiFacade.getElementFactory((Project)expr.getProject());
        if (JavaColorProvider.getInt(expr) != newValue) {
            String text = hex ? "0x" + ColorUtil.toHex((Color)new Color(newValue)).toUpperCase() : Integer.toString(newValue);
            expr.replace((PsiElement)factory.createExpressionFromText(text, null));
        }
    }

    private static void replaceFloat(PsiExpression expr, float newValue) {
        PsiElementFactory factory = JavaPsiFacade.getElementFactory((Project)expr.getProject());
        if (JavaColorProvider.getFloat(expr) != newValue) {
            expr.replace((PsiElement)factory.createExpressionFromText(String.valueOf(newValue) + "f", null));
        }
    }

    private static enum ColorConstructors {
        INT,
        INT_BOOL,
        INT_x3,
        INT_x4,
        FLOAT_x3,
        FLOAT_x4;

    }
}

