/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.daemon.impl;

import com.intellij.codeHighlighting.TextEditorHighlightingPass;
import com.intellij.codeInsight.highlighting.BraceMatchingUtil;
import com.intellij.lang.Language;
import com.intellij.lang.LanguageParserDefinitions;
import com.intellij.lang.ParserDefinition;
import com.intellij.openapi.editor.CaretModel;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.FoldRegion;
import com.intellij.openapi.editor.FoldingModel;
import com.intellij.openapi.editor.IndentGuideDescriptor;
import com.intellij.openapi.editor.SoftWrap;
import com.intellij.openapi.editor.SoftWrapModel;
import com.intellij.openapi.editor.VisualPosition;
import com.intellij.openapi.editor.colors.EditorColors;
import com.intellij.openapi.editor.colors.EditorColorsScheme;
import com.intellij.openapi.editor.ex.EditorEx;
import com.intellij.openapi.editor.ex.MarkupModelEx;
import com.intellij.openapi.editor.ex.util.EditorUtil;
import com.intellij.openapi.editor.highlighter.HighlighterIterator;
import com.intellij.openapi.editor.markup.CustomHighlighterRenderer;
import com.intellij.openapi.editor.markup.HighlighterTargetArea;
import com.intellij.openapi.editor.markup.MarkupModel;
import com.intellij.openapi.editor.markup.RangeHighlighter;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiFile;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.TokenSet;
import com.intellij.util.DocumentUtil;
import com.intellij.util.containers.ContainerUtilRt;
import com.intellij.util.containers.IntStack;
import com.intellij.util.text.CharArrayUtil;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;

public class IndentsPass
extends TextEditorHighlightingPass
implements DumbAware {
    private static final Key<List<RangeHighlighter>> INDENT_HIGHLIGHTERS_IN_EDITOR_KEY = Key.create((String)"INDENT_HIGHLIGHTERS_IN_EDITOR_KEY");
    private static final Key<Long> LAST_TIME_INDENTS_BUILT = Key.create((String)"LAST_TIME_INDENTS_BUILT");
    private final EditorEx myEditor;
    private final PsiFile myFile;
    public static final Comparator<TextRange> RANGE_COMPARATOR = new Comparator<TextRange>(){

        @Override
        public int compare(TextRange o1, TextRange o2) {
            if (o1.getStartOffset() == o2.getStartOffset()) {
                return o1.getEndOffset() - o2.getEndOffset();
            }
            return o1.getStartOffset() - o2.getStartOffset();
        }
    };
    private static final CustomHighlighterRenderer RENDERER = new CustomHighlighterRenderer(){

        public void paint(@NotNull Editor editor, @NotNull RangeHighlighter highlighter, @NotNull Graphics g) {
            Rectangle clip;
            CaretModel caretModel;
            int caretOffset;
            int off;
            Document doc;
            int startOffset = highlighter.getStartOffset();
            if (startOffset >= (doc = highlighter.getDocument()).getTextLength()) {
                return;
            }
            int endOffset = highlighter.getEndOffset();
            int endLine = doc.getLineNumber(endOffset);
            int startLine = doc.getLineNumber(startOffset);
            IndentGuideDescriptor descriptor = editor.getIndentsModel().getDescriptor(startLine, endLine);
            CharSequence chars = doc.getCharsSequence();
            do {
                int start = doc.getLineStartOffset(startLine);
                int end = doc.getLineEndOffset(startLine);
                off = CharArrayUtil.shiftForward((CharSequence)chars, (int)start, (int)end, (String)" \t");
            } while (--startLine > 1 && off < doc.getTextLength() && chars.charAt(off) == '\n');
            VisualPosition startPosition = editor.offsetToVisualPosition(off);
            int indentColumn = startPosition.column;
            int lineShift = 1;
            if (indentColumn <= 0 && descriptor != null) {
                indentColumn = descriptor.indentLevel;
                lineShift = 0;
            }
            if (indentColumn <= 0) {
                return;
            }
            FoldingModel foldingModel = editor.getFoldingModel();
            if (foldingModel.isOffsetCollapsed(off)) {
                return;
            }
            FoldRegion headerRegion = foldingModel.getCollapsedRegionAtOffset(doc.getLineEndOffset(doc.getLineNumber(off)));
            FoldRegion tailRegion = foldingModel.getCollapsedRegionAtOffset(doc.getLineStartOffset(doc.getLineNumber(endOffset)));
            if (tailRegion != null && tailRegion == headerRegion) {
                return;
            }
            IndentGuideDescriptor guide = editor.getIndentsModel().getCaretIndentGuide();
            boolean selected = guide != null ? (caretOffset = (caretModel = editor.getCaretModel()).getOffset()) >= off && caretOffset < endOffset && caretModel.getLogicalPosition().column == indentColumn : false;
            Point start = editor.visualPositionToXY(new VisualPosition(startPosition.line + lineShift, indentColumn));
            VisualPosition endPosition = editor.offsetToVisualPosition(endOffset);
            Point end = editor.visualPositionToXY(new VisualPosition(endPosition.line, endPosition.column));
            int maxY = end.y;
            if (endPosition.line == editor.offsetToVisualPosition((int)doc.getTextLength()).line) {
                maxY += editor.getLineHeight();
            }
            if ((clip = g.getClipBounds()) != null) {
                if (clip.y >= maxY || clip.y + clip.height <= start.y) {
                    return;
                }
                maxY = Math.min(maxY, clip.y + clip.height);
            }
            EditorColorsScheme scheme = editor.getColorsScheme();
            g.setColor(selected ? scheme.getColor(EditorColors.SELECTED_INDENT_GUIDE_COLOR) : scheme.getColor(EditorColors.INDENT_GUIDE_COLOR));
            if (selected) {
                g.drawLine(start.x + 2, start.y, start.x + 2, maxY - 1);
            } else {
                int y = start.y;
                int newY = start.y;
                SoftWrapModel softWrapModel = editor.getSoftWrapModel();
                int lineHeight = editor.getLineHeight();
                for (int i = Math.max(0, startLine + lineShift); i < endLine && newY < maxY; ++i) {
                    List softWraps = softWrapModel.getSoftWrapsForLine(i);
                    int logicalLineHeight = softWraps.size() * lineHeight;
                    if (i > startLine + lineShift) {
                        logicalLineHeight += lineHeight;
                    }
                    if (!softWraps.isEmpty() && ((SoftWrap)softWraps.get(0)).getIndentInColumns() < indentColumn) {
                        if (y < newY || i > startLine + lineShift) {
                            g.drawLine(start.x + 2, y, start.x + 2, newY + lineHeight - 1);
                        }
                        y = newY += logicalLineHeight;
                    } else {
                        newY += logicalLineHeight;
                    }
                    FoldRegion foldRegion = foldingModel.getCollapsedRegionAtOffset(doc.getLineEndOffset(i));
                    if (foldRegion == null || foldRegion.getEndOffset() >= doc.getTextLength()) continue;
                    i = doc.getLineNumber(foldRegion.getEndOffset());
                }
                if (y < maxY) {
                    g.drawLine(start.x + 2, y, start.x + 2, maxY - 1);
                }
            }
        }
    };
    private volatile List<TextRange> myRanges;
    private volatile List<IndentGuideDescriptor> myDescriptors;

    public IndentsPass(@NotNull Project project2, @NotNull Editor editor, @NotNull PsiFile file2) {
        super(project2, editor.getDocument(), false);
        this.myEditor = (EditorEx)editor;
        this.myFile = file2;
    }

    @Override
    public void doCollectInformation(@NotNull ProgressIndicator progress) {
        assert (this.myDocument != null);
        Long stamp = (Long)this.myEditor.getUserData(LAST_TIME_INDENTS_BUILT);
        if (stamp != null && stamp.longValue() == this.nowStamp()) {
            return;
        }
        this.myDescriptors = this.buildDescriptors();
        ArrayList<TextRange> ranges = new ArrayList<TextRange>();
        for (IndentGuideDescriptor descriptor : this.myDescriptors) {
            ProgressManager.checkCanceled();
            int endOffset = descriptor.endLine < this.myDocument.getLineCount() ? this.myDocument.getLineStartOffset(descriptor.endLine) : this.myDocument.getTextLength();
            ranges.add(new TextRange(this.myDocument.getLineStartOffset(descriptor.startLine), endOffset));
        }
        Collections.sort(ranges, RANGE_COMPARATOR);
        this.myRanges = ranges;
    }

    private long nowStamp() {
        if (!this.myEditor.getSettings().isIndentGuidesShown()) {
            return -1L;
        }
        assert (this.myDocument != null);
        return this.myDocument.getModificationStamp();
    }

    @Override
    public void doApplyInformationToEditor() {
        Long stamp = (Long)this.myEditor.getUserData(LAST_TIME_INDENTS_BUILT);
        if (stamp != null && stamp.longValue() == this.nowStamp()) {
            return;
        }
        List oldHighlighters = (List)this.myEditor.getUserData(INDENT_HIGHLIGHTERS_IN_EDITOR_KEY);
        final ArrayList<RangeHighlighter> newHighlighters = new ArrayList<RangeHighlighter>();
        final MarkupModelEx mm = this.myEditor.getMarkupModel();
        int curRange = 0;
        if (oldHighlighters != null) {
            int curHighlight = 0;
            while (curRange < this.myRanges.size() && curHighlight < oldHighlighters.size()) {
                RangeHighlighter highlighter;
                TextRange range = this.myRanges.get(curRange);
                int cmp = IndentsPass.compare(range, highlighter = (RangeHighlighter)oldHighlighters.get(curHighlight));
                if (cmp < 0) {
                    newHighlighters.add(IndentsPass.createHighlighter(mm, range));
                    ++curRange;
                    continue;
                }
                if (cmp > 0) {
                    highlighter.dispose();
                    ++curHighlight;
                    continue;
                }
                newHighlighters.add(highlighter);
                ++curHighlight;
                ++curRange;
            }
            while (curHighlight < oldHighlighters.size()) {
                RangeHighlighter highlighter = (RangeHighlighter)oldHighlighters.get(curHighlight);
                highlighter.dispose();
                ++curHighlight;
            }
        }
        final int startRangeIndex = curRange;
        assert (this.myDocument != null);
        DocumentUtil.executeInBulk(this.myDocument, this.myRanges.size() > 10000, new Runnable(){

            @Override
            public void run() {
                for (int i = startRangeIndex; i < IndentsPass.this.myRanges.size(); ++i) {
                    newHighlighters.add(IndentsPass.createHighlighter(mm, (TextRange)IndentsPass.this.myRanges.get(i)));
                }
            }
        });
        this.myEditor.putUserData(INDENT_HIGHLIGHTERS_IN_EDITOR_KEY, newHighlighters);
        this.myEditor.putUserData(LAST_TIME_INDENTS_BUILT, this.nowStamp());
        this.myEditor.getIndentsModel().assumeIndents(this.myDescriptors);
    }

    private List<IndentGuideDescriptor> buildDescriptors() {
        if (!this.myEditor.getSettings().isIndentGuidesShown()) {
            return Collections.emptyList();
        }
        IndentsCalculator calculator = new IndentsCalculator();
        calculator.calculate();
        int[] lineIndents = calculator.lineIndents;
        ArrayList<IndentGuideDescriptor> descriptors = new ArrayList<IndentGuideDescriptor>();
        IntStack lines = new IntStack();
        IntStack indents = new IntStack();
        lines.push(0);
        indents.push(0);
        assert (this.myDocument != null);
        for (int line = 1; line < lineIndents.length; ++line) {
            ProgressManager.checkCanceled();
            int curIndent = Math.abs(lineIndents[line]);
            block1: while (!indents.empty() && curIndent <= indents.peek()) {
                ProgressManager.checkCanceled();
                int level = indents.pop();
                int startLine = lines.pop();
                if (level <= 0) continue;
                for (int i = startLine; i < line; ++i) {
                    if (level == Math.abs(lineIndents[i])) continue;
                    descriptors.add(IndentsPass.createDescriptor(level, startLine, line, lineIndents));
                    continue block1;
                }
            }
            int prevLine = line - 1;
            int prevIndent = Math.abs(lineIndents[prevLine]);
            if (curIndent - prevIndent <= 1) continue;
            lines.push(prevLine);
            indents.push(prevIndent);
        }
        while (!indents.empty()) {
            ProgressManager.checkCanceled();
            int level = indents.pop();
            int startLine = lines.pop();
            if (level <= 0) continue;
            descriptors.add(IndentsPass.createDescriptor(level, startLine, this.myDocument.getLineCount(), lineIndents));
        }
        return descriptors;
    }

    private static IndentGuideDescriptor createDescriptor(int level, int startLine, int endLine, int[] lineIndents) {
        while (startLine > 0 && lineIndents[startLine] < 0) {
            --startLine;
        }
        return new IndentGuideDescriptor(level, startLine, endLine);
    }

    @NotNull
    private static RangeHighlighter createHighlighter(MarkupModel mm, TextRange range) {
        RangeHighlighter highlighter = mm.addRangeHighlighter(range.getStartOffset(), range.getEndOffset(), 0, null, HighlighterTargetArea.EXACT_RANGE);
        highlighter.setCustomRenderer(RENDERER);
        return highlighter;
    }

    private static int compare(@NotNull TextRange r, @NotNull RangeHighlighter h) {
        int answer = r.getStartOffset() - h.getStartOffset();
        return answer != 0 ? answer : r.getEndOffset() - h.getEndOffset();
    }

    private class IndentsCalculator {
        @NotNull
        public final Map<Language, TokenSet> myComments = ContainerUtilRt.newHashMap();
        @NotNull
        public final int[] lineIndents;
        @NotNull
        public final CharSequence myChars;

        IndentsCalculator() {
            assert (IndentsPass.this.myDocument != null);
            this.lineIndents = new int[IndentsPass.this.myDocument.getLineCount()];
            this.myChars = IndentsPass.this.myDocument.getCharsSequence();
        }

        void calculate() {
            assert (IndentsPass.this.myDocument != null);
            FileType fileType = IndentsPass.this.myFile.getFileType();
            int tabSize = EditorUtil.getTabSize(IndentsPass.this.myEditor);
            for (int line = 0; line < this.lineIndents.length; ++line) {
                int offset;
                ProgressManager.checkCanceled();
                int lineStart = IndentsPass.this.myDocument.getLineStartOffset(line);
                int lineEnd = IndentsPass.this.myDocument.getLineEndOffset(line);
                int column = 0;
                block5: for (offset = lineStart; offset < lineEnd; ++offset) {
                    switch (this.myChars.charAt(offset)) {
                        case ' ': {
                            ++column;
                            continue block5;
                        }
                        case '\t': {
                            column = (column / tabSize + 1) * tabSize;
                            continue block5;
                        }
                    }
                }
                this.lineIndents[line] = offset == lineEnd || this.isComment(offset) ? -1 : column;
            }
            int topIndent = 0;
            for (int line = 0; line < this.lineIndents.length; ++line) {
                ProgressManager.checkCanceled();
                if (this.lineIndents[line] >= 0) {
                    topIndent = this.lineIndents[line];
                    continue;
                }
                int startLine = line;
                while (line < this.lineIndents.length && this.lineIndents[line] < 0) {
                    ++line;
                }
                int bottomIndent = line < this.lineIndents.length ? this.lineIndents[line] : topIndent;
                int indent = Math.min(topIndent, bottomIndent);
                if (bottomIndent < topIndent) {
                    int lineStart = IndentsPass.this.myDocument.getLineStartOffset(line);
                    int lineEnd = IndentsPass.this.myDocument.getLineEndOffset(line);
                    int nonWhitespaceOffset = CharArrayUtil.shiftForward((CharSequence)this.myChars, (int)lineStart, (int)lineEnd, (String)" \t");
                    HighlighterIterator iterator = IndentsPass.this.myEditor.getHighlighter().createIterator(nonWhitespaceOffset);
                    if (BraceMatchingUtil.isRBraceToken(iterator, this.myChars, fileType)) {
                        indent = topIndent;
                    }
                }
                for (int blankLine = startLine; blankLine < line; ++blankLine) {
                    assert (this.lineIndents[blankLine] == -1);
                    this.lineIndents[blankLine] = -Math.min(topIndent, indent);
                }
                --line;
            }
        }

        private boolean isComment(int offset) {
            HighlighterIterator it = IndentsPass.this.myEditor.getHighlighter().createIterator(offset);
            IElementType tokenType = it.getTokenType();
            Language language = tokenType.getLanguage();
            TokenSet comments = this.myComments.get(language);
            if (comments == null) {
                ParserDefinition definition = (ParserDefinition)LanguageParserDefinitions.INSTANCE.forLanguage(language);
                if (definition != null) {
                    comments = definition.getCommentTokens();
                }
                if (comments == null) {
                    return false;
                }
                this.myComments.put(language, comments);
            }
            return comments.contains(tokenType);
        }
    }
}

