/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.daemon.impl;

import com.intellij.codeInsight.daemon.impl.DaemonProgressIndicator;
import com.intellij.codeInsight.daemon.impl.HighlightInfo;
import com.intellij.codeInsight.daemon.impl.HighlightingSession;
import com.intellij.codeInsight.daemon.impl.UpdateHighlightersUtil;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.RangeMarker;
import com.intellij.openapi.editor.colors.EditorColorsScheme;
import com.intellij.openapi.editor.ex.RangeHighlighterEx;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiFile;
import com.intellij.util.ConcurrencyUtil;
import com.intellij.util.Processor;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.TransferToEDTQueue;
import gnu.trove.THashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentMap;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class HighlightingSessionImpl
implements HighlightingSession {
    @NotNull
    private final PsiFile myPsiFile;
    @Nullable
    private final Editor myEditor;
    @NotNull
    private final ProgressIndicator myProgressIndicator;
    private final EditorColorsScheme myEditorColorsScheme;
    @NotNull
    private final Project myProject;
    private final Document myDocument;
    private final Map<TextRange, RangeMarker> myRanges2markersCache = new THashMap();
    private static final Key<ConcurrentMap<PsiFile, HighlightingSession>> HIGHLIGHTING_SESSION = Key.create((String)"HIGHLIGHTING_SESSION");
    private final TransferToEDTQueue<Info> myAddHighlighterInEDTQueue = new TransferToEDTQueue("Apply highlighting results", (Processor)new Processor<Info>(){

        public boolean process(Info info) {
            EditorColorsScheme colorsScheme = HighlightingSessionImpl.this.getColorsScheme();
            UpdateHighlightersUtil.addHighlighterToEditorIncrementally(HighlightingSessionImpl.this.myProject, HighlightingSessionImpl.this.getDocument(), HighlightingSessionImpl.this.getPsiFile(), info.myRestrictRange.getStartOffset(), info.myRestrictRange.getEndOffset(), info.myInfo, colorsScheme, info.myGroupId, HighlightingSessionImpl.this.myRanges2markersCache);
            return true;
        }
    }, (Condition)new Condition<Object>(){

        public boolean value(Object o) {
            return HighlightingSessionImpl.this.myProject.isDisposed() || HighlightingSessionImpl.this.getProgressIndicator().isCanceled();
        }
    }, 200);
    private final TransferToEDTQueue<RangeHighlighterEx> myDisposeHighlighterInEDTQueue = new TransferToEDTQueue("Dispose abandoned highlighter", (Processor)new Processor<RangeHighlighterEx>(){

        public boolean process(@NotNull RangeHighlighterEx highlighter) {
            highlighter.dispose();
            return true;
        }
    }, (Condition)new Condition<Object>(){

        public boolean value(Object o) {
            return HighlightingSessionImpl.this.myProject.isDisposed() || HighlightingSessionImpl.this.getProgressIndicator().isCanceled();
        }
    }, 200);

    private HighlightingSessionImpl(@NotNull PsiFile psiFile, @Nullable Editor editor, @NotNull DaemonProgressIndicator progressIndicator, EditorColorsScheme editorColorsScheme) {
        this.myPsiFile = psiFile;
        this.myEditor = editor;
        this.myProgressIndicator = progressIndicator;
        this.myEditorColorsScheme = editorColorsScheme;
        this.myProject = psiFile.getProject();
        this.myDocument = PsiDocumentManager.getInstance((Project)this.myProject).getDocument(psiFile);
    }

    public static HighlightingSession getHighlightingSession(@NotNull PsiFile psiFile, @NotNull ProgressIndicator progressIndicator) {
        Map map = (Map)((DaemonProgressIndicator)progressIndicator).getUserData(HIGHLIGHTING_SESSION);
        return map == null ? null : (HighlightingSession)map.get(psiFile);
    }

    @NotNull
    static HighlightingSession getOrCreateHighlightingSession(@NotNull PsiFile psiFile, @Nullable Editor editor, @NotNull DaemonProgressIndicator progressIndicator, @Nullable EditorColorsScheme editorColorsScheme) {
        HighlightingSession session = HighlightingSessionImpl.getHighlightingSession(psiFile, progressIndicator);
        if (session == null) {
            session = new HighlightingSessionImpl(psiFile, editor, progressIndicator, editorColorsScheme);
            ConcurrentMap map = (ConcurrentMap)progressIndicator.getUserData(HIGHLIGHTING_SESSION);
            if (map == null) {
                map = (ConcurrentMap)progressIndicator.putUserDataIfAbsent(HIGHLIGHTING_SESSION, ContainerUtil.newConcurrentMap());
            }
            session = (HighlightingSession)ConcurrencyUtil.cacheOrGet((ConcurrentMap)map, (Object)psiFile, (Object)session);
        }
        return session;
    }

    @Override
    @NotNull
    public PsiFile getPsiFile() {
        return this.myPsiFile;
    }

    @Override
    @Nullable
    public Editor getEditor() {
        return this.myEditor;
    }

    @Override
    @NotNull
    public Document getDocument() {
        return this.myDocument;
    }

    @Override
    @NotNull
    public ProgressIndicator getProgressIndicator() {
        return this.myProgressIndicator;
    }

    @Override
    @NotNull
    public Project getProject() {
        return this.myProject;
    }

    @Override
    public EditorColorsScheme getColorsScheme() {
        return this.myEditorColorsScheme;
    }

    void queueHighlightInfo(@NotNull HighlightInfo info, @NotNull TextRange priorityRange, @NotNull TextRange restrictedRange, int groupId) {
        this.myAddHighlighterInEDTQueue.offer((Object)new Info(info, restrictedRange, groupId));
    }

    void queueDisposeHighlighter(@Nullable RangeHighlighterEx highlighter) {
        if (highlighter == null) {
            return;
        }
        this.myDisposeHighlighterInEDTQueue.offer((Object)highlighter);
    }

    void waitForHighlightInfosApplied() {
        ApplicationManager.getApplication().assertIsDispatchThread();
        this.myAddHighlighterInEDTQueue.drain();
    }

    private static class Info {
        @NotNull
        private final HighlightInfo myInfo;
        @NotNull
        private final TextRange myRestrictRange;
        private final int myGroupId;

        private Info(@NotNull HighlightInfo info, @NotNull TextRange restrictRange, int groupId) {
            this.myInfo = info;
            this.myRestrictRange = restrictRange;
            this.myGroupId = groupId;
        }
    }
}

