/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.daemon.impl;

import com.intellij.codeInsight.daemon.impl.AnnotationHolderImpl;
import com.intellij.codeInsight.daemon.impl.DaemonCodeAnalyzerEx;
import com.intellij.codeInsight.daemon.impl.DefaultHighlightInfoProcessor;
import com.intellij.codeInsight.daemon.impl.ExternalToolPassFactory;
import com.intellij.codeInsight.daemon.impl.HighlightInfo;
import com.intellij.codeInsight.daemon.impl.HighlightInfoProcessor;
import com.intellij.codeInsight.daemon.impl.ProgressableTextEditorHighlightingPass;
import com.intellij.codeInsight.daemon.impl.UpdateHighlightersUtil;
import com.intellij.codeInsight.daemon.impl.analysis.HighlightingLevelManager;
import com.intellij.lang.ExternalLanguageAnnotators;
import com.intellij.lang.Language;
import com.intellij.lang.annotation.Annotation;
import com.intellij.lang.annotation.AnnotationHolder;
import com.intellij.lang.annotation.AnnotationSession;
import com.intellij.lang.annotation.ExternalAnnotator;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.application.ex.ApplicationManagerEx;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.FileViewProvider;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.util.containers.HashMap;
import com.intellij.util.ui.update.Update;
import java.awt.Component;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

public class ExternalToolPass
extends ProgressableTextEditorHighlightingPass {
    private final AnnotationHolderImpl myAnnotationHolder;
    private final Map<ExternalAnnotator, MyData> myAnnotator2DataMap = new HashMap();
    private final ExternalToolPassFactory myExternalToolPassFactory;
    private final boolean myMainHighlightingPass;

    public ExternalToolPass(@NotNull ExternalToolPassFactory externalToolPassFactory, @NotNull PsiFile file2, @NotNull Editor editor, int startOffset, int endOffset) {
        super(file2.getProject(), editor.getDocument(), "External annotators", file2, editor, new TextRange(startOffset, endOffset), false, new DefaultHighlightInfoProcessor());
        this.myAnnotationHolder = new AnnotationHolderImpl(new AnnotationSession(file2));
        this.myExternalToolPassFactory = externalToolPassFactory;
        this.myMainHighlightingPass = false;
    }

    ExternalToolPass(@NotNull ExternalToolPassFactory externalToolPassFactory, @NotNull PsiFile file2, @NotNull Document document, int startOffset, int endOffset, @NotNull HighlightInfoProcessor highlightInfoProcessor, boolean mainHighlightingPass) {
        super(file2.getProject(), document, "External annotators", file2, null, new TextRange(startOffset, endOffset), false, highlightInfoProcessor);
        this.myAnnotationHolder = new AnnotationHolderImpl(new AnnotationSession(file2));
        this.myExternalToolPassFactory = externalToolPassFactory;
        this.myMainHighlightingPass = mainHighlightingPass;
    }

    @Override
    protected void collectInformationWithProgress(@NotNull ProgressIndicator progress) {
        List externalAnnotators;
        PsiFile psiRoot;
        FileViewProvider viewProvider = this.myFile.getViewProvider();
        Set relevantLanguages = viewProvider.getLanguages();
        int externalAnnotatorsInRoots = 0;
        for (Language language : relevantLanguages) {
            psiRoot = viewProvider.getPsi(language);
            if (!HighlightingLevelManager.getInstance(this.myProject).shouldInspect((PsiElement)psiRoot)) continue;
            externalAnnotators = ExternalLanguageAnnotators.allForFile((Language)language, (PsiFile)psiRoot);
            externalAnnotatorsInRoots += externalAnnotators.size();
        }
        this.setProgressLimit(externalAnnotatorsInRoots);
        for (Language language : relevantLanguages) {
            psiRoot = viewProvider.getPsi(language);
            if (!HighlightingLevelManager.getInstance(this.myProject).shouldInspect((PsiElement)psiRoot) || (externalAnnotators = ExternalLanguageAnnotators.allForFile((Language)language, (PsiFile)psiRoot)).isEmpty()) continue;
            DaemonCodeAnalyzerEx daemonCodeAnalyzer = DaemonCodeAnalyzerEx.getInstanceEx(this.myProject);
            boolean errorFound = daemonCodeAnalyzer.getFileStatusMap().wasErrorFound(this.myDocument);
            for (ExternalAnnotator externalAnnotator : externalAnnotators) {
                Editor editor = this.getEditor();
                Object collectedInfo = editor != null ? externalAnnotator.collectInformation(psiRoot, editor, errorFound) : externalAnnotator.collectInformation(psiRoot);
                this.advanceProgress(1L);
                if (collectedInfo == null) continue;
                this.myAnnotator2DataMap.put(externalAnnotator, new MyData(psiRoot, collectedInfo));
            }
        }
    }

    @Override
    @NotNull
    public List<HighlightInfo> getInfos() {
        if (this.myProject.isDisposed()) {
            return Collections.emptyList();
        }
        if (this.myMainHighlightingPass) {
            this.doAnnotate();
            this.applyRelevant();
            return this.getHighlights();
        }
        return super.getInfos();
    }

    @Override
    protected void applyInformationWithProgress() {
        final long modificationStampBefore = this.myDocument.getModificationStamp();
        Update update = new Update(this.myFile){

            public void setRejected() {
                super.setRejected();
                ExternalToolPass.this.doFinish(ExternalToolPass.this.getHighlights(), modificationStampBefore);
            }

            public void run() {
                if (ExternalToolPass.this.documentChanged(modificationStampBefore) || ExternalToolPass.this.myProject.isDisposed()) {
                    return;
                }
                ExternalToolPass.this.doAnnotate();
                ApplicationManagerEx.getApplicationEx().tryRunReadAction(new Runnable(){

                    @Override
                    public void run() {
                        if (ExternalToolPass.this.documentChanged(modificationStampBefore) || ExternalToolPass.this.myProject.isDisposed()) {
                            return;
                        }
                        ExternalToolPass.this.applyRelevant();
                        ExternalToolPass.this.doFinish(ExternalToolPass.this.getHighlights(), modificationStampBefore);
                    }
                });
            }
        };
        this.myExternalToolPassFactory.scheduleExternalActivity(update);
    }

    private boolean documentChanged(long modificationStampBefore) {
        return this.myDocument.getModificationStamp() != modificationStampBefore;
    }

    @NotNull
    private List<HighlightInfo> getHighlights() {
        ArrayList<HighlightInfo> infos = new ArrayList<HighlightInfo>();
        Iterator iterator = this.myAnnotationHolder.iterator();
        while (iterator.hasNext()) {
            Annotation annotation = (Annotation)iterator.next();
            infos.add(HighlightInfo.fromAnnotation(annotation));
        }
        return infos;
    }

    private void applyRelevant() {
        for (ExternalAnnotator annotator : this.myAnnotator2DataMap.keySet()) {
            MyData data = this.myAnnotator2DataMap.get(annotator);
            if (data == null || data.myAnnotationResult == null) continue;
            annotator.apply(data.myPsiRoot, data.myAnnotationResult, (AnnotationHolder)this.myAnnotationHolder);
        }
    }

    private void doFinish(final @NotNull List<HighlightInfo> highlights, final long modificationStampBefore) {
        ApplicationManager.getApplication().invokeLater(new Runnable(){

            @Override
            public void run() {
                if (ExternalToolPass.this.documentChanged(modificationStampBefore) || ExternalToolPass.this.myProject.isDisposed()) {
                    return;
                }
                UpdateHighlightersUtil.setHighlightersToEditor(ExternalToolPass.this.myProject, ExternalToolPass.this.myDocument, ExternalToolPass.this.myRestrictRange.getStartOffset(), ExternalToolPass.this.myRestrictRange.getEndOffset(), highlights, ExternalToolPass.this.getColorsScheme(), ExternalToolPass.this.getId());
                DaemonCodeAnalyzerEx daemonCodeAnalyzer = DaemonCodeAnalyzerEx.getInstanceEx(ExternalToolPass.this.myProject);
                daemonCodeAnalyzer.getFileStatusMap().markFileUpToDate(ExternalToolPass.this.myDocument, ExternalToolPass.this.getId());
            }
        }, ModalityState.stateForComponent((Component)this.getEditor().getComponent()));
    }

    private void doAnnotate() {
        for (ExternalAnnotator annotator : DumbService.getInstance((Project)this.myProject).filterByDumbAwareness(this.myAnnotator2DataMap.keySet())) {
            MyData data = this.myAnnotator2DataMap.get(annotator);
            if (data == null) continue;
            data.myAnnotationResult = annotator.doAnnotate(data.myCollectedInfo);
        }
    }

    private static class MyData {
        private final PsiFile myPsiRoot;
        private final Object myCollectedInfo;
        private volatile Object myAnnotationResult;

        private MyData(@NotNull PsiFile psiRoot, @NotNull Object collectedInfo) {
            this.myPsiRoot = psiRoot;
            this.myCollectedInfo = collectedInfo;
        }
    }
}

