/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.daemon.impl;

import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.codeInspection.ex.InspectionToolWrapper;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.options.Configurable;
import com.intellij.openapi.options.ShowSettingsUtil;
import com.intellij.openapi.project.Project;
import com.intellij.profile.codeInspection.InspectionProfileManager;
import com.intellij.profile.codeInspection.InspectionProjectProfileManager;
import com.intellij.profile.codeInspection.ui.ProjectInspectionToolsConfigurable;
import com.intellij.psi.PsiFile;
import com.intellij.util.IncorrectOperationException;
import org.jetbrains.annotations.NotNull;

class EditCleanupProfileIntentionAction
implements IntentionAction {
    static final EditCleanupProfileIntentionAction INSTANCE = new EditCleanupProfileIntentionAction();

    private EditCleanupProfileIntentionAction() {
    }

    @NotNull
    public String getText() {
        return this.getFamilyName();
    }

    @NotNull
    public String getFamilyName() {
        return "Edit cleanup profile settings";
    }

    public boolean isAvailable(@NotNull Project project2, Editor editor, PsiFile file2) {
        return true;
    }

    public void invoke(@NotNull Project project2, Editor editor, PsiFile file2) throws IncorrectOperationException {
        InspectionProjectProfileManager profileManager = InspectionProjectProfileManager.getInstance(project2);
        ProjectInspectionToolsConfigurable configurable = new ProjectInspectionToolsConfigurable(InspectionProfileManager.getInstance(), profileManager){

            @Override
            protected boolean acceptTool(InspectionToolWrapper entry) {
                return super.acceptTool(entry) && entry.isCleanupTool();
            }

            @Override
            public String getDisplayName() {
                return "Code Cleanup Inspections";
            }
        };
        ShowSettingsUtil.getInstance().editConfigurable(project2, (Configurable)configurable);
    }

    public boolean startInWriteAction() {
        return false;
    }
}

