/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.daemon.impl;

import com.intellij.codeInsight.daemon.impl.ThreadLocalAnnotatorMap;
import com.intellij.lang.Language;
import com.intellij.lang.LanguageAnnotators;
import com.intellij.lang.annotation.Annotator;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.extensions.ExtensionPointListener;
import com.intellij.openapi.extensions.PluginDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.util.containers.ContainerUtil;
import java.util.Collection;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CachedAnnotators {
    private final ThreadLocalAnnotatorMap<String, Annotator> cachedAnnotators = new ThreadLocalAnnotatorMap<String, Annotator>(){

        @Override
        @NotNull
        public Collection<Annotator> initialValue(@NotNull String languageId) {
            Language language = Language.findLanguageByID((String)languageId);
            return language == null ? ContainerUtil.emptyList() : LanguageAnnotators.INSTANCE.allForLanguage(language);
        }
    };

    public CachedAnnotators(Project project2) {
        ExtensionPointListener<Annotator> listener2 = new ExtensionPointListener<Annotator>(){

            public void extensionAdded(@NotNull Annotator extension, @Nullable PluginDescriptor pluginDescriptor) {
                CachedAnnotators.this.cachedAnnotators.clear();
            }

            public void extensionRemoved(@NotNull Annotator extension, @Nullable PluginDescriptor pluginDescriptor) {
                CachedAnnotators.this.cachedAnnotators.clear();
            }
        };
        LanguageAnnotators.INSTANCE.addListener((ExtensionPointListener)listener2, (Disposable)project2);
    }

    @NotNull
    List<Annotator> get(@NotNull String languageId) {
        return this.cachedAnnotators.get(languageId);
    }
}

