/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.completion.scope;

import com.intellij.codeInsight.completion.CompletionUtil;
import com.intellij.codeInsight.completion.scope.CompletionElement;
import com.intellij.codeInsight.completion.scope.JavaCompletionHints;
import com.intellij.codeInsight.daemon.ImplicitUsageProvider;
import com.intellij.codeInspection.SuppressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.JavaRecursiveElementWalkingVisitor;
import com.intellij.psi.PsiAssignmentExpression;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiCompiledElement;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiEnumConstant;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionStatement;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiImportStatementBase;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiLocalVariable;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiMethodReferenceExpression;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiPackage;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiQualifiedReference;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiStatement;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.PsiSuperExpression;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.ResolveState;
import com.intellij.psi.filters.ElementFilter;
import com.intellij.psi.impl.light.LightMethodBuilder;
import com.intellij.psi.impl.source.resolve.JavaResolveUtil;
import com.intellij.psi.infos.CandidateInfo;
import com.intellij.psi.scope.BaseScopeProcessor;
import com.intellij.psi.scope.ElementClassHint;
import com.intellij.psi.scope.JavaScopeProcessorEvent;
import com.intellij.psi.scope.PsiScopeProcessor;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiTypesUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.hash.LinkedHashMap;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JavaCompletionProcessor
extends BaseScopeProcessor
implements ElementClassHint {
    private final boolean myInJavaDoc;
    private boolean myStatic = false;
    private PsiElement myDeclarationHolder = null;
    private final Map<CompletionElement, CompletionElement> myResults = new LinkedHashMap();
    private final Set<CompletionElement> mySecondRateResults = ContainerUtil.newIdentityTroveSet();
    private final Set<String> myShadowedNames = ContainerUtil.newHashSet();
    private final Set<String> myCurrentScopeMethodNames = ContainerUtil.newHashSet();
    private final Set<String> myFinishedScopesMethodNames = ContainerUtil.newHashSet();
    private final Set<PsiMethod> myMethodsToQualify = ContainerUtil.newHashSet();
    private final PsiElement myElement;
    private final PsiElement myScope;
    private final ElementFilter myFilter;
    private boolean myMembersFlag = false;
    private boolean myQualified = false;
    private PsiType myQualifierType = null;
    private PsiClass myQualifierClass = null;
    private final Condition<String> myMatcher;
    private final Options myOptions;
    private final Set<PsiField> myNonInitializedFields = new HashSet<PsiField>();
    private final boolean myAllowStaticWithInstanceQualifier;

    public JavaCompletionProcessor(@NotNull PsiElement element, ElementFilter filter, Options options, @NotNull Condition<String> nameCondition) {
        this.myOptions = options;
        this.myElement = element;
        this.myMatcher = nameCondition;
        this.myFilter = filter;
        PsiElement scope = element;
        this.myInJavaDoc = JavaResolveUtil.isInJavaDoc(this.myElement);
        if (this.myInJavaDoc) {
            this.myMembersFlag = true;
        }
        while (scope != null && !(scope instanceof PsiFile) && !(scope instanceof PsiClass)) {
            scope = scope.getContext();
        }
        this.myScope = scope;
        PsiElement elementParent = element.getContext();
        if (elementParent instanceof PsiReferenceExpression) {
            PsiExpression qualifier = ((PsiReferenceExpression)elementParent).getQualifierExpression();
            if (qualifier instanceof PsiSuperExpression) {
                PsiElement target;
                PsiJavaCodeReferenceElement qSuper = ((PsiSuperExpression)qualifier).getQualifier();
                this.myQualifierClass = qSuper == null ? JavaResolveUtil.getContextClass(this.myElement) : ((target = qSuper.resolve()) instanceof PsiClass ? (PsiClass)target : null);
            } else if (qualifier != null) {
                PsiElement target;
                this.myQualified = true;
                this.setQualifierType(qualifier.getType());
                if (this.myQualifierType == null && qualifier instanceof PsiJavaCodeReferenceElement && (target = ((PsiJavaCodeReferenceElement)qualifier).resolve()) instanceof PsiClass) {
                    this.myQualifierClass = (PsiClass)target;
                }
            } else {
                this.myQualifierClass = JavaResolveUtil.getContextClass(this.myElement);
            }
        }
        if (this.myQualifierClass != null && this.myQualifierType == null) {
            this.myQualifierType = JavaPsiFacade.getElementFactory((Project)element.getProject()).createType(this.myQualifierClass);
        }
        if (this.myOptions.checkInitialized) {
            this.myNonInitializedFields.addAll(JavaCompletionProcessor.getNonInitializedFields(element));
        }
        this.myAllowStaticWithInstanceQualifier = !options.filterStaticAfterInstance || SuppressManager.getInstance().isSuppressedFor(element, "AccessStaticViaInstance");
    }

    private static boolean isInitializedImplicitly(PsiField field) {
        field = CompletionUtil.getOriginalOrSelf(field);
        for (ImplicitUsageProvider provider : (ImplicitUsageProvider[])ImplicitUsageProvider.EP_NAME.getExtensions()) {
            if (!provider.isImplicitWrite((PsiElement)field)) continue;
            return true;
        }
        return false;
    }

    public static Set<PsiField> getNonInitializedFields(PsiElement element) {
        final PsiStatement statement2 = (PsiStatement)PsiTreeUtil.getParentOfType((PsiElement)element, PsiStatement.class);
        PsiMethod method = (PsiMethod)PsiTreeUtil.getParentOfType((PsiElement)element, PsiMethod.class, (boolean)true, (Class[])new Class[]{PsiClass.class});
        if (statement2 == null || method == null || !method.isConstructor()) {
            return Collections.emptySet();
        }
        PsiElement parent = element.getParent();
        while (parent != statement2) {
            PsiElement next = parent.getParent();
            if (next instanceof PsiAssignmentExpression && parent == ((PsiAssignmentExpression)next).getLExpression()) {
                return Collections.emptySet();
            }
            if (parent instanceof PsiReferenceExpression && next instanceof PsiExpressionStatement) {
                return Collections.emptySet();
            }
            parent = next;
        }
        final HashSet<PsiField> fields = new HashSet<PsiField>();
        PsiClass containingClass = method.getContainingClass();
        assert (containingClass != null);
        for (PsiField field : containingClass.getFields()) {
            if (field.hasModifierProperty("static") || field.getInitializer() != null || JavaCompletionProcessor.isInitializedImplicitly(field)) continue;
            fields.add(field);
        }
        method.accept((PsiElementVisitor)new JavaRecursiveElementWalkingVisitor(){

            public void visitAssignmentExpression(PsiAssignmentExpression expression) {
                PsiExpression lExpression;
                if (expression.getTextRange().getStartOffset() < statement2.getTextRange().getStartOffset() && (lExpression = expression.getLExpression()) instanceof PsiReferenceExpression) {
                    fields.remove(((PsiReferenceExpression)lExpression).resolve());
                }
                super.visitAssignmentExpression(expression);
            }

            public void visitMethodCallExpression(PsiMethodCallExpression expression) {
                PsiReferenceExpression methodExpression;
                if (expression.getTextRange().getStartOffset() < statement2.getTextRange().getStartOffset() && (methodExpression = expression.getMethodExpression()).textMatches((CharSequence)"this")) {
                    fields.clear();
                }
                super.visitMethodCallExpression(expression);
            }
        });
        return fields;
    }

    @Override
    public void handleEvent(@NotNull PsiScopeProcessor.Event event, Object associated) {
        if (event == JavaScopeProcessorEvent.START_STATIC) {
            this.myStatic = true;
        }
        if (event == JavaScopeProcessorEvent.CHANGE_LEVEL) {
            this.myMembersFlag = true;
            this.myFinishedScopesMethodNames.addAll(this.myCurrentScopeMethodNames);
            this.myCurrentScopeMethodNames.clear();
        }
        if (event == JavaScopeProcessorEvent.SET_CURRENT_FILE_CONTEXT) {
            this.myDeclarationHolder = (PsiElement)associated;
        }
    }

    public boolean execute(@NotNull PsiElement element, @NotNull ResolveState state) {
        StaticProblem sp;
        PsiType patchedType;
        PsiMethod method;
        if (this.myNonInitializedFields.contains(element)) {
            return true;
        }
        if (element instanceof PsiPackage && !this.isQualifiedContext()) {
            if (this.myScope instanceof PsiClass) {
                return true;
            }
            if (((PsiPackage)element).getQualifiedName().contains(".") && PsiTreeUtil.getParentOfType((PsiElement)this.myElement, PsiImportStatementBase.class) != null) {
                return true;
            }
        }
        if (element instanceof PsiMethod && PsiTypesUtil.isGetClass((PsiMethod)(method = (PsiMethod)element)) && PsiUtil.isLanguageLevel5OrHigher((PsiElement)this.myElement) && (patchedType = PsiTypesUtil.createJavaLangClassType((PsiElement)this.myElement, (PsiType)this.myQualifierType, (boolean)false)) != null) {
            element = new LightMethodBuilder(element.getManager(), method.getName()).addModifier("public").setMethodReturnType(patchedType).setContainingClass(method.getContainingClass());
        }
        if (element instanceof PsiVariable) {
            String name = ((PsiVariable)element).getName();
            if (this.myShadowedNames.contains(name)) {
                return true;
            }
            if (element instanceof PsiLocalVariable || element instanceof PsiParameter) {
                this.myShadowedNames.add(name);
            }
        }
        if (!this.satisfies((PsiElement)element, state) || !this.isAccessible((PsiElement)element)) {
            return true;
        }
        StaticProblem staticProblem = sp = this.myElement.getParent() instanceof PsiMethodReferenceExpression ? StaticProblem.none : this.getStaticProblem((PsiElement)element);
        if (sp == StaticProblem.instanceAfterStatic) {
            return true;
        }
        CompletionElement completion = new CompletionElement(element, (PsiSubstitutor)state.get(PsiSubstitutor.KEY));
        CompletionElement prev = this.myResults.get(completion);
        if (prev == null || completion.isMoreSpecificThan(prev)) {
            this.myResults.put(completion, completion);
            if (sp == StaticProblem.staticAfterInstance) {
                this.mySecondRateResults.add(completion);
            }
            if (element instanceof PsiMethod) {
                String name = ((PsiMethod)element).getName();
                this.myCurrentScopeMethodNames.add(name);
                if (this.myFinishedScopesMethodNames.contains(name)) {
                    this.myMethodsToQualify.add((PsiMethod)element);
                }
            }
        }
        return true;
    }

    public boolean shouldQualifyMethodCall(@NotNull PsiMethod method) {
        return this.myMethodsToQualify.contains(method);
    }

    private boolean isQualifiedContext() {
        PsiElement elementParent = this.myElement.getParent();
        return elementParent instanceof PsiQualifiedReference && ((PsiQualifiedReference)elementParent).getQualifier() != null;
    }

    private StaticProblem getStaticProblem(PsiElement element) {
        if (this.myOptions.showInstanceInStaticContext && !this.isQualifiedContext()) {
            return StaticProblem.none;
        }
        if (element instanceof PsiModifierListOwner) {
            PsiModifierListOwner modifierListOwner = (PsiModifierListOwner)element;
            if (this.myStatic) {
                if (!(element instanceof PsiClass) && !modifierListOwner.hasModifierProperty("static")) {
                    return StaticProblem.instanceAfterStatic;
                }
            } else if (!this.myAllowStaticWithInstanceQualifier && modifierListOwner.hasModifierProperty("static") && !this.myMembersFlag) {
                return StaticProblem.staticAfterInstance;
            }
        }
        return StaticProblem.none;
    }

    public boolean satisfies(@NotNull PsiElement element, @NotNull ResolveState state) {
        String name = PsiUtilCore.getName((PsiElement)element);
        return name != null && StringUtil.isNotEmpty((String)name) && this.myMatcher.value((Object)name) && this.myFilter.isClassAcceptable(element.getClass()) && this.myFilter.isAcceptable((Object)new CandidateInfo(element, (PsiSubstitutor)state.get(PsiSubstitutor.KEY)), this.myElement);
    }

    public void setQualifierType(@Nullable PsiType qualifierType) {
        this.myQualifierType = qualifierType;
        this.myQualifierClass = PsiUtil.resolveClassInClassTypeOnly((PsiType)qualifierType);
    }

    @Nullable
    public PsiType getQualifierType() {
        return this.myQualifierType;
    }

    public boolean isAccessible(@Nullable PsiElement element) {
        PsiClass accessObjectClass;
        if (!this.myOptions.checkAccess && this.myInJavaDoc) {
            return true;
        }
        if (!(element instanceof PsiMember)) {
            return true;
        }
        PsiMember member = (PsiMember)element;
        PsiClass psiClass = accessObjectClass = this.myQualified ? this.myQualifierClass : null;
        if (JavaPsiFacade.getInstance((Project)element.getProject()).getResolveHelper().isAccessible(member, member.getModifierList(), this.myElement, accessObjectClass, this.myDeclarationHolder)) {
            return true;
        }
        return !this.myOptions.checkAccess && !(element instanceof PsiCompiledElement);
    }

    public void setCompletionElements(@NotNull Object[] elements) {
        for (Object element : elements) {
            CompletionElement completion = new CompletionElement(element, PsiSubstitutor.EMPTY);
            this.myResults.put(completion, completion);
        }
    }

    public Iterable<CompletionElement> getResults() {
        if (this.mySecondRateResults.size() == this.myResults.size()) {
            return this.mySecondRateResults;
        }
        return ContainerUtil.filter(this.myResults.values(), element -> !this.mySecondRateResults.contains(element));
    }

    public void clear() {
        this.myResults.clear();
        this.mySecondRateResults.clear();
    }

    @Override
    public boolean shouldProcess(ElementClassHint.DeclarationKind kind) {
        switch (kind) {
            case CLASS: {
                return this.myFilter.isClassAcceptable(PsiClass.class);
            }
            case FIELD: {
                return this.myFilter.isClassAcceptable(PsiField.class);
            }
            case METHOD: {
                return this.myFilter.isClassAcceptable(PsiMethod.class);
            }
            case PACKAGE: {
                return this.myFilter.isClassAcceptable(PsiPackage.class);
            }
            case VARIABLE: {
                return this.myFilter.isClassAcceptable(PsiVariable.class);
            }
            case ENUM_CONST: {
                return this.myFilter.isClassAcceptable(PsiEnumConstant.class);
            }
        }
        return false;
    }

    @Override
    public <T> T getHint(@NotNull Key<T> hintKey) {
        if (hintKey == ElementClassHint.KEY) {
            return (T)this;
        }
        if (hintKey == JavaCompletionHints.NAME_FILTER) {
            return (T)this.myMatcher;
        }
        return super.getHint(hintKey);
    }

    private static enum StaticProblem {
        none,
        staticAfterInstance,
        instanceAfterStatic;

    }

    public static class Options {
        public static final Options DEFAULT_OPTIONS = new Options(true, false, true, false);
        public static final Options CHECK_NOTHING = new Options(false, false, false, false);
        final boolean checkAccess;
        final boolean checkInitialized;
        final boolean filterStaticAfterInstance;
        final boolean showInstanceInStaticContext;

        private Options(boolean checkAccess, boolean checkInitialized, boolean filterStaticAfterInstance, boolean showInstanceInStaticContext) {
            this.checkAccess = checkAccess;
            this.checkInitialized = checkInitialized;
            this.filterStaticAfterInstance = filterStaticAfterInstance;
            this.showInstanceInStaticContext = showInstanceInStaticContext;
        }

        public Options withInitialized(boolean checkInitialized) {
            return new Options(this.checkAccess, checkInitialized, this.filterStaticAfterInstance, this.showInstanceInStaticContext);
        }

        public Options withCheckAccess(boolean checkAccess) {
            return new Options(checkAccess, this.checkInitialized, this.filterStaticAfterInstance, this.showInstanceInStaticContext);
        }

        public Options withFilterStaticAfterInstance(boolean filterStaticAfterInstance) {
            return new Options(this.checkAccess, this.checkInitialized, filterStaticAfterInstance, this.showInstanceInStaticContext);
        }

        public Options withShowInstanceInStaticContext(boolean showInstanceInStaticContext) {
            return new Options(this.checkAccess, this.checkInitialized, this.filterStaticAfterInstance, showInstanceInStaticContext);
        }
    }
}

